/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.io.IOException;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.security.SFile;
import net.sourceforge.plantuml.security.SecurityUtils;

public class FileSystem {
    private static final FileSystem singleton = new FileSystem();
    private final ThreadLocal<SFile> currentDir = new ThreadLocal();

    private FileSystem() {
        this.reset();
    }

    public static FileSystem getInstance() {
        return singleton;
    }

    public void setCurrentDir(SFile dir) {
        if (dir != null) {
            Log.info("Setting current dir: " + dir.getAbsolutePath());
        }
        this.currentDir.set(dir);
    }

    public SFile getCurrentDir() {
        return this.currentDir.get();
    }

    public SFile getFile(String nameOrPath) throws IOException {
        SFile file;
        if (this.isAbsolute(nameOrPath)) {
            return new SFile(nameOrPath).getCanonicalFile();
        }
        SFile dir = this.currentDir.get();
        SFile filecurrent = null;
        if (dir != null && (filecurrent = dir.getAbsoluteFile().file(nameOrPath)).exists()) {
            return filecurrent.getCanonicalFile();
        }
        for (SFile d : SecurityUtils.getPath("plantuml.include.path")) {
            assert (d.isDirectory());
            file = d.file(nameOrPath);
            if (!file.exists()) continue;
            return file.getCanonicalFile();
        }
        for (SFile d : SecurityUtils.getPath("java.class.path")) {
            assert (d.isDirectory());
            file = d.file(nameOrPath);
            if (!file.exists()) continue;
            return file.getCanonicalFile();
        }
        if (dir == null) {
            assert (filecurrent == null);
            return new SFile(nameOrPath).getCanonicalFile();
        }
        assert (filecurrent != null);
        return filecurrent;
    }

    private boolean isAbsolute(String nameOrPath) {
        SFile f = new SFile(nameOrPath);
        return f.isAbsolute();
    }

    public void reset() {
        this.setCurrentDir(new SFile("."));
    }
}

