/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.creole.command;

import net.sourceforge.plantuml.command.regex.Matcher2;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.command.regex.Pattern2;
import net.sourceforge.plantuml.creole.command.Command;
import net.sourceforge.plantuml.creole.legacy.StripeSimple;
import net.sourceforge.plantuml.graphic.AddStyle;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.FontStyle;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public class CommandCreoleStyle
implements Command {
    private final Pattern2 p;
    private final FontStyle style;
    private final boolean tryExtendedColor;

    public static CommandCreoleStyle createCreole(FontStyle style) {
        return new CommandCreoleStyle("^(" + style.getCreoleSyntax() + "(.+?)" + style.getCreoleSyntax() + ")", style, false);
    }

    public static Command createLegacy(FontStyle style) {
        return new CommandCreoleStyle("^((" + style.getActivationPattern() + ")(.+?)" + style.getDeactivationPattern() + ")", style, style.canHaveExtendedColor());
    }

    public static Command createLegacyEol(FontStyle style) {
        return new CommandCreoleStyle("^((" + style.getActivationPattern() + ")(.+))$", style, style.canHaveExtendedColor());
    }

    private CommandCreoleStyle(String p, FontStyle style, boolean tryExtendedColor) {
        this.p = MyPattern.cmpile(p);
        this.style = style;
        this.tryExtendedColor = tryExtendedColor;
    }

    private HColor getExtendedColor(Matcher2 m) {
        if (this.tryExtendedColor) {
            return this.style.getExtendedColor(m.group(2));
        }
        return null;
    }

    @Override
    public String executeAndGetRemaining(String line, StripeSimple stripe) {
        Matcher2 m = this.p.matcher(line);
        if (!m.find()) {
            throw new IllegalStateException();
        }
        FontConfiguration fc1 = stripe.getActualFontConfiguration();
        FontConfiguration fc2 = new AddStyle(this.style, this.getExtendedColor(m)).apply(fc1);
        stripe.setActualFontConfiguration(fc2);
        int groupCount = m.groupCount();
        stripe.analyzeAndAdd(m.group(groupCount));
        stripe.setActualFontConfiguration(fc1);
        return line.substring(m.group(1).length());
    }

    @Override
    public int matchingSize(String line) {
        Matcher2 m = this.p.matcher(line);
        if (!m.find()) {
            return 0;
        }
        return m.group(1).length();
    }
}

