/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.cucadiagram.Bodier;
import net.sourceforge.plantuml.cucadiagram.BodyEnhanced;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.cucadiagram.Member;
import net.sourceforge.plantuml.cucadiagram.MethodsOrFieldsArea;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockLineBefore;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.skin.VisibilityModifier;
import net.sourceforge.plantuml.style.SName;

public class BodierImpl
implements Bodier {
    private final List<String> rawBody = new ArrayList<String>();
    private final Set<VisibilityModifier> hides;
    private LeafType type;
    private List<Member> methodsToDisplay;
    private List<Member> fieldsToDisplay;
    private final boolean manageModifier;
    private ILeaf leaf;

    @Override
    public void muteClassToObject() {
        this.methodsToDisplay = null;
        this.fieldsToDisplay = null;
        this.type = LeafType.OBJECT;
    }

    public BodierImpl(LeafType type, Set<VisibilityModifier> hides) {
        if (type == LeafType.MAP) {
            throw new IllegalArgumentException();
        }
        this.hides = hides;
        this.type = type;
        this.manageModifier = type == null ? false : type.manageModifier();
    }

    @Override
    public void setLeaf(ILeaf leaf) {
        if (leaf == null) {
            throw new IllegalArgumentException();
        }
        this.leaf = leaf;
    }

    @Override
    public void addFieldOrMethod(String s) {
        this.methodsToDisplay = null;
        this.fieldsToDisplay = null;
        this.rawBody.add(s);
    }

    private boolean isBodyEnhanced() {
        for (String s : this.rawBody) {
            if (!BodyEnhanced.isBlockSeparator(s)) continue;
            return true;
        }
        return false;
    }

    private boolean isMethod(String s) {
        if (this.type == LeafType.ANNOTATION || this.type == LeafType.ABSTRACT_CLASS || this.type == LeafType.CLASS || this.type == LeafType.INTERFACE || this.type == LeafType.ENUM) {
            return Member.isMethod(s);
        }
        return false;
    }

    @Override
    public List<Member> getMethodsToDisplay() {
        if (this.methodsToDisplay == null) {
            this.methodsToDisplay = new ArrayList<Member>();
            for (int i = 0; i < this.rawBody.size(); ++i) {
                String s = this.rawBody.get(i);
                if (!this.isMethod(i, this.rawBody) || s.length() == 0 && this.methodsToDisplay.size() == 0) continue;
                Member m = new Member(s, true, this.manageModifier);
                if (this.hides != null && this.hides.contains((Object)m.getVisibilityModifier())) continue;
                this.methodsToDisplay.add(m);
            }
            this.removeFinalEmptyMembers(this.methodsToDisplay);
        }
        return Collections.unmodifiableList(this.methodsToDisplay);
    }

    private boolean isMethod(int i, List<String> rawBody) {
        if (i > 0 && i < rawBody.size() - 1 && rawBody.get(i).length() == 0 && this.isMethod(rawBody.get(i - 1)) && this.isMethod(rawBody.get(i + 1))) {
            return true;
        }
        return this.isMethod(rawBody.get(i));
    }

    @Override
    public List<Member> getFieldsToDisplay() {
        if (this.fieldsToDisplay == null) {
            this.fieldsToDisplay = new ArrayList<Member>();
            for (String s : this.rawBody) {
                if (this.isMethod(s) || s.length() == 0 && this.fieldsToDisplay.size() == 0) continue;
                Member m = new Member(s, false, this.manageModifier);
                if (this.hides != null && this.hides.contains((Object)m.getVisibilityModifier())) continue;
                this.fieldsToDisplay.add(m);
            }
            this.removeFinalEmptyMembers(this.fieldsToDisplay);
        }
        return Collections.unmodifiableList(this.fieldsToDisplay);
    }

    private void removeFinalEmptyMembers(List<Member> result) {
        while (result.size() > 0 && StringUtils.trin(result.get(result.size() - 1).getDisplay(false)).length() == 0) {
            result.remove(result.size() - 1);
        }
    }

    @Override
    public boolean hasUrl() {
        for (Member m : this.getFieldsToDisplay()) {
            if (!m.hasUrl()) continue;
            return true;
        }
        for (Member m : this.getMethodsToDisplay()) {
            if (!m.hasUrl()) continue;
            return true;
        }
        return false;
    }

    private List<String> rawBodyWithoutHidden() {
        if (this.hides == null || this.hides.size() == 0) {
            return this.rawBody;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String s : this.rawBody) {
            Member m = new Member(s, this.isMethod(s), this.manageModifier);
            if (this.hides.contains((Object)m.getVisibilityModifier())) continue;
            result.add(s);
        }
        return result;
    }

    @Override
    public TextBlock getBody(FontParam fontParam, ISkinParam skinParam, boolean showMethods, boolean showFields, Stereotype stereotype) {
        if (this.type.isLikeClass() && this.isBodyEnhanced()) {
            if (showMethods || showFields) {
                return new BodyEnhanced(this.rawBodyWithoutHidden(), fontParam, skinParam, this.manageModifier, stereotype, this.leaf, SName.classDiagram);
            }
            return null;
        }
        if (this.leaf == null) {
            throw new IllegalStateException();
        }
        MethodsOrFieldsArea fields = new MethodsOrFieldsArea(this.getFieldsToDisplay(), fontParam, skinParam, stereotype, this.leaf, SName.classDiagram);
        if (this.type == LeafType.OBJECT) {
            if (!showFields) {
                return new TextBlockLineBefore(TextBlockUtils.empty(0.0, 0.0));
            }
            return new BodyEnhanced(this.rawBodyWithoutHidden(), fontParam, skinParam, this.manageModifier, stereotype, this.leaf, SName.objectDiagram);
        }
        if (!this.type.isLikeClass()) {
            throw new UnsupportedOperationException();
        }
        MethodsOrFieldsArea methods = new MethodsOrFieldsArea(this.getMethodsToDisplay(), fontParam, skinParam, stereotype, this.leaf, SName.classDiagram);
        if (showFields && !showMethods) {
            return fields.asBlockMemberImpl();
        }
        if (showMethods && !showFields) {
            return methods.asBlockMemberImpl();
        }
        if (!showFields && !showMethods) {
            return TextBlockUtils.empty(0.0, 0.0);
        }
        TextBlock bb1 = fields.asBlockMemberImpl();
        TextBlock bb2 = methods.asBlockMemberImpl();
        return TextBlockUtils.mergeTB(bb1, bb2, HorizontalAlignment.LEFT);
    }

    @Override
    public List<String> getRawBody() {
        return Collections.unmodifiableList(this.rawBody);
    }
}

