/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.timescale;

import net.sourceforge.plantuml.project.time.Day;
import net.sourceforge.plantuml.project.timescale.TimeScale;
import net.sourceforge.plantuml.project.timescale.TimeScaleWink;

public final class TimeScaleDaily
implements TimeScale {
    private final TimeScaleWink basic = new TimeScaleWink();
    private final double delta;

    public TimeScaleDaily(Day calendar, Day zeroDay) {
        this.delta = zeroDay == null ? this.basic.getStartingPosition(calendar) : this.basic.getStartingPosition(zeroDay);
    }

    @Override
    public double getStartingPosition(Day instant) {
        return this.basic.getStartingPosition(instant) - this.delta;
    }

    @Override
    public double getEndingPosition(Day instant) {
        return this.basic.getEndingPosition(instant) - this.delta;
    }

    @Override
    public double getWidth(Day instant) {
        return this.basic.getWidth(instant);
    }

    @Override
    public boolean isBreaking(Day instant) {
        return true;
    }
}

