/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.timingdiagram.graphic;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.command.Position;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.graphic.color.Colors;
import net.sourceforge.plantuml.timingdiagram.ChangeState;
import net.sourceforge.plantuml.timingdiagram.TimeConstraint;
import net.sourceforge.plantuml.timingdiagram.TimeTick;
import net.sourceforge.plantuml.timingdiagram.TimingNote;
import net.sourceforge.plantuml.timingdiagram.TimingRuler;
import net.sourceforge.plantuml.timingdiagram.graphic.HexaShape;
import net.sourceforge.plantuml.timingdiagram.graphic.IntricatedPoint;
import net.sourceforge.plantuml.timingdiagram.graphic.PDrawing;
import net.sourceforge.plantuml.timingdiagram.graphic.PentaAShape;
import net.sourceforge.plantuml.timingdiagram.graphic.PentaBShape;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public class Ribbon
implements PDrawing {
    private final List<ChangeState> changes = new ArrayList<ChangeState>();
    private final List<TimeConstraint> constraints = new ArrayList<TimeConstraint>();
    private final ISkinParam skinParam;
    private final TimingRuler ruler;
    private String initialState;
    private Colors initialColors;
    private final List<TimingNote> notes;
    private final boolean compact;
    private final TextBlock title;
    private final int suggestedHeight;

    public Ribbon(TimingRuler ruler, ISkinParam skinParam, List<TimingNote> notes, boolean compact, TextBlock title, int suggestedHeight) {
        this.suggestedHeight = suggestedHeight == 0 ? 24 : suggestedHeight;
        this.compact = compact;
        this.ruler = ruler;
        this.skinParam = skinParam;
        this.notes = notes;
        this.title = title;
    }

    @Override
    public IntricatedPoint getTimeProjection(StringBounder stringBounder, TimeTick tick) {
        double x = this.ruler.getPosInPixel(tick);
        double y = this.getHeightForConstraints(stringBounder) + this.getHeightForNotes(stringBounder, Position.TOP) + this.getHeightForTopComment(stringBounder) + this.getRibbonHeight() / 2.0;
        for (ChangeState change : this.changes) {
            if (change.getWhen().compareTo(tick) != 0) continue;
            return new IntricatedPoint(new Point2D.Double(x, y), new Point2D.Double(x, y));
        }
        return new IntricatedPoint(new Point2D.Double(x, y - this.getRibbonHeight() / 2.0), new Point2D.Double(x, y + this.getRibbonHeight() / 2.0));
    }

    @Override
    public void addChange(ChangeState change) {
        this.changes.add(change);
    }

    private double getPosInPixel(ChangeState change) {
        return this.ruler.getPosInPixel(change.getWhen());
    }

    private FontConfiguration getFontConfiguration() {
        return new FontConfiguration(this.skinParam, FontParam.TIMING, null);
    }

    private TextBlock createTextBlock(String value) {
        Display display = Display.getWithNewlines(value);
        return display.create(this.getFontConfiguration(), HorizontalAlignment.LEFT, this.skinParam);
    }

    @Override
    public TextBlock getPart1(double fullAvailableWidth) {
        return new AbstractTextBlock(){

            @Override
            public void drawU(UGraphic ug) {
                if (Ribbon.this.compact) {
                    double titleHeight = Ribbon.this.title.calculateDimension(ug.getStringBounder()).getHeight();
                    double dy = (Ribbon.this.getRibbonHeight() - titleHeight) / 2.0;
                    Ribbon.this.title.drawU(ug.apply(UTranslate.dy(dy)));
                }
            }

            @Override
            public Dimension2D calculateDimension(StringBounder stringBounder) {
                double width = Ribbon.this.getInitialWidth(stringBounder);
                if (Ribbon.this.compact) {
                    width += Ribbon.this.title.calculateDimension(stringBounder).getWidth() + 10.0;
                }
                return new Dimension2DDouble(width, Ribbon.this.getRibbonHeight());
            }
        };
    }

    @Override
    public UDrawable getPart2() {
        return new UDrawable(){

            @Override
            public void drawU(UGraphic ug) {
                Ribbon.this.drawPart2(ug);
            }
        };
    }

    private void drawNotes(UGraphic ug, Position position) {
        for (TimingNote note : this.notes) {
            if (note.getPosition() != position) continue;
            double x = this.ruler.getPosInPixel(note.getWhen());
            note.drawU(ug.apply(UTranslate.dx(x)));
        }
    }

    private double getInitialWidth(StringBounder stringBounder) {
        if (this.initialState == null) {
            return 0.0;
        }
        return this.createTextBlock(this.initialState).calculateDimension(stringBounder).getWidth() + 24.0;
    }

    private void drawHexa(UGraphic ug, double len, ChangeState change) {
        HexaShape shape = HexaShape.create(len, this.getRibbonHeight(), change.getContext());
        shape.drawU(ug);
    }

    private void drawFlat(UGraphic ug, double len, ChangeState change) {
        ULine line = ULine.hline(len);
        change.getContext().apply(ug).apply(UTranslate.dy(this.getRibbonHeight() / 2.0)).draw(line);
    }

    private double getRibbonHeight() {
        return this.suggestedHeight;
    }

    private void drawPentaB(UGraphic ug, double len, ChangeState change) {
        PentaBShape shape = PentaBShape.create(len, this.getRibbonHeight(), change.getContext());
        shape.drawU(ug);
    }

    private void drawPentaA(UGraphic ug, double len, ChangeState change) {
        SymbolContext context = change.getContext();
        HColor back = this.initialColors.getColor(ColorType.BACK);
        if (back != null) {
            context = context.withBackColor(back);
        }
        PentaAShape shape = PentaAShape.create(len, this.getRibbonHeight(), context);
        shape.drawU(ug);
    }

    private double getHeightForConstraints(StringBounder stringBounder) {
        return TimeConstraint.getHeightForConstraints(stringBounder, this.constraints);
    }

    private double getHeightForNotes(StringBounder stringBounder, Position position) {
        double height = 0.0;
        for (TimingNote note : this.notes) {
            if (note.getPosition() != position) continue;
            height = Math.max(height, note.getHeight(stringBounder));
        }
        return height;
    }

    private double getMarginX() {
        return 12.0;
    }

    @Override
    public void setInitialState(String initialState, Colors initialColors) {
        this.initialState = initialState;
        this.initialColors = initialColors;
    }

    @Override
    public void addConstraint(TimeConstraint constraint) {
        this.constraints.add(constraint);
    }

    @Override
    public double getFullHeight(StringBounder stringBounder) {
        return this.getHeightForConstraints(stringBounder) + this.getHeightForTopComment(stringBounder) + this.getHeightForNotes(stringBounder, Position.TOP) + this.getRibbonHeight() + this.getHeightForNotes(stringBounder, Position.BOTTOM) + this.getBottomMargin();
    }

    private double getBottomMargin() {
        return 10.0;
    }

    private void drawPart2(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        UGraphic ugRibbon = ug.apply(UTranslate.dy(this.getHeightForConstraints(stringBounder) + this.getHeightForTopComment(stringBounder) + this.getHeightForNotes(stringBounder, Position.TOP)));
        this.drawBeforeZeroState(ugRibbon);
        this.drawBeforeZeroStateLabel(ugRibbon.apply(UTranslate.dy(this.getRibbonHeight() / 2.0)));
        this.drawStates(ugRibbon);
        this.drawStatesLabels(ugRibbon.apply(UTranslate.dy(this.getRibbonHeight() / 2.0)));
        this.drawConstraints(ug.apply(UTranslate.dy(this.getHeightForConstraints(stringBounder) / 2.0)));
        this.drawNotes(ug, Position.TOP);
        this.drawNotes(ug.apply(UTranslate.dy(this.getHeightForConstraints(stringBounder) + this.getRibbonHeight() + this.getHeightForNotes(stringBounder, Position.TOP))), Position.BOTTOM);
    }

    private void drawBeforeZeroState(UGraphic ug) {
        if (this.initialState != null && this.changes.size() > 0) {
            StringBounder stringBounder = ug.getStringBounder();
            double a = this.getPosInPixel(this.changes.get(0));
            this.drawPentaA(ug.apply(UTranslate.dx(-this.getInitialWidth(stringBounder))), this.getInitialWidth(stringBounder) + a, this.changes.get(0));
        }
    }

    private void drawBeforeZeroStateLabel(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        if (this.initialState != null) {
            TextBlock initial = this.createTextBlock(this.initialState);
            Dimension2D dimInital = initial.calculateDimension(stringBounder);
            initial.drawU(ug.apply(new UTranslate(-this.getMarginX() - dimInital.getWidth(), -dimInital.getHeight() / 2.0)));
        }
    }

    private void drawStates(UGraphic ug) {
        double a;
        for (int i = 0; i < this.changes.size() - 1; ++i) {
            a = this.getPosInPixel(this.changes.get(i));
            double b = this.getPosInPixel(this.changes.get(i + 1));
            assert (b > a);
            if (this.changes.get(i).isFlat()) {
                this.drawFlat(ug.apply(UTranslate.dx(a)), b - a, this.changes.get(i));
                continue;
            }
            if (this.changes.get(i).isCompletelyHidden()) continue;
            this.drawHexa(ug.apply(UTranslate.dx(a)), b - a, this.changes.get(i));
        }
        if (this.changes.size() >= 1) {
            ChangeState last = this.changes.get(this.changes.size() - 1);
            a = this.getPosInPixel(last);
            if (last.isFlat()) {
                this.drawFlat(ug.apply(UTranslate.dx(a)), this.ruler.getWidth() - a, last);
            } else if (!last.isCompletelyHidden()) {
                this.drawPentaB(ug.apply(UTranslate.dx(a)), this.ruler.getWidth() - a, last);
            }
        }
    }

    private void drawStatesLabels(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        for (int i = 0; i < this.changes.size(); ++i) {
            ChangeState change = this.changes.get(i);
            double x = this.ruler.getPosInPixel(change.getWhen());
            if (!(change.isBlank() || change.isCompletelyHidden() || change.isFlat())) {
                double xtext;
                TextBlock state = this.createTextBlock(change.getState());
                Dimension2D dim = state.calculateDimension(stringBounder);
                if (i == this.changes.size() - 1) {
                    xtext = x + this.getMarginX();
                } else {
                    double x2 = this.ruler.getPosInPixel(this.changes.get(i + 1).getWhen());
                    xtext = (x + x2) / 2.0 - dim.getWidth() / 2.0;
                }
                state.drawU(ug.apply(new UTranslate(xtext, -dim.getHeight() / 2.0)));
            }
            TextBlock commentTopBlock = this.getCommentTopBlock(change);
            Dimension2D dimComment = commentTopBlock.calculateDimension(stringBounder);
            commentTopBlock.drawU(ug.apply(new UTranslate(x + this.getMarginX(), -this.getRibbonHeight() / 2.0 - dimComment.getHeight())));
        }
    }

    private TextBlock getCommentTopBlock(ChangeState change) {
        if (change.getComment() == null) {
            return TextBlockUtils.empty(0.0, 0.0);
        }
        return this.createTextBlock(change.getComment());
    }

    private double getHeightForTopComment(StringBounder stringBounder) {
        double result = 0.0;
        for (ChangeState change : this.changes) {
            result = Math.max(result, this.getCommentTopBlock(change).calculateDimension(stringBounder).getHeight());
        }
        return result;
    }

    private void drawConstraints(UGraphic ug) {
        for (TimeConstraint constraint : this.constraints) {
            constraint.drawU(ug, this.ruler);
        }
    }
}

