/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http2;

import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.coyote.http2.HPackHuffman;
import org.apache.coyote.http2.Hpack;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.http.MimeHeaders;
import org.apache.tomcat.util.res.StringManager;

class HpackEncoder {
    private static final Log log = LogFactory.getLog(HpackEncoder.class);
    private static final StringManager sm = StringManager.getManager(HpackEncoder.class);
    private static final HpackHeaderFunction DEFAULT_HEADER_FUNCTION = new HpackHeaderFunction(){

        @Override
        public boolean shouldUseIndexing(String string, String string2) {
            switch (string) {
                case "content-length": 
                case "date": {
                    return false;
                }
            }
            return true;
        }

        @Override
        public boolean shouldUseHuffman(String string, String string2) {
            return string2.length() > 5;
        }

        @Override
        public boolean shouldUseHuffman(String string) {
            return string.length() > 5;
        }
    };
    private int headersIterator = -1;
    private boolean firstPass = true;
    private MimeHeaders currentHeaders;
    private int entryPositionCounter;
    private int newMaxHeaderSize = -1;
    private int minNewMaxHeaderSize = -1;
    private static final Map<String, TableEntry[]> ENCODING_STATIC_TABLE;
    private final Deque<TableEntry> evictionQueue = new ArrayDeque<TableEntry>();
    private final Map<String, List<TableEntry>> dynamicTable = new HashMap<String, List<TableEntry>>();
    private int maxTableSize = 4096;
    private int currentTableSize;
    private final HpackHeaderFunction hpackHeaderFunction = DEFAULT_HEADER_FUNCTION;

    HpackEncoder() {
    }

    State encode(MimeHeaders mimeHeaders, ByteBuffer byteBuffer) {
        int n = this.headersIterator;
        if (this.headersIterator == -1) {
            this.handleTableSizeChange(byteBuffer);
            n = 0;
            this.currentHeaders = mimeHeaders;
        } else if (mimeHeaders != this.currentHeaders) {
            throw new IllegalStateException();
        }
        while (n < this.currentHeaders.size()) {
            String string = mimeHeaders.getName(n).toString().toLowerCase(Locale.US);
            boolean bl = false;
            if (this.firstPass) {
                if (string.charAt(0) != ':') {
                    bl = true;
                }
            } else if (string.charAt(0) == ':') {
                bl = true;
            }
            if (!bl) {
                boolean bl2;
                String string2 = mimeHeaders.getValue(n).toString();
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("hpackEncoder.encodeHeader", new Object[]{string, string2}));
                }
                TableEntry tableEntry = this.findInTable(string, string2);
                int n2 = 11 + string.length() + 1 + string2.length();
                if (byteBuffer.remaining() < n2) {
                    this.headersIterator = n;
                    return State.UNDERFLOW;
                }
                boolean bl3 = bl2 = this.hpackHeaderFunction.shouldUseIndexing(string, string2) && string.length() + string2.length() + 32 < this.maxTableSize;
                if (tableEntry == null && bl2) {
                    byteBuffer.put((byte)64);
                    this.writeHuffmanEncodableName(byteBuffer, string);
                    this.writeHuffmanEncodableValue(byteBuffer, string, string2);
                    this.addToDynamicTable(string, string2);
                } else if (tableEntry == null) {
                    byteBuffer.put((byte)16);
                    this.writeHuffmanEncodableName(byteBuffer, string);
                    this.writeHuffmanEncodableValue(byteBuffer, string, string2);
                } else if (string2.equals(tableEntry.value)) {
                    byteBuffer.put((byte)-128);
                    Hpack.encodeInteger(byteBuffer, tableEntry.getPosition(), 7);
                } else if (bl2) {
                    byteBuffer.put((byte)64);
                    Hpack.encodeInteger(byteBuffer, tableEntry.getPosition(), 6);
                    this.writeHuffmanEncodableValue(byteBuffer, string, string2);
                    this.addToDynamicTable(string, string2);
                } else {
                    byteBuffer.put((byte)16);
                    Hpack.encodeInteger(byteBuffer, tableEntry.getPosition(), 4);
                    this.writeHuffmanEncodableValue(byteBuffer, string, string2);
                }
            }
            if (++n != this.currentHeaders.size() || !this.firstPass) continue;
            this.firstPass = false;
            n = 0;
        }
        this.headersIterator = -1;
        this.firstPass = true;
        return State.COMPLETE;
    }

    private void writeHuffmanEncodableName(ByteBuffer byteBuffer, String string) {
        if (this.hpackHeaderFunction.shouldUseHuffman(string) && HPackHuffman.encode(byteBuffer, string, true)) {
            return;
        }
        byteBuffer.put((byte)0);
        Hpack.encodeInteger(byteBuffer, string.length(), 7);
        for (int i = 0; i < string.length(); ++i) {
            byteBuffer.put((byte)Hpack.toLower(string.charAt(i)));
        }
    }

    private void writeHuffmanEncodableValue(ByteBuffer byteBuffer, String string, String string2) {
        if (this.hpackHeaderFunction.shouldUseHuffman(string, string2)) {
            if (!HPackHuffman.encode(byteBuffer, string2, false)) {
                this.writeValueString(byteBuffer, string2);
            }
        } else {
            this.writeValueString(byteBuffer, string2);
        }
    }

    private void writeValueString(ByteBuffer byteBuffer, String string) {
        byteBuffer.put((byte)0);
        Hpack.encodeInteger(byteBuffer, string.length(), 7);
        for (int i = 0; i < string.length(); ++i) {
            byteBuffer.put((byte)string.charAt(i));
        }
    }

    private void addToDynamicTable(String string, String string2) {
        int n = this.entryPositionCounter++;
        DynamicTableEntry dynamicTableEntry = new DynamicTableEntry(string, string2, -n);
        List<TableEntry> list = this.dynamicTable.get(string);
        if (list == null) {
            list = new ArrayList<TableEntry>(1);
            this.dynamicTable.put(string, list);
        }
        list.add(dynamicTableEntry);
        this.evictionQueue.add(dynamicTableEntry);
        this.currentTableSize += dynamicTableEntry.getSize();
        this.runEvictionIfRequired();
        if (this.entryPositionCounter == Integer.MAX_VALUE) {
            this.preventPositionRollover();
        }
    }

    private void preventPositionRollover() {
        for (List<TableEntry> list : this.dynamicTable.values()) {
            for (TableEntry tableEntry : list) {
                tableEntry.position = tableEntry.getPosition();
            }
        }
        this.entryPositionCounter = 0;
    }

    private void runEvictionIfRequired() {
        while (this.currentTableSize > this.maxTableSize) {
            TableEntry tableEntry = this.evictionQueue.poll();
            if (tableEntry == null) {
                return;
            }
            this.currentTableSize -= tableEntry.size;
            List<TableEntry> list = this.dynamicTable.get(tableEntry.name);
            list.remove(tableEntry);
            if (!list.isEmpty()) continue;
            this.dynamicTable.remove(tableEntry.name);
        }
    }

    private TableEntry findInTable(String string, String string2) {
        Object object;
        TableEntry[] tableEntryArray = ENCODING_STATIC_TABLE.get(string);
        if (tableEntryArray != null) {
            object = tableEntryArray;
            int n = ((TableEntry[])object).length;
            for (int i = 0; i < n; ++i) {
                Object object2 = object[i];
                if (((TableEntry)object2).value == null || !((TableEntry)object2).value.equals(string2)) continue;
                return object2;
            }
        }
        if ((object = this.dynamicTable.get(string)) != null) {
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                TableEntry tableEntry = (TableEntry)iterator.next();
                if (!tableEntry.value.equals(string2)) continue;
                return tableEntry;
            }
        }
        if (tableEntryArray != null) {
            return tableEntryArray[0];
        }
        return null;
    }

    public void setMaxTableSize(int n) {
        this.newMaxHeaderSize = n;
        this.minNewMaxHeaderSize = this.minNewMaxHeaderSize == -1 ? n : Math.min(n, this.minNewMaxHeaderSize);
    }

    private void handleTableSizeChange(ByteBuffer byteBuffer) {
        if (this.newMaxHeaderSize == -1) {
            return;
        }
        if (this.minNewMaxHeaderSize != this.newMaxHeaderSize) {
            byteBuffer.put((byte)32);
            Hpack.encodeInteger(byteBuffer, this.minNewMaxHeaderSize, 5);
        }
        byteBuffer.put((byte)32);
        Hpack.encodeInteger(byteBuffer, this.newMaxHeaderSize, 5);
        this.maxTableSize = this.newMaxHeaderSize;
        this.runEvictionIfRequired();
        this.newMaxHeaderSize = -1;
        this.minNewMaxHeaderSize = -1;
    }

    static {
        HashMap<String, TableEntry[]> hashMap = new HashMap<String, TableEntry[]>();
        for (int i = 1; i < Hpack.STATIC_TABLE.length; ++i) {
            Hpack.HeaderField headerField = Hpack.STATIC_TABLE[i];
            TableEntry[] tableEntryArray = (TableEntry[])hashMap.get(headerField.name);
            if (tableEntryArray == null) {
                hashMap.put(headerField.name, new TableEntry[]{new TableEntry(headerField.name, headerField.value, i)});
                continue;
            }
            TableEntry[] tableEntryArray2 = new TableEntry[tableEntryArray.length + 1];
            System.arraycopy(tableEntryArray, 0, tableEntryArray2, 0, tableEntryArray.length);
            tableEntryArray2[tableEntryArray.length] = new TableEntry(headerField.name, headerField.value, i);
            hashMap.put(headerField.name, tableEntryArray2);
        }
        ENCODING_STATIC_TABLE = Collections.unmodifiableMap(hashMap);
    }

    private static interface HpackHeaderFunction {
        public boolean shouldUseIndexing(String var1, String var2);

        public boolean shouldUseHuffman(String var1, String var2);

        public boolean shouldUseHuffman(String var1);
    }

    private static class TableEntry {
        private final String name;
        private final String value;
        private final int size;
        private int position;

        private TableEntry(String string, String string2, int n) {
            this.name = string;
            this.value = string2;
            this.position = n;
            this.size = string2 != null ? 32 + string.length() + string2.length() : -1;
        }

        int getPosition() {
            return this.position;
        }

        int getSize() {
            return this.size;
        }
    }

    static enum State {
        COMPLETE,
        UNDERFLOW;

    }

    private class DynamicTableEntry
    extends TableEntry {
        private DynamicTableEntry(String string, String string2, int n) {
            super(string, string2, n);
        }

        @Override
        int getPosition() {
            return super.getPosition() + HpackEncoder.this.entryPositionCounter + Hpack.STATIC_TABLE_LENGTH;
        }
    }
}

