/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.servlet.jsp.tagext.FunctionInfo;
import org.apache.jasper.Constants;
import org.apache.jasper.JasperException;
import org.apache.jasper.compiler.ELNode;
import org.apache.jasper.compiler.Node;
import org.apache.tomcat.util.security.PrivilegedGetTccl;

public class ELFunctionMapper {
    private int currFunc = 0;
    private StringBuilder ds;
    private StringBuilder ss;

    public static void map(Node.Nodes nodes) throws JasperException {
        ELFunctionMapper eLFunctionMapper = new ELFunctionMapper();
        eLFunctionMapper.ds = new StringBuilder();
        eLFunctionMapper.ss = new StringBuilder();
        ELFunctionMapper eLFunctionMapper2 = eLFunctionMapper;
        Objects.requireNonNull(eLFunctionMapper2);
        nodes.visit(eLFunctionMapper2.new ELFunctionVisitor());
        String string = eLFunctionMapper.ds.toString();
        if (string.length() > 0) {
            Node.Root root = nodes.getRoot();
            Node.Declaration declaration = new Node.Declaration(eLFunctionMapper.ss.toString(), null, root);
            declaration = new Node.Declaration("static {\n" + string + "}\n", null, root);
        }
    }

    private class ELFunctionVisitor
    extends Node.Visitor {
        private final Map<String, String> gMap = new HashMap<String, String>();

        private ELFunctionVisitor() {
        }

        @Override
        public void visit(Node.ParamAction paramAction) throws JasperException {
            this.doMap(paramAction.getValue());
            this.visitBody(paramAction);
        }

        @Override
        public void visit(Node.IncludeAction includeAction) throws JasperException {
            this.doMap(includeAction.getPage());
            this.visitBody(includeAction);
        }

        @Override
        public void visit(Node.ForwardAction forwardAction) throws JasperException {
            this.doMap(forwardAction.getPage());
            this.visitBody(forwardAction);
        }

        @Override
        public void visit(Node.SetProperty setProperty) throws JasperException {
            this.doMap(setProperty.getValue());
            this.visitBody(setProperty);
        }

        @Override
        public void visit(Node.UseBean useBean) throws JasperException {
            this.doMap(useBean.getBeanName());
            this.visitBody(useBean);
        }

        @Override
        public void visit(Node.PlugIn plugIn) throws JasperException {
            this.doMap(plugIn.getHeight());
            this.doMap(plugIn.getWidth());
            this.visitBody(plugIn);
        }

        @Override
        public void visit(Node.JspElement jspElement) throws JasperException {
            Node.JspAttribute[] jspAttributeArray = jspElement.getJspAttributes();
            for (int i = 0; jspAttributeArray != null && i < jspAttributeArray.length; ++i) {
                this.doMap(jspAttributeArray[i]);
            }
            this.doMap(jspElement.getNameAttribute());
            this.visitBody(jspElement);
        }

        @Override
        public void visit(Node.UninterpretedTag uninterpretedTag) throws JasperException {
            Node.JspAttribute[] jspAttributeArray = uninterpretedTag.getJspAttributes();
            for (int i = 0; jspAttributeArray != null && i < jspAttributeArray.length; ++i) {
                this.doMap(jspAttributeArray[i]);
            }
            this.visitBody(uninterpretedTag);
        }

        @Override
        public void visit(Node.CustomTag customTag) throws JasperException {
            Node.JspAttribute[] jspAttributeArray = customTag.getJspAttributes();
            for (int i = 0; jspAttributeArray != null && i < jspAttributeArray.length; ++i) {
                this.doMap(jspAttributeArray[i]);
            }
            this.visitBody(customTag);
        }

        @Override
        public void visit(Node.ELExpression eLExpression) throws JasperException {
            this.doMap(eLExpression.getEL());
        }

        private void doMap(Node.JspAttribute jspAttribute) throws JasperException {
            if (jspAttribute != null) {
                this.doMap(jspAttribute.getEL());
            }
        }

        private void doMap(ELNode.Nodes nodes) throws JasperException {
            if (nodes == null) {
                return;
            }
            class Fvisitor
            extends ELNode.Visitor {
                private final List<ELNode.Function> funcs = new ArrayList<ELNode.Function>();
                private final Set<String> keySet = new HashSet<String>();

                Fvisitor() {
                }

                @Override
                public void visit(ELNode.Function function) throws JasperException {
                    String string = function.getPrefix() + ":" + function.getName();
                    if (this.keySet.add(string)) {
                        this.funcs.add(function);
                    }
                }
            }
            Fvisitor fvisitor = new Fvisitor();
            nodes.visit(fvisitor);
            List list = fvisitor.funcs;
            if (list.size() == 0) {
                return;
            }
            String string = this.matchMap(list);
            if (string != null) {
                nodes.setMapName(string);
                return;
            }
            string = this.getMapName();
            ELFunctionMapper.this.ss.append("private static org.apache.jasper.runtime.ProtectedFunctionMapper " + string + ";\n");
            ELFunctionMapper.this.ds.append("  " + string + "= ");
            ELFunctionMapper.this.ds.append("org.apache.jasper.runtime.ProtectedFunctionMapper");
            String string2 = null;
            if (list.size() == 1) {
                string2 = ".getMapForFunction";
            } else {
                ELFunctionMapper.this.ds.append(".getInstance();\n");
                string2 = "  " + string + ".mapFunction";
            }
            for (ELNode.Function function : list) {
                FunctionInfo functionInfo = function.getFunctionInfo();
                String string3 = function.getPrefix() + ":" + function.getName();
                if (functionInfo == null) {
                    ELFunctionMapper.this.ds.append(string2 + "(null, null, null, null);\n");
                } else {
                    ELFunctionMapper.this.ds.append(string2 + "(\"" + string3 + "\", " + this.getCanonicalName(functionInfo.getFunctionClass()) + ".class, " + '\"' + function.getMethodName() + "\", new Class[] {");
                    String[] stringArray = function.getParameters();
                    for (int i = 0; i < stringArray.length; ++i) {
                        int n;
                        if (i != 0) {
                            ELFunctionMapper.this.ds.append(", ");
                        }
                        if ((n = stringArray[i].indexOf(91)) < 0) {
                            ELFunctionMapper.this.ds.append(stringArray[i] + ".class");
                            continue;
                        }
                        String string4 = stringArray[i].substring(0, n);
                        ELFunctionMapper.this.ds.append("java.lang.reflect.Array.newInstance(");
                        ELFunctionMapper.this.ds.append(string4);
                        ELFunctionMapper.this.ds.append(".class,");
                        int n2 = 0;
                        for (int j = n; j < stringArray[i].length(); ++j) {
                            if (stringArray[i].charAt(j) != '[') continue;
                            ++n2;
                        }
                        if (n2 == 1) {
                            ELFunctionMapper.this.ds.append("0).getClass()");
                            continue;
                        }
                        ELFunctionMapper.this.ds.append("new int[" + n2 + "]).getClass()");
                    }
                    ELFunctionMapper.this.ds.append("});\n");
                }
                this.gMap.put(string3 + ':' + function.getUri(), string);
            }
            nodes.setMapName(string);
        }

        private String matchMap(List<ELNode.Function> list) {
            String string = null;
            for (ELNode.Function function : list) {
                String string2 = this.gMap.get(function.getPrefix() + ':' + function.getName() + ':' + function.getUri());
                if (string2 == null) {
                    return null;
                }
                if (string == null) {
                    string = string2;
                    continue;
                }
                if (string2.equals(string)) continue;
                return null;
            }
            return string;
        }

        private String getMapName() {
            return "_jspx_fnmap_" + ELFunctionMapper.this.currFunc++;
        }

        private String getCanonicalName(String string) throws JasperException {
            Class<?> clazz;
            ClassLoader classLoader;
            if (Constants.IS_SECURITY_ENABLED) {
                PrivilegedGetTccl privilegedGetTccl = new PrivilegedGetTccl();
                classLoader = (ClassLoader)AccessController.doPrivileged(privilegedGetTccl);
            } else {
                classLoader = Thread.currentThread().getContextClassLoader();
            }
            try {
                clazz = Class.forName(string, false, classLoader);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new JasperException(classNotFoundException);
            }
            return clazz.getCanonicalName();
        }
    }
}

