/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.valves.rewrite;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.util.URLEncoder;
import org.apache.catalina.valves.ValveBase;
import org.apache.catalina.valves.rewrite.InternalRewriteMap;
import org.apache.catalina.valves.rewrite.QuotedStringTokenizer;
import org.apache.catalina.valves.rewrite.ResolverImpl;
import org.apache.catalina.valves.rewrite.RewriteCond;
import org.apache.catalina.valves.rewrite.RewriteMap;
import org.apache.catalina.valves.rewrite.RewriteRule;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.buf.CharChunk;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.buf.UDecoder;
import org.apache.tomcat.util.buf.UriUtil;
import org.apache.tomcat.util.file.ConfigFileLoader;
import org.apache.tomcat.util.http.RequestUtil;

public class RewriteValve
extends ValveBase {
    protected RewriteRule[] rules = null;
    protected ThreadLocal<Boolean> invoked = new ThreadLocal();
    protected String resourcePath = "rewrite.config";
    protected boolean context = false;
    protected boolean enabled = true;
    protected Map<String, RewriteMap> maps = new Hashtable<String, RewriteMap>();
    protected ArrayList<String> mapsConfiguration = new ArrayList();

    public RewriteValve() {
        super(true);
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    @Override
    protected void initInternal() throws LifecycleException {
        super.initInternal();
        this.containerLog = LogFactory.getLog((String)(this.getContainer().getLogName() + ".rewrite"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized void startInternal() throws LifecycleException {
        Object object;
        Object object2;
        InputStream inputStream;
        block29: {
            super.startInternal();
            inputStream = null;
            if (this.getContainer() instanceof Context) {
                this.context = true;
                inputStream = ((Context)this.getContainer()).getServletContext().getResourceAsStream("/WEB-INF/" + this.resourcePath);
                if (this.containerLog.isDebugEnabled()) {
                    if (inputStream == null) {
                        this.containerLog.debug((Object)("No configuration resource found: /WEB-INF/" + this.resourcePath));
                    } else {
                        this.containerLog.debug((Object)("Read configuration from: /WEB-INF/" + this.resourcePath));
                    }
                }
            } else {
                object2 = Container.getConfigPath(this.getContainer(), this.resourcePath);
                try {
                    object = ConfigFileLoader.getSource().getResource((String)object2);
                    inputStream = object.getInputStream();
                }
                catch (IOException iOException) {
                    if (!this.containerLog.isDebugEnabled()) break block29;
                    this.containerLog.debug((Object)("No configuration resource found: " + (String)object2), (Throwable)iOException);
                }
            }
        }
        if (inputStream == null) {
            return;
        }
        try {
            object2 = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
            try {
                object = new BufferedReader((Reader)object2);
                try {
                    this.parse((BufferedReader)object);
                }
                finally {
                    ((BufferedReader)object).close();
                }
            }
            finally {
                ((InputStreamReader)object2).close();
            }
        }
        catch (IOException iOException) {
            this.containerLog.error((Object)sm.getString("rewriteValve.closeError"), (Throwable)iOException);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                this.containerLog.error((Object)sm.getString("rewriteValve.closeError"), (Throwable)iOException);
            }
        }
    }

    public void setConfiguration(String string) throws Exception {
        if (this.containerLog == null) {
            this.containerLog = LogFactory.getLog((String)(this.getContainer().getLogName() + ".rewrite"));
        }
        this.maps.clear();
        this.parse(new BufferedReader(new StringReader(string)));
    }

    public String getConfiguration() {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : this.mapsConfiguration) {
            stringBuilder.append(string).append("\r\n");
        }
        if (this.mapsConfiguration.size() > 0) {
            stringBuilder.append("\r\n");
        }
        for (RewriteRule rewriteRule : this.rules) {
            for (int i = 0; i < rewriteRule.getConditions().length; ++i) {
                stringBuilder.append(rewriteRule.getConditions()[i].toString()).append("\r\n");
            }
            stringBuilder.append(rewriteRule.toString()).append("\r\n").append("\r\n");
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - void declaration
     */
    protected void parse(BufferedReader bufferedReader) throws LifecycleException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<RewriteCond> arrayList2 = new ArrayList<RewriteCond>();
        while (true) {
            try {
                RewriteRule[] rewriteRuleArray;
                while ((rewriteRuleArray = bufferedReader.readLine()) != null) {
                    Object object2;
                    Object object3 = RewriteValve.parse((String)rewriteRuleArray);
                    if (object3 instanceof RewriteRule) {
                        void var7_12;
                        object2 = (RewriteRule)object3;
                        if (this.containerLog.isDebugEnabled()) {
                            this.containerLog.debug((Object)("Add rule with pattern " + ((RewriteRule)object2).getPatternString() + " and substitution " + ((RewriteRule)object2).getSubstitutionString()));
                        }
                        int i = arrayList2.size() - 1;
                        while (var7_12 > 0) {
                            if (((RewriteCond)arrayList2.get((int)(var7_12 - true))).isOrnext()) {
                                ((RewriteCond)arrayList2.get((int)var7_12)).setOrnext(true);
                            }
                            --var7_12;
                        }
                        for (RewriteCond rewriteCond : arrayList2) {
                            if (this.containerLog.isDebugEnabled()) {
                                RewriteCond rewriteCond2 = rewriteCond;
                                this.containerLog.debug((Object)("Add condition " + rewriteCond2.getCondPattern() + " test " + rewriteCond2.getTestString() + " to rule with pattern " + ((RewriteRule)object2).getPatternString() + " and substitution " + ((RewriteRule)object2).getSubstitutionString() + (rewriteCond2.isOrnext() ? " [OR]" : "") + (rewriteCond2.isNocase() ? " [NC]" : "")));
                            }
                            ((RewriteRule)object2).addCondition(rewriteCond);
                        }
                        arrayList2.clear();
                        arrayList.add(object2);
                        continue;
                    }
                    if (object3 instanceof RewriteCond) {
                        arrayList2.add((RewriteCond)object3);
                        continue;
                    }
                    if (!(object3 instanceof Object[])) continue;
                    object2 = (String)((Object[])object3)[0];
                    RewriteMap rewriteMap = (RewriteMap)((Object[])object3)[1];
                    this.maps.put((String)object2, rewriteMap);
                    this.mapsConfiguration.add((String)rewriteRuleArray);
                    if (!(rewriteMap instanceof Lifecycle)) continue;
                    ((Lifecycle)((Object)rewriteMap)).start();
                }
            }
            catch (IOException iOException) {
                this.containerLog.error((Object)sm.getString("rewriteValve.readError"), (Throwable)iOException);
                continue;
            }
            break;
        }
        for (RewriteRule rewriteRule : this.rules = arrayList.toArray(new RewriteRule[0])) {
            rewriteRule.parse(this.maps);
        }
    }

    @Override
    protected synchronized void stopInternal() throws LifecycleException {
        super.stopInternal();
        for (RewriteMap rewriteMap : this.maps.values()) {
            if (!(rewriteMap instanceof Lifecycle)) continue;
            ((Lifecycle)((Object)rewriteMap)).stop();
        }
        this.maps.clear();
        this.rules = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invoke(Request request, Response response) throws IOException, ServletException {
        block53: {
            if (!this.getEnabled() || this.rules == null || this.rules.length == 0) {
                this.getNext().invoke(request, response);
                return;
            }
            if (Boolean.TRUE.equals(this.invoked.get())) {
                try {
                    this.getNext().invoke(request, response);
                }
                finally {
                    this.invoked.set(null);
                }
                return;
            }
            try {
                Object object;
                CharSequence charSequence;
                Object object2;
                ResolverImpl resolverImpl = new ResolverImpl(request);
                this.invoked.set(Boolean.TRUE);
                Charset charset = request.getConnector().getURICharset();
                String string = request.getQueryString();
                MessageBytes messageBytes = this.context ? request.getRequestPathMB() : request.getDecodedRequestURIMB();
                messageBytes.toChars();
                Object object3 = messageBytes.getCharChunk();
                CharSequence charSequence2 = request.getServerName();
                boolean bl = false;
                boolean bl2 = false;
                boolean bl3 = false;
                boolean bl4 = false;
                block9: for (int i = 0; i < this.rules.length; ++i) {
                    Object object4 = ((RewriteRule)(object2 = this.rules[i])).isHost() ? charSequence2 : object3;
                    charSequence = ((RewriteRule)object2).evaluate((CharSequence)object4, resolverImpl);
                    if (charSequence != null && !object4.equals(charSequence.toString())) {
                        if (this.containerLog.isDebugEnabled()) {
                            this.containerLog.debug((Object)("Rewrote " + object4 + " as " + charSequence + " with rule pattern " + ((RewriteRule)object2).getPatternString()));
                        }
                        if (((RewriteRule)object2).isHost()) {
                            charSequence2 = charSequence;
                        } else {
                            object3 = charSequence;
                        }
                        bl = true;
                    }
                    if (!bl3 && charSequence != null && ((RewriteRule)object2).isQsappend()) {
                        bl3 = true;
                    }
                    if (!bl3 && charSequence != null && ((RewriteRule)object2).isQsdiscard()) {
                        bl4 = true;
                    }
                    if (((RewriteRule)object2).isForbidden() && charSequence != null) {
                        response.sendError(403);
                        bl2 = true;
                        break;
                    }
                    if (((RewriteRule)object2).isGone() && charSequence != null) {
                        response.sendError(410);
                        bl2 = true;
                        break;
                    }
                    if (((RewriteRule)object2).isRedirect() && charSequence != null) {
                        String string2 = object3.toString();
                        int n = string2.indexOf("?");
                        if (n == -1) {
                            object = null;
                        } else {
                            object = string2.substring(n + 1);
                            string2 = string2.substring(0, n);
                        }
                        StringBuilder stringBuilder = new StringBuilder(URLEncoder.DEFAULT.encode(string2, charset));
                        if (!bl4 && string != null && string.length() > 0) {
                            if (object == null) {
                                stringBuilder.append('?');
                                stringBuilder.append(string);
                            } else if (bl3) {
                                stringBuilder.append('?');
                                stringBuilder.append(URLEncoder.QUERY.encode((String)object, charset));
                                stringBuilder.append('&');
                                stringBuilder.append(string);
                            } else if (n == stringBuilder.length() - 1) {
                                stringBuilder.deleteCharAt(n);
                            } else {
                                stringBuilder.append('?');
                                stringBuilder.append(URLEncoder.QUERY.encode((String)object, charset));
                            }
                        } else if (object != null) {
                            stringBuilder.append('?');
                            stringBuilder.append(URLEncoder.QUERY.encode((String)object, charset));
                        }
                        if (this.context && stringBuilder.charAt(0) == '/' && !UriUtil.hasScheme((CharSequence)stringBuilder)) {
                            stringBuilder.insert(0, request.getContext().getEncodedPath());
                        }
                        if (((RewriteRule)object2).isNoescape()) {
                            response.sendRedirect(UDecoder.URLDecode((String)stringBuilder.toString(), (Charset)charset));
                        } else {
                            response.sendRedirect(stringBuilder.toString());
                        }
                        response.setStatus(((RewriteRule)object2).getRedirectCode());
                        bl2 = true;
                        break;
                    }
                    if (((RewriteRule)object2).isCookie() && charSequence != null) {
                        Cookie cookie = new Cookie(((RewriteRule)object2).getCookieName(), ((RewriteRule)object2).getCookieResult());
                        cookie.setDomain(((RewriteRule)object2).getCookieDomain());
                        cookie.setMaxAge(((RewriteRule)object2).getCookieLifetime());
                        cookie.setPath(((RewriteRule)object2).getCookiePath());
                        cookie.setSecure(((RewriteRule)object2).isCookieSecure());
                        cookie.setHttpOnly(((RewriteRule)object2).isCookieHttpOnly());
                        response.addCookie(cookie);
                    }
                    if (((RewriteRule)object2).isEnv() && charSequence != null) {
                        for (int j = 0; j < ((RewriteRule)object2).getEnvSize(); ++j) {
                            request.setAttribute(((RewriteRule)object2).getEnvName(j), ((RewriteRule)object2).getEnvResult(j));
                        }
                    }
                    if (((RewriteRule)object2).isType() && charSequence != null) {
                        request.setContentType(((RewriteRule)object2).getTypeValue());
                    }
                    if (((RewriteRule)object2).isChain() && charSequence == null) {
                        for (int j = i; j < this.rules.length; ++j) {
                            if (this.rules[j].isChain()) continue;
                            i = j;
                            continue block9;
                        }
                        continue;
                    }
                    if (((RewriteRule)object2).isLast() && charSequence != null) break;
                    if (((RewriteRule)object2).isNext() && charSequence != null) {
                        i = 0;
                        continue;
                    }
                    if (charSequence == null) continue;
                    i += ((RewriteRule)object2).getSkip();
                }
                if (bl) {
                    if (bl2) break block53;
                    String string3 = object3.toString();
                    object2 = null;
                    int n = string3.indexOf(63);
                    if (n != -1) {
                        object2 = string3.substring(n + 1);
                        string3 = string3.substring(0, n);
                    }
                    charSequence = null;
                    if (this.context) {
                        charSequence = request.getContextPath();
                    }
                    request.getCoyoteRequest().requestURI().setString(null);
                    CharChunk charChunk = request.getCoyoteRequest().requestURI().getCharChunk();
                    charChunk.recycle();
                    if (this.context) {
                        charChunk.append((String)charSequence);
                    }
                    charChunk.append(URLEncoder.DEFAULT.encode(string3, charset));
                    request.getCoyoteRequest().requestURI().toChars();
                    string3 = RequestUtil.normalize((String)string3);
                    request.getCoyoteRequest().decodedURI().setString(null);
                    charChunk = request.getCoyoteRequest().decodedURI().getCharChunk();
                    charChunk.recycle();
                    if (this.context) {
                        charChunk.append(request.getServletContext().getContextPath());
                    }
                    charChunk.append(string3);
                    request.getCoyoteRequest().decodedURI().toChars();
                    if (object2 != null) {
                        request.getCoyoteRequest().queryString().setString(null);
                        charChunk = request.getCoyoteRequest().queryString().getCharChunk();
                        charChunk.recycle();
                        charChunk.append(URLEncoder.QUERY.encode((String)object2, charset));
                        if (bl3 && string != null && string.length() > 0) {
                            charChunk.append('&');
                            charChunk.append(string);
                        }
                        if (!charChunk.isNull()) {
                            request.getCoyoteRequest().queryString().toChars();
                        }
                    }
                    if (!charSequence2.equals(request.getServerName())) {
                        request.getCoyoteRequest().serverName().setString(null);
                        charChunk = request.getCoyoteRequest().serverName().getCharChunk();
                        charChunk.recycle();
                        charChunk.append(charSequence2.toString());
                        request.getCoyoteRequest().serverName().toChars();
                    }
                    request.getMappingData().recycle();
                    Connector connector = request.getConnector();
                    try {
                        if (!connector.getProtocolHandler().getAdapter().prepare(request.getCoyoteRequest(), response.getCoyoteResponse())) {
                            return;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    object = connector.getService().getContainer().getPipeline();
                    request.setAsyncSupported(object.isAsyncSupported());
                    object.getFirst().invoke(request, response);
                    break block53;
                }
                this.getNext().invoke(request, response);
            }
            finally {
                this.invoked.set(null);
            }
        }
    }

    public static Object parse(String string) {
        QuotedStringTokenizer quotedStringTokenizer = new QuotedStringTokenizer(string);
        if (quotedStringTokenizer.hasMoreTokens()) {
            String string2 = quotedStringTokenizer.nextToken();
            if (string2.equals("RewriteCond")) {
                RewriteCond rewriteCond = new RewriteCond();
                if (quotedStringTokenizer.countTokens() < 2) {
                    throw new IllegalArgumentException(sm.getString("rewriteValve.invalidLine", new Object[]{string}));
                }
                rewriteCond.setTestString(quotedStringTokenizer.nextToken());
                rewriteCond.setCondPattern(quotedStringTokenizer.nextToken());
                if (quotedStringTokenizer.hasMoreTokens()) {
                    String string3 = quotedStringTokenizer.nextToken();
                    rewriteCond.setFlagsString(string3);
                    if (string3.startsWith("[") && string3.endsWith("]")) {
                        string3 = string3.substring(1, string3.length() - 1);
                    }
                    StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
                    while (stringTokenizer.hasMoreElements()) {
                        RewriteValve.parseCondFlag(string, rewriteCond, stringTokenizer.nextToken());
                    }
                }
                return rewriteCond;
            }
            if (string2.equals("RewriteRule")) {
                RewriteRule rewriteRule = new RewriteRule();
                if (quotedStringTokenizer.countTokens() < 2) {
                    throw new IllegalArgumentException(sm.getString("rewriteValve.invalidLine", new Object[]{string}));
                }
                rewriteRule.setPatternString(quotedStringTokenizer.nextToken());
                rewriteRule.setSubstitutionString(quotedStringTokenizer.nextToken());
                if (quotedStringTokenizer.hasMoreTokens()) {
                    String string4 = quotedStringTokenizer.nextToken();
                    rewriteRule.setFlagsString(string4);
                    if (string4.startsWith("[") && string4.endsWith("]")) {
                        string4 = string4.substring(1, string4.length() - 1);
                    }
                    StringTokenizer stringTokenizer = new StringTokenizer(string4, ",");
                    while (stringTokenizer.hasMoreElements()) {
                        RewriteValve.parseRuleFlag(string, rewriteRule, stringTokenizer.nextToken());
                    }
                }
                return rewriteRule;
            }
            if (string2.equals("RewriteMap")) {
                if (quotedStringTokenizer.countTokens() < 2) {
                    throw new IllegalArgumentException(sm.getString("rewriteValve.invalidLine", new Object[]{string}));
                }
                String string5 = quotedStringTokenizer.nextToken();
                String string6 = quotedStringTokenizer.nextToken();
                RewriteMap rewriteMap = null;
                if (string6.startsWith("int:")) {
                    rewriteMap = InternalRewriteMap.toMap(string6.substring("int:".length()));
                } else if (string6.startsWith("prg:")) {
                    string6 = string6.substring("prg:".length());
                }
                if (rewriteMap == null) {
                    try {
                        rewriteMap = (RewriteMap)Class.forName(string6).getConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    catch (Exception exception) {
                        throw new IllegalArgumentException(sm.getString("rewriteValve.invalidMapClassName", new Object[]{string}));
                    }
                }
                if (quotedStringTokenizer.hasMoreTokens()) {
                    if (quotedStringTokenizer.countTokens() == 1) {
                        rewriteMap.setParameters(quotedStringTokenizer.nextToken());
                    } else {
                        ArrayList<String> arrayList = new ArrayList<String>();
                        while (quotedStringTokenizer.hasMoreTokens()) {
                            arrayList.add(quotedStringTokenizer.nextToken());
                        }
                        rewriteMap.setParameters(arrayList.toArray(new String[0]));
                    }
                }
                return new Object[]{string5, rewriteMap};
            }
            if (!string2.startsWith("#")) {
                throw new IllegalArgumentException(sm.getString("rewriteValve.invalidLine", new Object[]{string}));
            }
        }
        return null;
    }

    protected static void parseCondFlag(String string, RewriteCond rewriteCond, String string2) {
        if (string2.equals("NC") || string2.equals("nocase")) {
            rewriteCond.setNocase(true);
        } else if (string2.equals("OR") || string2.equals("ornext")) {
            rewriteCond.setOrnext(true);
        } else {
            throw new IllegalArgumentException(sm.getString("rewriteValve.invalidFlags", new Object[]{string, string2}));
        }
    }

    protected static void parseRuleFlag(String string, RewriteRule rewriteRule, String string2) {
        if (string2.equals("B")) {
            rewriteRule.setEscapeBackReferences(true);
        } else if (string2.equals("chain") || string2.equals("C")) {
            rewriteRule.setChain(true);
        } else if (string2.startsWith("cookie=") || string2.startsWith("CO=")) {
            rewriteRule.setCookie(true);
            if (string2.startsWith("cookie")) {
                string2 = string2.substring("cookie=".length());
            } else if (string2.startsWith("CO=")) {
                string2 = string2.substring("CO=".length());
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ":");
            if (stringTokenizer.countTokens() < 2) {
                throw new IllegalArgumentException(sm.getString("rewriteValve.invalidFlags", new Object[]{string, string2}));
            }
            rewriteRule.setCookieName(stringTokenizer.nextToken());
            rewriteRule.setCookieValue(stringTokenizer.nextToken());
            if (stringTokenizer.hasMoreTokens()) {
                rewriteRule.setCookieDomain(stringTokenizer.nextToken());
            }
            if (stringTokenizer.hasMoreTokens()) {
                try {
                    rewriteRule.setCookieLifetime(Integer.parseInt(stringTokenizer.nextToken()));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException(sm.getString("rewriteValve.invalidFlags", new Object[]{string, string2}), numberFormatException);
                }
            }
            if (stringTokenizer.hasMoreTokens()) {
                rewriteRule.setCookiePath(stringTokenizer.nextToken());
            }
            if (stringTokenizer.hasMoreTokens()) {
                rewriteRule.setCookieSecure(Boolean.parseBoolean(stringTokenizer.nextToken()));
            }
            if (stringTokenizer.hasMoreTokens()) {
                rewriteRule.setCookieHttpOnly(Boolean.parseBoolean(stringTokenizer.nextToken()));
            }
        } else if (string2.startsWith("env=") || string2.startsWith("E=")) {
            rewriteRule.setEnv(true);
            if (string2.startsWith("env=")) {
                string2 = string2.substring("env=".length());
            } else if (string2.startsWith("E=")) {
                string2 = string2.substring("E=".length());
            }
            int n = string2.indexOf(58);
            if (n == -1 || n + 1 == string2.length()) {
                throw new IllegalArgumentException(sm.getString("rewriteValve.invalidFlags", new Object[]{string, string2}));
            }
            rewriteRule.addEnvName(string2.substring(0, n));
            rewriteRule.addEnvValue(string2.substring(n + 1));
        } else if (string2.startsWith("forbidden") || string2.startsWith("F")) {
            rewriteRule.setForbidden(true);
        } else if (string2.startsWith("gone") || string2.startsWith("G")) {
            rewriteRule.setGone(true);
        } else if (string2.startsWith("host") || string2.startsWith("H")) {
            rewriteRule.setHost(true);
        } else if (string2.startsWith("last") || string2.startsWith("L")) {
            rewriteRule.setLast(true);
        } else if (string2.startsWith("nocase") || string2.startsWith("NC")) {
            rewriteRule.setNocase(true);
        } else if (string2.startsWith("noescape") || string2.startsWith("NE")) {
            rewriteRule.setNoescape(true);
        } else if (string2.startsWith("next") || string2.startsWith("N")) {
            rewriteRule.setNext(true);
        } else if (string2.startsWith("qsappend") || string2.startsWith("QSA")) {
            rewriteRule.setQsappend(true);
        } else if (string2.startsWith("qsdiscard") || string2.startsWith("QSD")) {
            rewriteRule.setQsdiscard(true);
        } else if (string2.startsWith("redirect") || string2.startsWith("R")) {
            rewriteRule.setRedirect(true);
            int n = 302;
            if (string2.startsWith("redirect=") || string2.startsWith("R=")) {
                if (string2.startsWith("redirect=")) {
                    string2 = string2.substring("redirect=".length());
                } else if (string2.startsWith("R=")) {
                    string2 = string2.substring("R=".length());
                }
                switch (string2) {
                    case "temp": {
                        n = 302;
                        break;
                    }
                    case "permanent": {
                        n = 301;
                        break;
                    }
                    case "seeother": {
                        n = 303;
                        break;
                    }
                    default: {
                        n = Integer.parseInt(string2);
                    }
                }
            }
            rewriteRule.setRedirectCode(n);
        } else if (string2.startsWith("skip") || string2.startsWith("S")) {
            if (string2.startsWith("skip=")) {
                string2 = string2.substring("skip=".length());
            } else if (string2.startsWith("S=")) {
                string2 = string2.substring("S=".length());
            }
            rewriteRule.setSkip(Integer.parseInt(string2));
        } else if (string2.startsWith("type") || string2.startsWith("T")) {
            if (string2.startsWith("type=")) {
                string2 = string2.substring("type=".length());
            } else if (string2.startsWith("T=")) {
                string2 = string2.substring("T=".length());
            }
            rewriteRule.setType(true);
            rewriteRule.setTypeValue(string2);
        } else {
            throw new IllegalArgumentException(sm.getString("rewriteValve.invalidFlags", new Object[]{string, string2}));
        }
    }
}

