/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.util.List;
import org.bouncycastle.jsse.BCSNIServerName;
import org.bouncycastle.jsse.provider.JsseSessionParameters;
import org.bouncycastle.jsse.provider.ProvSSLSessionBase;
import org.bouncycastle.jsse.provider.ProvSSLSessionContext;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.SessionParameters;
import org.bouncycastle.tls.TlsSession;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class ProvSSLSession
extends ProvSSLSessionBase {
    static final ProvSSLSession NULL_SESSION = new ProvSSLSession(null, null, -1, null, new JsseSessionParameters(null));
    protected final TlsSession tlsSession;
    protected final SessionParameters sessionParameters;
    protected final JsseSessionParameters jsseSessionParameters;

    ProvSSLSession(ProvSSLSessionContext provSSLSessionContext, String string, int n, TlsSession tlsSession, JsseSessionParameters jsseSessionParameters) {
        super(provSSLSessionContext, string, n);
        this.tlsSession = tlsSession;
        this.sessionParameters = tlsSession == null ? null : tlsSession.exportSessionParameters();
        this.jsseSessionParameters = jsseSessionParameters;
    }

    @Override
    protected int getCipherSuiteTLS() {
        return null == this.sessionParameters ? 0 : this.sessionParameters.getCipherSuite();
    }

    @Override
    protected byte[] getIDArray() {
        return null == this.tlsSession ? null : this.tlsSession.getSessionID();
    }

    @Override
    protected JsseSessionParameters getJsseSessionParameters() {
        return this.jsseSessionParameters;
    }

    @Override
    protected Certificate getLocalCertificateTLS() {
        return null == this.sessionParameters ? null : this.sessionParameters.getLocalCertificate();
    }

    @Override
    public String[] getLocalSupportedSignatureAlgorithms() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected Certificate getPeerCertificateTLS() {
        return null == this.sessionParameters ? null : this.sessionParameters.getPeerCertificate();
    }

    @Override
    public String[] getPeerSupportedSignatureAlgorithms() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected ProtocolVersion getProtocolTLS() {
        return null == this.sessionParameters ? null : this.sessionParameters.getNegotiatedVersion();
    }

    @Override
    public List<BCSNIServerName> getRequestedServerNames() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<byte[]> getStatusResponses() {
        throw new UnsupportedOperationException();
    }

    TlsSession getTlsSession() {
        return this.tlsSession;
    }

    @Override
    public void invalidate() {
        super.invalidate();
        if (null != this.tlsSession) {
            this.tlsSession.invalidate();
        }
    }

    @Override
    public boolean isValid() {
        return super.isValid() && null != this.tlsSession && this.tlsSession.isResumable();
    }
}

