/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http2;

import java.io.IOException;
import java.util.Iterator;
import org.apache.coyote.AbstractProcessor;
import org.apache.coyote.ActionCode;
import org.apache.coyote.Adapter;
import org.apache.coyote.ContainerThreadMarker;
import org.apache.coyote.ContinueResponseTiming;
import org.apache.coyote.ErrorState;
import org.apache.coyote.Request;
import org.apache.coyote.Response;
import org.apache.coyote.http11.filters.GzipOutputFilter;
import org.apache.coyote.http2.ConnectionException;
import org.apache.coyote.http2.Http2Error;
import org.apache.coyote.http2.Http2Protocol;
import org.apache.coyote.http2.Http2UpgradeHandler;
import org.apache.coyote.http2.Stream;
import org.apache.coyote.http2.StreamException;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.http.FastHttpDateFormat;
import org.apache.tomcat.util.http.MimeHeaders;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.DispatchType;
import org.apache.tomcat.util.net.SocketEvent;
import org.apache.tomcat.util.net.SocketWrapperBase;
import org.apache.tomcat.util.res.StringManager;

class StreamProcessor
extends AbstractProcessor {
    private static final Log log = LogFactory.getLog(StreamProcessor.class);
    private static final StringManager sm = StringManager.getManager(StreamProcessor.class);
    private final Http2UpgradeHandler handler;
    private final Stream stream;

    StreamProcessor(Http2UpgradeHandler http2UpgradeHandler, Stream stream, Adapter adapter, SocketWrapperBase<?> socketWrapperBase) {
        super(socketWrapperBase.getEndpoint(), stream.getCoyoteRequest(), stream.getCoyoteResponse());
        this.handler = http2UpgradeHandler;
        this.stream = stream;
        this.setAdapter(adapter);
        this.setSocketWrapper(socketWrapperBase);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void process(SocketEvent socketEvent) {
        try {
            StreamProcessor streamProcessor = this;
            synchronized (streamProcessor) {
                ContainerThreadMarker.set();
                AbstractEndpoint.Handler.SocketState socketState = AbstractEndpoint.Handler.SocketState.CLOSED;
                try {
                    socketState = this.process(this.socketWrapper, socketEvent);
                    if (socketState == AbstractEndpoint.Handler.SocketState.LONG) {
                        this.handler.getProtocol().getHttp11Protocol().addWaitingProcessor(this);
                    } else if (socketState == AbstractEndpoint.Handler.SocketState.CLOSED) {
                        this.handler.getProtocol().getHttp11Protocol().removeWaitingProcessor(this);
                        if (!this.getErrorState().isConnectionIoAllowed()) {
                            ConnectionException connectionException = new ConnectionException(sm.getString("streamProcessor.error.connection", new Object[]{this.stream.getConnectionId(), this.stream.getIdAsString()}), Http2Error.INTERNAL_ERROR);
                            this.stream.close(connectionException);
                        } else if (!this.getErrorState().isIoAllowed()) {
                            StreamException streamException = this.stream.getResetException();
                            if (streamException == null) {
                                streamException = new StreamException(sm.getString("streamProcessor.error.stream", new Object[]{this.stream.getConnectionId(), this.stream.getIdAsString()}), Http2Error.INTERNAL_ERROR, this.stream.getIdAsInt());
                            }
                            this.stream.close(streamException);
                        } else if (!this.stream.isActive()) {
                            this.stream.recycle();
                        }
                    }
                }
                catch (Exception exception) {
                    String string = sm.getString("streamProcessor.error.connection", new Object[]{this.stream.getConnectionId(), this.stream.getIdAsString()});
                    if (log.isDebugEnabled()) {
                        log.debug((Object)string, (Throwable)exception);
                    }
                    ConnectionException connectionException = new ConnectionException(string, Http2Error.INTERNAL_ERROR);
                    connectionException.initCause(exception);
                    this.stream.close(connectionException);
                    socketState = AbstractEndpoint.Handler.SocketState.CLOSED;
                }
                finally {
                    if (socketState == AbstractEndpoint.Handler.SocketState.CLOSED) {
                        this.recycle();
                    }
                    ContainerThreadMarker.clear();
                }
            }
        }
        finally {
            this.handler.executeQueuedStream();
        }
    }

    @Override
    protected final void prepareResponse() throws IOException {
        this.response.setCommitted(true);
        StreamProcessor.prepareHeaders(this.request, this.response, this.handler.getProtocol(), this.stream);
        this.stream.writeHeaders();
    }

    static void prepareHeaders(Request request, Response response, Http2Protocol http2Protocol, Stream stream) {
        MimeHeaders mimeHeaders = response.getMimeHeaders();
        int n = response.getStatus();
        mimeHeaders.addValue(":status").setString(Integer.toString(n));
        if (http2Protocol != null && http2Protocol.useCompression(request, response)) {
            stream.addOutputFilter(new GzipOutputFilter());
        }
        if (n >= 200 && n != 204 && n != 205 && n != 304) {
            long l;
            String string;
            String string2 = response.getContentType();
            if (string2 != null) {
                mimeHeaders.setValue("content-type").setString(string2);
            }
            if ((string = response.getContentLanguage()) != null) {
                mimeHeaders.setValue("content-language").setString(string);
            }
            if ((l = response.getContentLengthLong()) != -1L && mimeHeaders.getValue("content-length") == null) {
                mimeHeaders.addValue("content-length").setLong(l);
            }
        } else if (n == 205) {
            response.setContentLength(0L);
        } else {
            response.setContentLength(-1L);
        }
        if (n >= 200 && mimeHeaders.getValue("date") == null) {
            mimeHeaders.addValue("date").setString(FastHttpDateFormat.getCurrentDate());
        }
    }

    @Override
    protected final void finishResponse() throws IOException {
        this.stream.getOutputBuffer().end();
    }

    @Override
    protected final void ack(ContinueResponseTiming continueResponseTiming) {
        if ((continueResponseTiming == ContinueResponseTiming.ALWAYS || continueResponseTiming == this.handler.getProtocol().getContinueResponseTimingInternal()) && !this.response.isCommitted() && this.request.hasExpectation()) {
            try {
                this.stream.writeAck();
            }
            catch (IOException iOException) {
                this.setErrorState(ErrorState.CLOSE_CONNECTION_NOW, iOException);
            }
        }
    }

    @Override
    protected final void flush() throws IOException {
        this.stream.getOutputBuffer().flush();
    }

    @Override
    protected final int available(boolean bl) {
        return this.stream.getInputBuffer().available();
    }

    @Override
    protected final void setRequestBody(ByteChunk byteChunk) {
        this.stream.getInputBuffer().insertReplayedBody(byteChunk);
        try {
            this.stream.receivedEndOfStream();
        }
        catch (ConnectionException connectionException) {
            // empty catch block
        }
    }

    @Override
    protected final void setSwallowResponse() {
    }

    @Override
    protected final void disableSwallowRequest() {
    }

    @Override
    protected void processSocketEvent(SocketEvent socketEvent, boolean bl) {
        if (bl) {
            this.handler.processStreamOnContainerThread(this, socketEvent);
        } else {
            this.process(socketEvent);
        }
    }

    @Override
    protected final boolean isReadyForRead() {
        return this.stream.getInputBuffer().isReadyForRead();
    }

    @Override
    protected final boolean isRequestBodyFullyRead() {
        return this.stream.getInputBuffer().isRequestBodyFullyRead();
    }

    @Override
    protected final void registerReadInterest() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected final boolean isReadyForWrite() {
        return this.stream.isReadyForWrite();
    }

    @Override
    protected final void executeDispatches() {
        Iterator<DispatchType> iterator = this.getIteratorAndClearDispatches();
        while (iterator != null && iterator.hasNext()) {
            DispatchType dispatchType = iterator.next();
            this.processSocketEvent(dispatchType.getSocketStatus(), true);
        }
    }

    @Override
    protected final boolean isPushSupported() {
        return this.stream.isPushSupported();
    }

    @Override
    protected final void doPush(Request request) {
        try {
            this.stream.push(request);
        }
        catch (IOException iOException) {
            this.setErrorState(ErrorState.CLOSE_CONNECTION_NOW, iOException);
            this.response.setErrorException(iOException);
        }
    }

    @Override
    protected Object getConnectionID() {
        return this.stream.getConnectionId();
    }

    @Override
    protected Object getStreamID() {
        return this.stream.getIdAsString().toString();
    }

    @Override
    public void recycle() {
        this.setSocketWrapper(null);
        this.setAdapter(null);
    }

    @Override
    protected Log getLog() {
        return log;
    }

    @Override
    public void pause() {
    }

    @Override
    public AbstractEndpoint.Handler.SocketState service(SocketWrapperBase<?> socketWrapperBase) throws IOException {
        try {
            this.adapter.service(this.request, this.response);
        }
        catch (Exception exception) {
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("streamProcessor.service.error"), (Throwable)exception);
            }
            this.response.setStatus(500);
            this.setErrorState(ErrorState.CLOSE_NOW, exception);
        }
        if (!this.isAsync()) {
            this.endRequest();
        }
        if (this.getErrorState().isError()) {
            this.action(ActionCode.CLOSE, null);
            this.request.updateCounters();
            return AbstractEndpoint.Handler.SocketState.CLOSED;
        }
        if (this.isAsync()) {
            return AbstractEndpoint.Handler.SocketState.LONG;
        }
        this.action(ActionCode.CLOSE, null);
        this.request.updateCounters();
        return AbstractEndpoint.Handler.SocketState.CLOSED;
    }

    @Override
    protected boolean flushBufferedWrite() throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("streamProcessor.flushBufferedWrite.entry", new Object[]{this.stream.getConnectionId(), this.stream.getIdAsString()}));
        }
        if (this.stream.flush(false)) {
            if (this.stream.isReadyForWrite()) {
                throw new IllegalStateException();
            }
            return true;
        }
        return false;
    }

    @Override
    protected final AbstractEndpoint.Handler.SocketState dispatchEndRequest() throws IOException {
        this.endRequest();
        return AbstractEndpoint.Handler.SocketState.CLOSED;
    }

    private void endRequest() throws IOException {
        if (!this.stream.isInputFinished() && this.getErrorState().isIoAllowed()) {
            StreamException streamException = new StreamException(sm.getString("streamProcessor.cancel", new Object[]{this.stream.getConnectionId(), this.stream.getIdAsString()}), Http2Error.CANCEL, this.stream.getIdAsInt());
            this.handler.sendStreamReset(streamException);
        }
    }
}

