/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.UIManager;
import org.openide.windows.TopComponent;

public class ProfilerTopComponent
extends TopComponent {
    public static final String RECENT_FILE_KEY = "nb.recent.file.path";
    private Component lastFocusOwner;
    private final PropertyChangeListener focusListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Component component = propertyChangeEvent.getNewValue() instanceof Component ? (Component)propertyChangeEvent.getNewValue() : null;
            this.processFocusedComponent(component);
        }

        private void processFocusedComponent(Component component) {
            Component component2 = component;
            while (component != null) {
                if (component == ProfilerTopComponent.this) {
                    ProfilerTopComponent.this.lastFocusOwner = component2;
                    return;
                }
                component = component.getParent();
            }
        }
    };

    protected void componentActivated() {
        super.componentActivated();
        if (this.lastFocusOwner != null) {
            this.lastFocusOwner.requestFocus();
        } else {
            Component component = this.defaultFocusOwner();
            if (component != null) {
                component.requestFocus();
            }
        }
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener("focusOwner", this.focusListener);
    }

    protected void componentDeactivated() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener("focusOwner", this.focusListener);
        super.componentDeactivated();
    }

    protected Component defaultFocusOwner() {
        return null;
    }

    public Dimension getMinimumSize() {
        return new Dimension(0, 0);
    }

    public void paintComponent(Graphics graphics) {
        Color color = UIManager.getColor("ProfilerPanels.background");
        if (color != null) {
            graphics.setColor(color);
            Insets insets = this.getInsets();
            graphics.fillRect(insets.left, insets.top, this.getWidth() - insets.left - insets.right, this.getHeight() - insets.top - insets.bottom);
        } else {
            super.paintComponent(graphics);
        }
    }
}

