/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.cairo.Cairo;
import org.eclipse.swt.internal.gtk.GdkRGBA;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.GtkRequisition;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.IME;

public class Canvas
extends Composite {
    Caret caret;
    IME ime;

    Canvas() {
    }

    public Canvas(Composite composite, int n) {
        super(composite, Canvas.checkStyle(n));
    }

    public void drawBackground(GC gC, int n, int n2, int n3, int n4) {
        this.drawBackground(gC, n, n2, n3, n4, 0, 0);
    }

    public Caret getCaret() {
        this.checkWidget();
        return this.caret;
    }

    @Override
    Point getIMCaretPos() {
        if (this.caret == null) {
            return super.getIMCaretPos();
        }
        return new Point(this.caret.x, this.caret.y);
    }

    public IME getIME() {
        this.checkWidget();
        return this.ime;
    }

    @Override
    long gtk_button_press_event(long l, long l2) {
        long l3;
        if (this.ime != null && (l3 = this.ime.gtk_button_press_event(l, l2)) != 0L) {
            return l3;
        }
        return super.gtk_button_press_event(l, l2);
    }

    @Override
    long gtk_commit(long l, long l2) {
        long l3;
        if (this.ime != null && (l3 = this.ime.gtk_commit(l, l2)) != 0L) {
            return l3;
        }
        return super.gtk_commit(l, l2);
    }

    @Override
    long gtk_draw(long l, long l2) {
        boolean bl;
        if ((this.state & 0x40) != 0) {
            return 0L;
        }
        boolean bl2 = bl = this.caret != null && this.caret.isFocusCaret();
        if (bl) {
            this.caret.killFocus();
        }
        long l3 = super.gtk_draw(l, l2);
        if (bl) {
            this.caret.setFocus();
        }
        return l3;
    }

    @Override
    long gtk_expose_event(long l, long l2) {
        boolean bl;
        if ((this.state & 0x40) != 0) {
            return 0L;
        }
        boolean bl2 = bl = this.caret != null && this.caret.isFocusCaret();
        if (bl) {
            this.caret.killFocus();
        }
        long l3 = super.gtk_expose_event(l, l2);
        if (bl) {
            this.caret.setFocus();
        }
        return l3;
    }

    @Override
    long gtk_focus_in_event(long l, long l2) {
        long l3 = super.gtk_focus_in_event(l, l2);
        if (this.caret != null) {
            this.caret.setFocus();
        }
        return l3;
    }

    @Override
    long gtk_focus_out_event(long l, long l2) {
        long l3 = super.gtk_focus_out_event(l, l2);
        if (this.caret != null) {
            this.caret.killFocus();
        }
        return l3;
    }

    @Override
    long gtk_preedit_changed(long l) {
        long l2;
        if (this.ime != null && (l2 = this.ime.gtk_preedit_changed(l)) != 0L) {
            return l2;
        }
        return super.gtk_preedit_changed(l);
    }

    @Override
    void redrawWidget(int n, int n2, int n3, int n4, boolean bl, boolean bl2, boolean bl3) {
        boolean bl4;
        boolean bl5 = bl4 = this.caret != null && this.caret.isFocusCaret();
        if (bl4) {
            this.caret.killFocus();
        }
        super.redrawWidget(n, n2, n3, n4, bl, bl2, bl3);
        if (bl4) {
            this.caret.setFocus();
        }
    }

    @Override
    void releaseChildren(boolean bl) {
        if (this.caret != null) {
            this.caret.release(false);
            this.caret = null;
        }
        if (this.ime != null) {
            this.ime.release(false);
            this.ime = null;
        }
        super.releaseChildren(bl);
    }

    @Override
    void reskinChildren(int n) {
        if (this.caret != null) {
            this.caret.reskin(n);
        }
        if (this.ime != null) {
            this.ime.reskin(n);
        }
        super.reskinChildren(n);
    }

    public void scroll(int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        this.checkWidget();
        if (n5 <= 0 || n6 <= 0) {
            return;
        }
        Point point = DPIUtil.autoScaleUp(new Point(n, n2));
        Rectangle rectangle = DPIUtil.autoScaleUp(new Rectangle(n3, n4, n5, n6));
        this.scrollInPixels(point.x, point.y, rectangle.x, rectangle.y, rectangle.width, rectangle.height, bl);
    }

    void scrollInPixels(int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        Object object;
        Control control;
        Object object2;
        long l;
        long l2;
        boolean bl2;
        int n7;
        if ((this.style & 0x8000000) != 0) {
            n7 = this.getClientWidth();
            n3 = n7 - n5 - n3;
            n = n7 - n5 - n;
        }
        n7 = n - n3;
        int n8 = n2 - n4;
        if (n7 == 0 && n8 == 0) {
            return;
        }
        if (!this.isVisible()) {
            return;
        }
        boolean bl3 = bl2 = this.caret != null && this.caret.isFocusCaret();
        if (bl2) {
            this.caret.killFocus();
        }
        long l3 = this.paintWindow();
        long l4 = OS.GTK3 ? OS.gdk_window_get_visible_region(l3) : OS.gdk_drawable_get_visible_region(l3);
        GdkRectangle gdkRectangle = new GdkRectangle();
        gdkRectangle.x = n3;
        gdkRectangle.y = n4;
        if (OS.GTK_VERSION >= OS.VERSION(3, 16, 0)) {
            l2 = 0L;
            l = 0L;
            if (OS.GTK_IS_SCROLLED_WINDOW(this.scrolledHandle)) {
                l2 = OS.gtk_scrolled_window_get_hscrollbar(this.scrolledHandle);
                l = OS.gtk_scrolled_window_get_vscrollbar(this.scrolledHandle);
            }
            object2 = new GtkRequisition();
            if (l2 != 0L) {
                this.gtk_widget_get_preferred_size(l2, (GtkRequisition)object2);
                if (((GtkRequisition)object2).height > 0) {
                    gdkRectangle.y = n4 - ((GtkRequisition)object2).height;
                }
            }
            if (l != 0L) {
                this.gtk_widget_get_preferred_size(l, (GtkRequisition)object2);
                if (((GtkRequisition)object2).width > 0) {
                    gdkRectangle.x = n3 - ((GtkRequisition)object2).width;
                }
            }
        }
        gdkRectangle.width = n5;
        gdkRectangle.height = n6;
        l2 = OS.gdk_region_rectangle(gdkRectangle);
        OS.gdk_region_intersect(l2, l4);
        l = OS.gdk_region_rectangle(gdkRectangle);
        OS.gdk_region_subtract(l, l4);
        OS.gdk_region_offset(l, n7, n8);
        object2 = new GdkRectangle();
        OS.gdk_region_get_clipbox(l2, (GdkRectangle)object2);
        if (((GdkRectangle)object2).width != 0 && ((GdkRectangle)object2).height != 0) {
            this.update();
        }
        if ((control = this.findBackgroundControl()) == null) {
            control = this;
        }
        if (control.backgroundImage != null) {
            this.redrawWidget(n3, n4, n5, n6, false, false, false);
            this.redrawWidget(n, n2, n5, n6, false, false, false);
        } else {
            GdkRectangle gdkRectangle2;
            boolean bl4;
            long l5;
            if (OS.GTK3) {
                l5 = OS.gdk_cairo_create(l3);
                if (Cairo.cairo_version() < Cairo.CAIRO_VERSION_ENCODE(1, 12, 0)) {
                    OS.gdk_cairo_set_source_window(l5, l3, 0, 0);
                } else {
                    Cairo.cairo_push_group(l5);
                    OS.gdk_cairo_set_source_window(l5, l3, 0, 0);
                    Cairo.cairo_paint(l5);
                    Cairo.cairo_pop_group_to_source(l5);
                }
                object = new double[]{1.0, 0.0, 0.0, 1.0, -n7, -n8};
                Cairo.cairo_pattern_set_matrix(Cairo.cairo_get_source(l5), (double[])object);
                Cairo.cairo_rectangle(l5, ((GdkRectangle)object2).x + n7, ((GdkRectangle)object2).y + n8, ((GdkRectangle)object2).width, ((GdkRectangle)object2).height);
                Cairo.cairo_clip(l5);
                Cairo.cairo_paint(l5);
                Cairo.cairo_destroy(l5);
            } else {
                l5 = OS.gdk_gc_new(l3);
                OS.gdk_gc_set_exposures(l5, true);
                OS.gdk_draw_drawable(l3, l5, l3, ((GdkRectangle)object2).x, ((GdkRectangle)object2).y, ((GdkRectangle)object2).x + n7, ((GdkRectangle)object2).y + n8, ((GdkRectangle)object2).width, ((GdkRectangle)object2).height);
                OS.g_object_unref(l5);
            }
            boolean bl5 = bl4 = n + n5 < n3 || n3 + n5 < n || n2 + n6 < n4 || n4 + n6 < n2;
            if (bl4) {
                gdkRectangle2 = new GdkRectangle();
                gdkRectangle2.x = n3;
                gdkRectangle2.y = n4;
                gdkRectangle2.width = n5;
                gdkRectangle2.height = n6;
                OS.gdk_region_union_with_rect(l, gdkRectangle2);
            } else {
                gdkRectangle2 = new GdkRectangle();
                if (n7 != 0) {
                    int n9 = n - n7;
                    if (n7 < 0) {
                        n9 = n + n5;
                    }
                    gdkRectangle2.x = n9;
                    gdkRectangle2.y = n4;
                    gdkRectangle2.width = Math.abs(n7);
                    gdkRectangle2.height = n6;
                    OS.gdk_region_union_with_rect(l, gdkRectangle2);
                }
                if (n8 != 0) {
                    int n10 = n2 - n8;
                    if (n8 < 0) {
                        n10 = n2 + n6;
                    }
                    gdkRectangle2.x = n3;
                    gdkRectangle2.y = n10;
                    gdkRectangle2.width = n5;
                    gdkRectangle2.height = Math.abs(n8);
                    OS.gdk_region_union_with_rect(l, gdkRectangle2);
                }
            }
            OS.gdk_window_invalidate_region(l3, l, bl);
        }
        OS.gdk_region_destroy(l4);
        OS.gdk_region_destroy(l2);
        OS.gdk_region_destroy(l);
        if (bl) {
            Control[] controlArray = this._getChildren();
            for (int i = 0; i < controlArray.length; ++i) {
                object = controlArray[i];
                Rectangle rectangle = ((Control)object).getBoundsInPixels();
                if (Math.min(n3 + n5, rectangle.x + rectangle.width) < Math.max(n3, rectangle.x) || Math.min(n4 + n6, rectangle.y + rectangle.height) < Math.max(n4, rectangle.y)) continue;
                ((Control)object).setLocationInPixels(rectangle.x + n7, rectangle.y + n8);
            }
        }
        if (bl2) {
            this.caret.setFocus();
        }
        if (OS.GTK_VERSION >= OS.VERSION(3, 16, 0)) {
            this.redraw(false);
        }
    }

    @Override
    int setBounds(int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        boolean bl3;
        boolean bl4 = bl3 = this.caret != null && this.caret.isFocusCaret();
        if (bl3) {
            this.caret.killFocus();
        }
        int n5 = super.setBounds(n, n2, n3, n4, bl, bl2);
        if (bl3) {
            this.caret.setFocus();
        }
        return n5;
    }

    @Override
    void setForegroundColor(long l, GdkRGBA gdkRGBA) {
        if (this.cssBackground == null) {
            GdkRGBA gdkRGBA2 = this.display.toGdkRGBA(this.display.COLOR_WIDGET_BACKGROUND);
            this.cssBackground = "SwtFixed {background-color: " + this.display.gtk_rgba_to_css_string(gdkRGBA2) + ";}";
        }
        super.setForegroundColor(l, gdkRGBA);
    }

    public void setCaret(Caret caret) {
        this.checkWidget();
        Caret caret2 = caret;
        Caret caret3 = this.caret;
        this.caret = caret2;
        if (this.hasFocus()) {
            if (caret3 != null) {
                caret3.killFocus();
            }
            if (caret2 != null) {
                if (caret2.isDisposed()) {
                    this.error(5);
                }
                caret2.setFocus();
            }
        }
    }

    @Override
    public void setFont(Font font) {
        this.checkWidget();
        if (this.caret != null) {
            this.caret.setFont(font);
        }
        super.setFont(font);
    }

    public void setIME(IME iME) {
        this.checkWidget();
        if (iME != null && iME.isDisposed()) {
            this.error(5);
        }
        this.ime = iME;
    }

    void updateCaret() {
        long l = this.imHandle();
        if (l == 0L) {
            return;
        }
        GdkRectangle gdkRectangle = new GdkRectangle();
        gdkRectangle.x = this.caret.x;
        gdkRectangle.y = this.caret.y;
        gdkRectangle.width = this.caret.width;
        gdkRectangle.height = this.caret.height;
        OS.gtk_im_context_set_cursor_location(l, gdkRectangle);
    }
}

