/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net.jsse;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.EncryptedPrivateKeyInfo;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import org.apache.tomcat.util.buf.Asn1Parser;
import org.apache.tomcat.util.buf.Asn1Writer;
import org.apache.tomcat.util.codec.binary.Base64;
import org.apache.tomcat.util.file.ConfigFileLoader;
import org.apache.tomcat.util.res.StringManager;

public class PEMFile {
    private static final StringManager sm = StringManager.getManager(PEMFile.class);
    private static final byte[] OID_EC_PUBLIC_KEY = new byte[]{6, 7, 42, -122, 72, -50, 61, 2, 1};
    private String filename;
    private List<X509Certificate> certificates = new ArrayList<X509Certificate>();
    private PrivateKey privateKey;

    public static String toPEM(X509Certificate x509Certificate) throws CertificateEncodingException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("-----BEGIN CERTIFICATE-----");
        stringBuilder.append(System.lineSeparator());
        Base64 base64 = new Base64(64);
        stringBuilder.append(base64.encodeAsString(x509Certificate.getEncoded()));
        stringBuilder.append("-----END CERTIFICATE-----");
        return stringBuilder.toString();
    }

    public List<X509Certificate> getCertificates() {
        return this.certificates;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public PEMFile(String string) throws IOException, GeneralSecurityException {
        this(string, null);
    }

    public PEMFile(String string, String string2) throws IOException, GeneralSecurityException {
        this(string, string2, null);
    }

    public PEMFile(String string, String string2, String string3) throws IOException, GeneralSecurityException {
        this.filename = string;
        ArrayList<Part> arrayList = new ArrayList<Part>();
        try (InputStream inputStream = ConfigFileLoader.getSource().getResource(string).getInputStream();){
            String string4;
            BufferedReader object = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.US_ASCII));
            Object object2 = null;
            while ((string4 = object.readLine()) != null) {
                if (string4.startsWith("-----BEGIN ")) {
                    object2 = new Part();
                    ((Part)object2).type = string4.substring("-----BEGIN ".length(), string4.length() - "-----".length()).trim();
                    continue;
                }
                if (string4.startsWith("-----END ")) {
                    arrayList.add((Part)object2);
                    object2 = null;
                    continue;
                }
                if (object2 == null || string4.contains(":") || string4.startsWith(" ")) continue;
                ((Part)object2).content = ((Part)object2).content + string4;
            }
        }
        for (Part part : arrayList) {
            switch (part.type) {
                case "PRIVATE KEY": {
                    this.privateKey = part.toPrivateKey(null, string3, Format.PKCS8);
                    break;
                }
                case "EC PRIVATE KEY": {
                    this.privateKey = part.toPrivateKey(null, "EC", Format.RFC5915);
                    break;
                }
                case "ENCRYPTED PRIVATE KEY": {
                    this.privateKey = part.toPrivateKey(string2, string3, Format.PKCS8);
                    break;
                }
                case "RSA PRIVATE KEY": {
                    this.privateKey = part.toPrivateKey(null, string3, Format.PKCS1);
                    break;
                }
                case "CERTIFICATE": 
                case "X509 CERTIFICATE": {
                    this.certificates.add(part.toCertificate());
                }
            }
        }
    }

    private class Part {
        public static final String BEGIN_BOUNDARY = "-----BEGIN ";
        public static final String END_BOUNDARY = "-----END ";
        public static final String FINISH_BOUNDARY = "-----";
        public static final String PRIVATE_KEY = "PRIVATE KEY";
        public static final String EC_PRIVATE_KEY = "EC PRIVATE KEY";
        public static final String ENCRYPTED_PRIVATE_KEY = "ENCRYPTED PRIVATE KEY";
        public static final String RSA_PRIVATE_KEY = "RSA PRIVATE KEY";
        public static final String CERTIFICATE = "CERTIFICATE";
        public static final String X509_CERTIFICATE = "X509 CERTIFICATE";
        public String type;
        public String content = "";

        private Part() {
        }

        private byte[] decode() {
            return Base64.decodeBase64((String)this.content);
        }

        public X509Certificate toCertificate() throws CertificateException {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            return (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(this.decode()));
        }

        public PrivateKey toPrivateKey(String string, String string2, Format format) throws GeneralSecurityException, IOException {
            Object object;
            KeySpec keySpec = null;
            if (string == null) {
                switch (format) {
                    case PKCS1: {
                        keySpec = this.parsePKCS1(this.decode());
                        break;
                    }
                    case PKCS8: {
                        keySpec = new PKCS8EncodedKeySpec(this.decode());
                        break;
                    }
                    case RFC5915: {
                        keySpec = new PKCS8EncodedKeySpec(this.rfc5915ToPkcs8(this.decode()));
                    }
                }
            } else {
                object = new EncryptedPrivateKeyInfo(this.decode());
                String[] stringArray = SecretKeyFactory.getInstance(((EncryptedPrivateKeyInfo)object).getAlgName());
                SecretKey secretKey = stringArray.generateSecret(new PBEKeySpec(string.toCharArray()));
                Cipher cipher = Cipher.getInstance(((EncryptedPrivateKeyInfo)object).getAlgName());
                cipher.init(2, (Key)secretKey, ((EncryptedPrivateKeyInfo)object).getAlgParameters());
                keySpec = ((EncryptedPrivateKeyInfo)object).getKeySpec(cipher);
            }
            object = new InvalidKeyException(sm.getString("pemFile.parseError", new Object[]{PEMFile.this.filename}));
            if (string2 == null) {
                for (String string3 : new String[]{"RSA", "DSA", "EC"}) {
                    try {
                        return KeyFactory.getInstance(string3).generatePrivate(keySpec);
                    }
                    catch (InvalidKeySpecException invalidKeySpecException) {
                        ((Throwable)object).addSuppressed(invalidKeySpecException);
                    }
                }
            } else {
                try {
                    return KeyFactory.getInstance(string2).generatePrivate(keySpec);
                }
                catch (InvalidKeySpecException invalidKeySpecException) {
                    ((Throwable)object).addSuppressed(invalidKeySpecException);
                }
            }
            throw object;
        }

        private byte[] rfc5915ToPkcs8(byte[] byArray) {
            Asn1Parser asn1Parser = new Asn1Parser(byArray);
            asn1Parser.parseTag(48);
            asn1Parser.parseFullLength();
            BigInteger bigInteger = asn1Parser.parseInt();
            if (bigInteger.intValue() != 1) {
                throw new IllegalArgumentException(sm.getString("pemFile.notValidRFC5915"));
            }
            asn1Parser.parseTag(4);
            int n = asn1Parser.parseLength();
            byte[] byArray2 = new byte[n];
            asn1Parser.parseBytes(byArray2);
            asn1Parser.parseTag(160);
            int n2 = asn1Parser.parseLength();
            byte[] byArray3 = new byte[n2];
            asn1Parser.parseBytes(byArray3);
            if (byArray3[0] != 6) {
                throw new IllegalArgumentException(sm.getString("pemFile.notValidRFC5915"));
            }
            asn1Parser.parseTag(161);
            int n3 = asn1Parser.parseLength();
            byte[] byArray4 = new byte[n3];
            asn1Parser.parseBytes(byArray4);
            if (byArray4[0] != 3) {
                throw new IllegalArgumentException(sm.getString("pemFile.notValidRFC5915"));
            }
            return Asn1Writer.writeSequence((byte[][])new byte[][]{Asn1Writer.writeInteger((int)0), Asn1Writer.writeSequence((byte[][])new byte[][]{OID_EC_PUBLIC_KEY, byArray3}), Asn1Writer.writeOctetString((byte[])Asn1Writer.writeSequence((byte[][])new byte[][]{Asn1Writer.writeInteger((int)1), Asn1Writer.writeOctetString((byte[])byArray2), Asn1Writer.writeTag((byte)-95, (byte[])byArray4)}))});
        }

        private RSAPrivateCrtKeySpec parsePKCS1(byte[] byArray) {
            Asn1Parser asn1Parser = new Asn1Parser(byArray);
            asn1Parser.parseTag(48);
            asn1Parser.parseFullLength();
            BigInteger bigInteger = asn1Parser.parseInt();
            if (bigInteger.intValue() == 1) {
                throw new IllegalArgumentException(sm.getString("pemFile.noMultiPrimes"));
            }
            return new RSAPrivateCrtKeySpec(asn1Parser.parseInt(), asn1Parser.parseInt(), asn1Parser.parseInt(), asn1Parser.parseInt(), asn1Parser.parseInt(), asn1Parser.parseInt(), asn1Parser.parseInt(), asn1Parser.parseInt());
        }
    }

    private static enum Format {
        PKCS1,
        PKCS8,
        RFC5915;

    }
}

