/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.compat;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLConnection;
import java.util.Deque;
import java.util.jar.JarFile;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import org.apache.tomcat.util.compat.GraalCompat;
import org.apache.tomcat.util.compat.Jre9Compat;
import org.apache.tomcat.util.res.StringManager;

public class JreCompat {
    private static final int RUNTIME_MAJOR_VERSION = 8;
    private static final JreCompat instance;
    private static final boolean graalAvailable;
    private static final boolean jre11Available;
    private static final boolean jre9Available;
    private static final StringManager sm;
    protected static final Method setApplicationProtocolsMethod;
    protected static final Method getApplicationProtocolMethod;

    public static JreCompat getInstance() {
        return instance;
    }

    public static boolean isGraalAvailable() {
        return graalAvailable;
    }

    public static boolean isAlpnSupported() {
        return setApplicationProtocolsMethod != null && getApplicationProtocolMethod != null;
    }

    public static boolean isJre9Available() {
        return jre9Available;
    }

    public static boolean isJre11Available() {
        return jre11Available;
    }

    public boolean isInstanceOfInaccessibleObjectException(Throwable throwable) {
        return false;
    }

    public void setApplicationProtocols(SSLParameters sSLParameters, String[] stringArray) {
        if (setApplicationProtocolsMethod != null) {
            try {
                setApplicationProtocolsMethod.invoke((Object)sSLParameters, new Object[]{stringArray});
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                throw new UnsupportedOperationException(exception);
            }
        } else {
            throw new UnsupportedOperationException(sm.getString("jreCompat.noApplicationProtocols"));
        }
    }

    public String getApplicationProtocol(SSLEngine sSLEngine) {
        if (getApplicationProtocolMethod != null) {
            try {
                return (String)getApplicationProtocolMethod.invoke((Object)sSLEngine, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                throw new UnsupportedOperationException(exception);
            }
        }
        throw new UnsupportedOperationException(sm.getString("jreCompat.noApplicationProtocol"));
    }

    public void disableCachingForJarUrlConnections() throws IOException {
        URL uRL = new URL("jar:file://dummy.jar!/");
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.setDefaultUseCaches(false);
    }

    public void addBootModulePath(Deque<URL> deque) {
    }

    public final JarFile jarFileNewInstance(String string) throws IOException {
        return this.jarFileNewInstance(new File(string));
    }

    public JarFile jarFileNewInstance(File file) throws IOException {
        return new JarFile(file);
    }

    public boolean jarFileIsMultiRelease(JarFile jarFile) {
        return false;
    }

    public int jarFileRuntimeMajorVersion() {
        return 8;
    }

    public boolean canAccess(Object object, AccessibleObject accessibleObject) {
        return true;
    }

    public boolean isExported(Class<?> clazz) {
        return true;
    }

    public String getModuleName(Class<?> clazz) {
        return "NO_MODULE_JAVA_8";
    }

    static {
        sm = StringManager.getManager(JreCompat.class);
        if (GraalCompat.isSupported()) {
            instance = new GraalCompat();
            graalAvailable = true;
            jre9Available = Jre9Compat.isSupported();
        } else if (Jre9Compat.isSupported()) {
            instance = new Jre9Compat();
            graalAvailable = false;
            jre9Available = true;
        } else {
            instance = new JreCompat();
            graalAvailable = false;
            jre9Available = false;
        }
        jre11Available = instance.jarFileRuntimeMajorVersion() >= 11;
        Method method = null;
        Method method2 = null;
        try {
            method = SSLParameters.class.getMethod("setApplicationProtocols", String[].class);
            method2 = SSLEngine.class.getMethod("getApplicationProtocol", new Class[0]);
        }
        catch (IllegalArgumentException | ReflectiveOperationException exception) {
            // empty catch block
        }
        setApplicationProtocolsMethod = method;
        getApplicationProtocolMethod = method2;
    }
}

