/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.websocket.server;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.SocketEvent;
import org.apache.tomcat.util.net.SocketWrapperBase;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.websocket.Transformation;
import org.apache.tomcat.websocket.WsFrameBase;
import org.apache.tomcat.websocket.WsIOException;
import org.apache.tomcat.websocket.WsSession;

public class WsFrameServer
extends WsFrameBase {
    private final Log log = LogFactory.getLog(WsFrameServer.class);
    private static final StringManager sm = StringManager.getManager(WsFrameServer.class);
    private final SocketWrapperBase<?> socketWrapper;
    private final ClassLoader applicationClassLoader;

    public WsFrameServer(SocketWrapperBase<?> socketWrapperBase, WsSession wsSession, Transformation transformation, ClassLoader classLoader) {
        super(wsSession, transformation);
        this.socketWrapper = socketWrapperBase;
        this.applicationClassLoader = classLoader;
    }

    private void onDataAvailable() throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"wsFrameServer.onDataAvailable");
        }
        if (this.isOpen() && this.inputBuffer.hasRemaining() && !this.isSuspended()) {
            this.processInputBuffer();
        }
        while (this.isOpen() && !this.isSuspended()) {
            this.inputBuffer.mark();
            this.inputBuffer.position(this.inputBuffer.limit()).limit(this.inputBuffer.capacity());
            int n = this.socketWrapper.read(false, this.inputBuffer);
            this.inputBuffer.limit(this.inputBuffer.position()).reset();
            if (n < 0) {
                throw new EOFException();
            }
            if (n == 0) {
                return;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)sm.getString("wsFrameServer.bytesRead", new Object[]{Integer.toString(n)}));
            }
            this.processInputBuffer();
        }
    }

    @Override
    protected boolean isMasked() {
        return true;
    }

    @Override
    protected Transformation getTransformation() {
        return super.getTransformation();
    }

    @Override
    protected boolean isOpen() {
        return super.isOpen();
    }

    @Override
    protected Log getLog() {
        return this.log;
    }

    @Override
    protected void sendMessageText(boolean bl) throws WsIOException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.applicationClassLoader);
            super.sendMessageText(bl);
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void sendMessageBinary(ByteBuffer byteBuffer, boolean bl) throws WsIOException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.applicationClassLoader);
            super.sendMessageBinary(byteBuffer, bl);
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    @Override
    protected void resumeProcessing() {
        this.socketWrapper.processSocket(SocketEvent.OPEN_READ, true);
    }

    AbstractEndpoint.Handler.SocketState notifyDataAvailable() throws IOException {
        block6: while (this.isOpen()) {
            switch (this.getReadState()) {
                case WAITING: {
                    if (!this.changeReadState(WsFrameBase.ReadState.WAITING, WsFrameBase.ReadState.PROCESSING)) continue block6;
                    try {
                        return this.doOnDataAvailable();
                    }
                    catch (IOException iOException) {
                        this.changeReadState(WsFrameBase.ReadState.CLOSING);
                        throw iOException;
                    }
                }
                case SUSPENDING_WAIT: {
                    if (!this.changeReadState(WsFrameBase.ReadState.SUSPENDING_WAIT, WsFrameBase.ReadState.SUSPENDED)) continue block6;
                    return AbstractEndpoint.Handler.SocketState.SUSPENDED;
                }
            }
            throw new IllegalStateException(sm.getString("wsFrameServer.illegalReadState", new Object[]{this.getReadState()}));
        }
        return AbstractEndpoint.Handler.SocketState.CLOSED;
    }

    private AbstractEndpoint.Handler.SocketState doOnDataAvailable() throws IOException {
        this.onDataAvailable();
        block4: while (this.isOpen()) {
            switch (this.getReadState()) {
                case PROCESSING: {
                    if (!this.changeReadState(WsFrameBase.ReadState.PROCESSING, WsFrameBase.ReadState.WAITING)) continue block4;
                    return AbstractEndpoint.Handler.SocketState.UPGRADED;
                }
                case SUSPENDING_PROCESS: {
                    if (!this.changeReadState(WsFrameBase.ReadState.SUSPENDING_PROCESS, WsFrameBase.ReadState.SUSPENDED)) continue block4;
                    return AbstractEndpoint.Handler.SocketState.SUSPENDED;
                }
            }
            throw new IllegalStateException(sm.getString("wsFrameServer.illegalReadState", new Object[]{this.getReadState()}));
        }
        return AbstractEndpoint.Handler.SocketState.CLOSED;
    }
}

