/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.pool2.impl;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Deque;
import java.util.Iterator;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.apache.tomcat.dbcp.pool2.BaseObject;
import org.apache.tomcat.dbcp.pool2.PooledObject;
import org.apache.tomcat.dbcp.pool2.PooledObjectState;
import org.apache.tomcat.dbcp.pool2.SwallowedExceptionListener;
import org.apache.tomcat.dbcp.pool2.impl.BaseObjectPoolConfig;
import org.apache.tomcat.dbcp.pool2.impl.EvictionPolicy;
import org.apache.tomcat.dbcp.pool2.impl.EvictionTimer;

public abstract class BaseGenericObjectPool<T>
extends BaseObject {
    public static final int MEAN_TIMING_STATS_CACHE_SIZE = 100;
    private static final String EVICTION_POLICY_TYPE_NAME = EvictionPolicy.class.getName();
    private volatile int maxTotal = -1;
    private volatile boolean blockWhenExhausted = true;
    private volatile long maxWaitMillis = -1L;
    private volatile boolean lifo = true;
    private final boolean fairness;
    private volatile boolean testOnCreate = false;
    private volatile boolean testOnBorrow = false;
    private volatile boolean testOnReturn = false;
    private volatile boolean testWhileIdle = false;
    private volatile long timeBetweenEvictionRunsMillis = -1L;
    private volatile int numTestsPerEvictionRun = 3;
    private volatile long minEvictableIdleTimeMillis = 1800000L;
    private volatile long softMinEvictableIdleTimeMillis = -1L;
    private volatile EvictionPolicy<T> evictionPolicy;
    private volatile long evictorShutdownTimeoutMillis = 10000L;
    final Object closeLock = new Object();
    volatile boolean closed = false;
    final Object evictionLock = new Object();
    private Evictor evictor = null;
    EvictionIterator evictionIterator = null;
    private final WeakReference<ClassLoader> factoryClassLoader;
    private final ObjectName objectName;
    private final String creationStackTrace;
    private final AtomicLong borrowedCount = new AtomicLong(0L);
    private final AtomicLong returnedCount = new AtomicLong(0L);
    final AtomicLong createdCount = new AtomicLong(0L);
    final AtomicLong destroyedCount = new AtomicLong(0L);
    final AtomicLong destroyedByEvictorCount = new AtomicLong(0L);
    final AtomicLong destroyedByBorrowValidationCount = new AtomicLong(0L);
    private final StatsStore activeTimes = new StatsStore(100);
    private final StatsStore idleTimes = new StatsStore(100);
    private final StatsStore waitTimes = new StatsStore(100);
    private final AtomicLong maxBorrowWaitTimeMillis = new AtomicLong(0L);
    private volatile SwallowedExceptionListener swallowedExceptionListener = null;

    public BaseGenericObjectPool(BaseObjectPoolConfig<T> baseObjectPoolConfig, String string, String string2) {
        this.objectName = baseObjectPoolConfig.getJmxEnabled() ? this.jmxRegister(baseObjectPoolConfig, string, string2) : null;
        this.creationStackTrace = this.getStackTrace(new Exception());
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        this.factoryClassLoader = classLoader == null ? null : new WeakReference<ClassLoader>(classLoader);
        this.fairness = baseObjectPoolConfig.getFairness();
    }

    public final int getMaxTotal() {
        return this.maxTotal;
    }

    public final void setMaxTotal(int n) {
        this.maxTotal = n;
    }

    public final boolean getBlockWhenExhausted() {
        return this.blockWhenExhausted;
    }

    public final void setBlockWhenExhausted(boolean bl) {
        this.blockWhenExhausted = bl;
    }

    protected void setConfig(BaseObjectPoolConfig<T> baseObjectPoolConfig) {
        this.setLifo(baseObjectPoolConfig.getLifo());
        this.setMaxWaitMillis(baseObjectPoolConfig.getMaxWaitMillis());
        this.setBlockWhenExhausted(baseObjectPoolConfig.getBlockWhenExhausted());
        this.setTestOnCreate(baseObjectPoolConfig.getTestOnCreate());
        this.setTestOnBorrow(baseObjectPoolConfig.getTestOnBorrow());
        this.setTestOnReturn(baseObjectPoolConfig.getTestOnReturn());
        this.setTestWhileIdle(baseObjectPoolConfig.getTestWhileIdle());
        this.setNumTestsPerEvictionRun(baseObjectPoolConfig.getNumTestsPerEvictionRun());
        this.setMinEvictableIdleTimeMillis(baseObjectPoolConfig.getMinEvictableIdleTimeMillis());
        this.setTimeBetweenEvictionRunsMillis(baseObjectPoolConfig.getTimeBetweenEvictionRunsMillis());
        this.setSoftMinEvictableIdleTimeMillis(baseObjectPoolConfig.getSoftMinEvictableIdleTimeMillis());
        EvictionPolicy<T> evictionPolicy = baseObjectPoolConfig.getEvictionPolicy();
        if (evictionPolicy == null) {
            this.setEvictionPolicyClassName(baseObjectPoolConfig.getEvictionPolicyClassName());
        } else {
            this.setEvictionPolicy(evictionPolicy);
        }
        this.setEvictorShutdownTimeoutMillis(baseObjectPoolConfig.getEvictorShutdownTimeoutMillis());
    }

    public final long getMaxWaitMillis() {
        return this.maxWaitMillis;
    }

    public final void setMaxWaitMillis(long l) {
        this.maxWaitMillis = l;
    }

    public final boolean getLifo() {
        return this.lifo;
    }

    public final boolean getFairness() {
        return this.fairness;
    }

    public final void setLifo(boolean bl) {
        this.lifo = bl;
    }

    public final boolean getTestOnCreate() {
        return this.testOnCreate;
    }

    public final void setTestOnCreate(boolean bl) {
        this.testOnCreate = bl;
    }

    public final boolean getTestOnBorrow() {
        return this.testOnBorrow;
    }

    public final void setTestOnBorrow(boolean bl) {
        this.testOnBorrow = bl;
    }

    public final boolean getTestOnReturn() {
        return this.testOnReturn;
    }

    public final void setTestOnReturn(boolean bl) {
        this.testOnReturn = bl;
    }

    public final boolean getTestWhileIdle() {
        return this.testWhileIdle;
    }

    public final void setTestWhileIdle(boolean bl) {
        this.testWhileIdle = bl;
    }

    public final long getTimeBetweenEvictionRunsMillis() {
        return this.timeBetweenEvictionRunsMillis;
    }

    public final void setTimeBetweenEvictionRunsMillis(long l) {
        this.timeBetweenEvictionRunsMillis = l;
        this.startEvictor(l);
    }

    public final int getNumTestsPerEvictionRun() {
        return this.numTestsPerEvictionRun;
    }

    public final void setNumTestsPerEvictionRun(int n) {
        this.numTestsPerEvictionRun = n;
    }

    public final long getMinEvictableIdleTimeMillis() {
        return this.minEvictableIdleTimeMillis;
    }

    public final void setMinEvictableIdleTimeMillis(long l) {
        this.minEvictableIdleTimeMillis = l;
    }

    public final long getSoftMinEvictableIdleTimeMillis() {
        return this.softMinEvictableIdleTimeMillis;
    }

    public final void setSoftMinEvictableIdleTimeMillis(long l) {
        this.softMinEvictableIdleTimeMillis = l;
    }

    public final String getEvictionPolicyClassName() {
        return this.evictionPolicy.getClass().getName();
    }

    public void setEvictionPolicy(EvictionPolicy<T> evictionPolicy) {
        this.evictionPolicy = evictionPolicy;
    }

    public final void setEvictionPolicyClassName(String string, ClassLoader classLoader) {
        Class<EvictionPolicy> clazz = EvictionPolicy.class;
        ClassLoader classLoader2 = clazz.getClassLoader();
        try {
            try {
                this.setEvictionPolicy(string, classLoader);
            }
            catch (ClassCastException | ClassNotFoundException exception) {
                this.setEvictionPolicy(string, classLoader2);
            }
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException("Class " + string + " from class loaders [" + classLoader + ", " + classLoader2 + "] do not implement " + EVICTION_POLICY_TYPE_NAME);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            String string2 = "Unable to create " + EVICTION_POLICY_TYPE_NAME + " instance of type " + string;
            throw new IllegalArgumentException(string2, reflectiveOperationException);
        }
    }

    private void setEvictionPolicy(String string, ClassLoader classLoader) throws ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Class<?> clazz = Class.forName(string, true, classLoader);
        Object obj = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        this.evictionPolicy = (EvictionPolicy)obj;
    }

    public final void setEvictionPolicyClassName(String string) {
        this.setEvictionPolicyClassName(string, Thread.currentThread().getContextClassLoader());
    }

    public final long getEvictorShutdownTimeoutMillis() {
        return this.evictorShutdownTimeoutMillis;
    }

    public final void setEvictorShutdownTimeoutMillis(long l) {
        this.evictorShutdownTimeoutMillis = l;
    }

    public abstract void close();

    public final boolean isClosed() {
        return this.closed;
    }

    public abstract void evict() throws Exception;

    public EvictionPolicy<T> getEvictionPolicy() {
        return this.evictionPolicy;
    }

    final void assertOpen() throws IllegalStateException {
        if (this.isClosed()) {
            throw new IllegalStateException("Pool not open");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void startEvictor(long l) {
        Object object = this.evictionLock;
        synchronized (object) {
            if (this.evictor == null) {
                if (l > 0L) {
                    this.evictor = new Evictor();
                    EvictionTimer.schedule(this.evictor, l, l);
                }
            } else if (l > 0L) {
                Class<EvictionTimer> clazz = EvictionTimer.class;
                synchronized (EvictionTimer.class) {
                    EvictionTimer.cancel(this.evictor, this.evictorShutdownTimeoutMillis, TimeUnit.MILLISECONDS, true);
                    this.evictor = null;
                    this.evictionIterator = null;
                    this.evictor = new Evictor();
                    EvictionTimer.schedule(this.evictor, l, l);
                    // ** MonitorExit[var4_3] (shouldn't be in output)
                }
            } else {
                EvictionTimer.cancel(this.evictor, this.evictorShutdownTimeoutMillis, TimeUnit.MILLISECONDS, false);
            }
            {
            }
        }
    }

    void stopEvictor() {
        this.startEvictor(-1L);
    }

    abstract void ensureMinIdle() throws Exception;

    public final ObjectName getJmxName() {
        return this.objectName;
    }

    public final String getCreationStackTrace() {
        return this.creationStackTrace;
    }

    public final long getBorrowedCount() {
        return this.borrowedCount.get();
    }

    public final long getReturnedCount() {
        return this.returnedCount.get();
    }

    public final long getCreatedCount() {
        return this.createdCount.get();
    }

    public final long getDestroyedCount() {
        return this.destroyedCount.get();
    }

    public final long getDestroyedByEvictorCount() {
        return this.destroyedByEvictorCount.get();
    }

    public final long getDestroyedByBorrowValidationCount() {
        return this.destroyedByBorrowValidationCount.get();
    }

    public final long getMeanActiveTimeMillis() {
        return this.activeTimes.getMean();
    }

    public final long getMeanIdleTimeMillis() {
        return this.idleTimes.getMean();
    }

    public final long getMeanBorrowWaitTimeMillis() {
        return this.waitTimes.getMean();
    }

    public final long getMaxBorrowWaitTimeMillis() {
        return this.maxBorrowWaitTimeMillis.get();
    }

    public abstract int getNumIdle();

    public final SwallowedExceptionListener getSwallowedExceptionListener() {
        return this.swallowedExceptionListener;
    }

    public final void setSwallowedExceptionListener(SwallowedExceptionListener swallowedExceptionListener) {
        this.swallowedExceptionListener = swallowedExceptionListener;
    }

    final void swallowException(Exception exception) {
        SwallowedExceptionListener swallowedExceptionListener = this.getSwallowedExceptionListener();
        if (swallowedExceptionListener == null) {
            return;
        }
        try {
            swallowedExceptionListener.onSwallowException(exception);
        }
        catch (VirtualMachineError virtualMachineError) {
            throw virtualMachineError;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    final void updateStatsBorrow(PooledObject<T> pooledObject, long l) {
        long l2;
        this.borrowedCount.incrementAndGet();
        this.idleTimes.add(pooledObject.getIdleTimeMillis());
        this.waitTimes.add(l);
        while ((l2 = this.maxBorrowWaitTimeMillis.get()) < l && !this.maxBorrowWaitTimeMillis.compareAndSet(l2, l)) {
        }
    }

    final void updateStatsReturn(long l) {
        this.returnedCount.incrementAndGet();
        this.activeTimes.add(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void markReturningState(PooledObject<T> pooledObject) {
        PooledObject<T> pooledObject2 = pooledObject;
        synchronized (pooledObject2) {
            PooledObjectState pooledObjectState = pooledObject.getState();
            if (pooledObjectState != PooledObjectState.ALLOCATED) {
                throw new IllegalStateException("Object has already been returned to this pool or is invalid");
            }
            pooledObject.markReturning();
        }
    }

    final void jmxUnregister() {
        if (this.objectName != null) {
            try {
                ManagementFactory.getPlatformMBeanServer().unregisterMBean(this.objectName);
            }
            catch (InstanceNotFoundException | MBeanRegistrationException jMException) {
                this.swallowException(jMException);
            }
        }
    }

    private ObjectName jmxRegister(BaseObjectPoolConfig<T> baseObjectPoolConfig, String string, String string2) {
        ObjectName objectName = null;
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        int n = 1;
        boolean bl = false;
        String string3 = baseObjectPoolConfig.getJmxNameBase();
        if (string3 == null) {
            string3 = string;
        }
        while (!bl) {
            try {
                ObjectName objectName2 = n == 1 ? new ObjectName(string3 + string2) : new ObjectName(string3 + string2 + n);
                mBeanServer.registerMBean(this, objectName2);
                objectName = objectName2;
                bl = true;
            }
            catch (MalformedObjectNameException malformedObjectNameException) {
                if ("pool".equals(string2) && string.equals(string3)) {
                    bl = true;
                    continue;
                }
                string2 = "pool";
                string3 = string;
            }
            catch (InstanceAlreadyExistsException instanceAlreadyExistsException) {
                ++n;
            }
            catch (MBeanRegistrationException | NotCompliantMBeanException jMException) {
                bl = true;
            }
        }
        return objectName;
    }

    private String getStackTrace(Exception exception) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        exception.printStackTrace(printWriter);
        return ((Object)stringWriter).toString();
    }

    @Override
    protected void toStringAppendFields(StringBuilder stringBuilder) {
        stringBuilder.append("maxTotal=");
        stringBuilder.append(this.maxTotal);
        stringBuilder.append(", blockWhenExhausted=");
        stringBuilder.append(this.blockWhenExhausted);
        stringBuilder.append(", maxWaitMillis=");
        stringBuilder.append(this.maxWaitMillis);
        stringBuilder.append(", lifo=");
        stringBuilder.append(this.lifo);
        stringBuilder.append(", fairness=");
        stringBuilder.append(this.fairness);
        stringBuilder.append(", testOnCreate=");
        stringBuilder.append(this.testOnCreate);
        stringBuilder.append(", testOnBorrow=");
        stringBuilder.append(this.testOnBorrow);
        stringBuilder.append(", testOnReturn=");
        stringBuilder.append(this.testOnReturn);
        stringBuilder.append(", testWhileIdle=");
        stringBuilder.append(this.testWhileIdle);
        stringBuilder.append(", timeBetweenEvictionRunsMillis=");
        stringBuilder.append(this.timeBetweenEvictionRunsMillis);
        stringBuilder.append(", numTestsPerEvictionRun=");
        stringBuilder.append(this.numTestsPerEvictionRun);
        stringBuilder.append(", minEvictableIdleTimeMillis=");
        stringBuilder.append(this.minEvictableIdleTimeMillis);
        stringBuilder.append(", softMinEvictableIdleTimeMillis=");
        stringBuilder.append(this.softMinEvictableIdleTimeMillis);
        stringBuilder.append(", evictionPolicy=");
        stringBuilder.append(this.evictionPolicy);
        stringBuilder.append(", closeLock=");
        stringBuilder.append(this.closeLock);
        stringBuilder.append(", closed=");
        stringBuilder.append(this.closed);
        stringBuilder.append(", evictionLock=");
        stringBuilder.append(this.evictionLock);
        stringBuilder.append(", evictor=");
        stringBuilder.append(this.evictor);
        stringBuilder.append(", evictionIterator=");
        stringBuilder.append(this.evictionIterator);
        stringBuilder.append(", factoryClassLoader=");
        stringBuilder.append(this.factoryClassLoader);
        stringBuilder.append(", oname=");
        stringBuilder.append(this.objectName);
        stringBuilder.append(", creationStackTrace=");
        stringBuilder.append(this.creationStackTrace);
        stringBuilder.append(", borrowedCount=");
        stringBuilder.append(this.borrowedCount);
        stringBuilder.append(", returnedCount=");
        stringBuilder.append(this.returnedCount);
        stringBuilder.append(", createdCount=");
        stringBuilder.append(this.createdCount);
        stringBuilder.append(", destroyedCount=");
        stringBuilder.append(this.destroyedCount);
        stringBuilder.append(", destroyedByEvictorCount=");
        stringBuilder.append(this.destroyedByEvictorCount);
        stringBuilder.append(", destroyedByBorrowValidationCount=");
        stringBuilder.append(this.destroyedByBorrowValidationCount);
        stringBuilder.append(", activeTimes=");
        stringBuilder.append(this.activeTimes);
        stringBuilder.append(", idleTimes=");
        stringBuilder.append(this.idleTimes);
        stringBuilder.append(", waitTimes=");
        stringBuilder.append(this.waitTimes);
        stringBuilder.append(", maxBorrowWaitTimeMillis=");
        stringBuilder.append(this.maxBorrowWaitTimeMillis);
        stringBuilder.append(", swallowedExceptionListener=");
        stringBuilder.append(this.swallowedExceptionListener);
    }

    class Evictor
    implements Runnable {
        private ScheduledFuture<?> scheduledFuture;

        Evictor() {
        }

        @Override
        public void run() {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            try {
                if (BaseGenericObjectPool.this.factoryClassLoader != null) {
                    ClassLoader classLoader2 = (ClassLoader)BaseGenericObjectPool.this.factoryClassLoader.get();
                    if (classLoader2 == null) {
                        this.cancel();
                        return;
                    }
                    Thread.currentThread().setContextClassLoader(classLoader2);
                }
                try {
                    BaseGenericObjectPool.this.evict();
                }
                catch (Exception exception) {
                    BaseGenericObjectPool.this.swallowException(exception);
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    outOfMemoryError.printStackTrace(System.err);
                }
                try {
                    BaseGenericObjectPool.this.ensureMinIdle();
                }
                catch (Exception exception) {
                    BaseGenericObjectPool.this.swallowException(exception);
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(classLoader);
            }
        }

        void setScheduledFuture(ScheduledFuture<?> scheduledFuture) {
            this.scheduledFuture = scheduledFuture;
        }

        void cancel() {
            this.scheduledFuture.cancel(false);
        }
    }

    class EvictionIterator
    implements Iterator<PooledObject<T>> {
        private final Deque<PooledObject<T>> idleObjects;
        private final Iterator<PooledObject<T>> idleObjectIterator;

        EvictionIterator(Deque<PooledObject<T>> deque) {
            this.idleObjects = deque;
            this.idleObjectIterator = BaseGenericObjectPool.this.getLifo() ? deque.descendingIterator() : deque.iterator();
        }

        public Deque<PooledObject<T>> getIdleObjects() {
            return this.idleObjects;
        }

        @Override
        public boolean hasNext() {
            return this.idleObjectIterator.hasNext();
        }

        @Override
        public PooledObject<T> next() {
            return this.idleObjectIterator.next();
        }

        @Override
        public void remove() {
            this.idleObjectIterator.remove();
        }
    }

    private class StatsStore {
        private final AtomicLong[] values;
        private final int size;
        private int index;

        public StatsStore(int n) {
            this.size = n;
            this.values = new AtomicLong[n];
            for (int i = 0; i < n; ++i) {
                this.values[i] = new AtomicLong(-1L);
            }
        }

        public synchronized void add(long l) {
            this.values[this.index].set(l);
            ++this.index;
            if (this.index == this.size) {
                this.index = 0;
            }
        }

        public long getMean() {
            double d = 0.0;
            int n = 0;
            for (int i = 0; i < this.size; ++i) {
                long l = this.values[i].get();
                if (l == -1L) continue;
                d = d * ((double)(++n - 1) / (double)n) + (double)l / (double)n;
            }
            return (long)d;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("StatsStore [values=");
            stringBuilder.append(Arrays.toString(this.values));
            stringBuilder.append(", size=");
            stringBuilder.append(this.size);
            stringBuilder.append(", index=");
            stringBuilder.append(this.index);
            stringBuilder.append("]");
            return stringBuilder.toString();
        }
    }

    static class IdentityWrapper<T> {
        private final T instance;

        public IdentityWrapper(T t) {
            this.instance = t;
        }

        public int hashCode() {
            return System.identityHashCode(this.instance);
        }

        public boolean equals(Object object) {
            return object instanceof IdentityWrapper && ((IdentityWrapper)object).instance == this.instance;
        }

        public T getObject() {
            return this.instance;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("IdentityWrapper [instance=");
            stringBuilder.append(this.instance);
            stringBuilder.append("]");
            return stringBuilder.toString();
        }
    }
}

