/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.InvalidPathException;
import org.apache.tomcat.util.file.ConfigurationSource;
import org.apache.tomcat.util.res.StringManager;

public class CatalinaBaseConfigurationSource
implements ConfigurationSource {
    protected static final StringManager sm = StringManager.getManager((String)"org.apache.catalina.startup");
    private final String serverXmlPath;
    private final File catalinaBaseFile;
    private final URI catalinaBaseUri;

    public CatalinaBaseConfigurationSource(File file, String string) {
        this.catalinaBaseFile = file;
        this.catalinaBaseUri = file.toURI();
        this.serverXmlPath = string;
    }

    public ConfigurationSource.Resource getServerXml() throws IOException {
        InputStream inputStream;
        IOException iOException = null;
        ConfigurationSource.Resource resource = null;
        try {
            resource = this.serverXmlPath == null || this.serverXmlPath.equals("conf/server.xml") ? super.getServerXml() : this.getResource(this.serverXmlPath);
        }
        catch (IOException iOException2) {
            iOException = iOException2;
        }
        if (resource == null && (inputStream = this.getClass().getClassLoader().getResourceAsStream("server-embed.xml")) != null) {
            try {
                resource = new ConfigurationSource.Resource(inputStream, this.getClass().getClassLoader().getResource("server-embed.xml").toURI());
            }
            catch (URISyntaxException uRISyntaxException) {
                inputStream.close();
            }
        }
        if (resource == null && iOException != null) {
            throw iOException;
        }
        return resource;
    }

    public ConfigurationSource.Resource getResource(String string) throws IOException {
        File file = new File(string);
        if (!file.isAbsolute()) {
            file = new File(this.catalinaBaseFile, string);
        }
        if (file.isFile()) {
            FileInputStream fileInputStream = new FileInputStream(file);
            return new ConfigurationSource.Resource((InputStream)fileInputStream, file.toURI());
        }
        InputStream inputStream = null;
        try {
            inputStream = this.getClass().getClassLoader().getResourceAsStream(string);
            if (inputStream != null) {
                return new ConfigurationSource.Resource(inputStream, this.getClass().getClassLoader().getResource(string).toURI());
            }
        }
        catch (InvalidPathException invalidPathException) {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            inputStream.close();
            throw new IOException(sm.getString("catalinaConfigurationSource.cannotObtainURL", new Object[]{string}), uRISyntaxException);
        }
        URI uRI = null;
        try {
            uRI = this.getURI(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IOException(sm.getString("catalinaConfigurationSource.cannotObtainURL", new Object[]{string}), illegalArgumentException);
        }
        try {
            URL uRL = uRI.toURL();
            return new ConfigurationSource.Resource(uRL.openConnection().getInputStream(), uRI);
        }
        catch (MalformedURLException malformedURLException) {
            throw new IOException(sm.getString("catalinaConfigurationSource.cannotObtainURL", new Object[]{string}), malformedURLException);
        }
    }

    public URI getURI(String string) {
        Serializable serializable;
        File file = new File(string);
        if (!file.isAbsolute()) {
            file = new File(this.catalinaBaseFile, string);
        }
        if (file.isFile()) {
            return file.toURI();
        }
        try {
            serializable = this.getClass().getClassLoader().getResource(string);
            if (serializable != null) {
                return ((URL)serializable).toURI();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        serializable = this.catalinaBaseUri != null ? this.catalinaBaseUri.resolve(string) : URI.create(string);
        return serializable;
    }
}

