/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.menu;

import java.awt.event.MouseMotionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.action.DisplayTileTextAction;
import net.sf.freecol.client.gui.menu.FreeColMenuBar;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.common.io.FreeColDirectories;
import net.sf.freecol.common.option.FileOption;
import net.sf.freecol.common.option.OptionGroup;

public class MapEditorMenuBar
extends FreeColMenuBar {
    private static final Logger logger = Logger.getLogger(MapEditorMenuBar.class.getName());

    public MapEditorMenuBar(FreeColClient freeColClient, MouseMotionListener listener) {
        super(freeColClient);
        this.addMouseMotionListener(listener);
        this.reset();
    }

    @Override
    public final void reset() {
        this.removeAll();
        this.buildGameMenu();
        this.buildViewMenu();
        this.buildToolsMenu();
        this.buildColopediaMenu();
        this.update();
    }

    private void buildGameMenu() {
        JMenu menu = Utility.localizedMenu("menuBar.game");
        menu.setOpaque(false);
        menu.setMnemonic(71);
        menu.add(this.getMenuItem("newAction"));
        menu.add(this.getMenuItem("newEmptyMapAction"));
        menu.addSeparator();
        menu.add(this.getMenuItem("openAction"));
        menu.add(this.getMenuItem("saveAction"));
        JMenuItem playItem = Utility.localizedMenuItem("startGame");
        playItem.addActionListener(ae -> {
            File startFile = FreeColDirectories.getStartMapFile();
            this.freeColClient.getMapEditorController().saveGame(startFile);
            OptionGroup options = this.freeColClient.getGame().getMapGeneratorOptions();
            FileOption fileOption = (FileOption)options.getOption("model.option.importFile");
            fileOption.setValue(startFile);
            File mapOptionsFile = FreeColDirectories.getOptionsFile("map_generator_options.xml");
            try {
                options.save(mapOptionsFile);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
            this.freeColClient.newGame(true);
        });
        menu.add(playItem);
        menu.addSeparator();
        menu.add(this.getMenuItem("preferencesAction"));
        menu.addSeparator();
        menu.add(this.getMenuItem("showMainAction"));
        menu.add(this.getMenuItem("quitAction"));
        this.add(menu);
    }

    private void buildViewMenu() {
        JMenu menu = Utility.localizedMenu("menuBar.view");
        menu.setOpaque(false);
        menu.setMnemonic(86);
        menu.add(this.getCheckBoxMenuItem("mapControlsAction"));
        menu.add(this.getCheckBoxMenuItem("displayGridAction"));
        menu.add(this.getCheckBoxMenuItem("changeWindowedModeAction"));
        menu.addSeparator();
        ButtonGroup tileTextGroup = new ButtonGroup();
        for (DisplayTileTextAction.DisplayText type : DisplayTileTextAction.DisplayText.values()) {
            menu.add(this.getRadioButtonMenuItem("displayTileTextAction." + type.getKey(), tileTextGroup));
        }
        menu.addSeparator();
        menu.add(this.getMenuItem("zoomInAction"));
        menu.add(this.getMenuItem("zoomOutAction"));
        this.add(menu);
    }

    private void buildToolsMenu() {
        JMenu menu = Utility.localizedMenu("menuBar.tools");
        menu.setOpaque(false);
        menu.setMnemonic(84);
        menu.add(this.getMenuItem("scaleMapAction"));
        menu.add(this.getMenuItem("determineHighSeasAction"));
        this.add(menu);
    }
}

