/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.bsh;

import org.gjt.sp.jedit.bsh.CallStack;
import org.gjt.sp.jedit.bsh.NameSpace;
import org.gjt.sp.jedit.bsh.SimpleNode;

public class EvalError
extends Exception {
    SimpleNode node;
    String message;
    CallStack callstack;

    public EvalError(String string, SimpleNode simpleNode, CallStack callStack) {
        this.setMessage(string);
        this.node = simpleNode;
        if (callStack != null) {
            this.callstack = callStack.copy();
        }
    }

    @Override
    public String toString() {
        Object object = this.node != null ? " : at Line: " + this.node.getLineNumber() + " :\n in file: " + this.node.getSourceFile() + "\n : " + this.node.getText() : ": <at unknown location>";
        if (this.callstack != null) {
            object = (String)object + "\n" + this.getScriptStackTrace();
        }
        return this.getMessage() + (String)object;
    }

    public void reThrow(String string) throws EvalError {
        this.prependMessage(string);
        throw this;
    }

    SimpleNode getNode() {
        return this.node;
    }

    void setNode(SimpleNode simpleNode) {
        this.node = simpleNode;
    }

    public String getErrorText() {
        if (this.node != null) {
            return this.node.getText();
        }
        return "<unknown error>";
    }

    public int getErrorLineNumber() {
        if (this.node != null) {
            return this.node.getLineNumber();
        }
        return -1;
    }

    public String getErrorSourceFile() {
        if (this.node != null) {
            return this.node.getSourceFile();
        }
        return "<unknown file>";
    }

    public String getScriptStackTrace() {
        if (this.callstack == null) {
            return "<Unknown>";
        }
        Object object = "";
        CallStack callStack = this.callstack.copy();
        while (callStack.depth() > 0) {
            NameSpace nameSpace = callStack.pop();
            SimpleNode simpleNode = nameSpace.getNode();
            if (!nameSpace.isMethod) continue;
            object = (String)object + "\nCalled from method: " + nameSpace.getName();
            if (simpleNode == null) continue;
            object = (String)object + " : at Line: " + simpleNode.getLineNumber() + " : in file: " + simpleNode.getSourceFile() + " : " + simpleNode.getText();
        }
        return object;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String string) {
        this.message = string;
    }

    protected void prependMessage(String string) {
        if (string == null) {
            return;
        }
        this.message = this.message == null ? string : string + " : " + this.message;
    }
}

