/*
 * Decompiled with CFR 0.152.
 */
package jspecview.export;

import javajs.util.DF;
import javajs.util.SB;
import jspecview.common.Coordinate;
import jspecview.export.Exporter;
import org.jmol.util.Logger;

class JDXCompressor {
    static final String spaces = "                    ";

    JDXCompressor() {
    }

    static String compressDIF(Coordinate[] xyCoords, int startIndex, int endIndex, int step, double xFactor, double yFactor, boolean isDIFDUP) {
        SB yStr = new SB();
        SB buffer = new SB();
        for (int i = startIndex; i != endIndex; i += step) {
            buffer.append(JDXCompressor.fixIntNoExponent(xyCoords[i].getXVal() / xFactor));
            yStr.setLength(0);
            if (Logger.debugging) {
                Logger.info("" + i + '\t' + xyCoords[i].getXVal() + '\t' + xyCoords[i].getYVal());
            }
            long y1 = Math.round(xyCoords[i].getYVal() / yFactor);
            yStr.append(JDXCompressor.makeSQZ(y1));
            String lastDif = "";
            int nDif = 0;
            if ((i += step) == endIndex) {
                i -= step;
            } else {
                while (i + step != endIndex && yStr.length() < 50) {
                    long y2 = Math.round(xyCoords[i].getYVal() / yFactor);
                    String temp = JDXCompressor.makeDIF(y2 - y1);
                    if (isDIFDUP && temp.equals(lastDif)) {
                        ++nDif;
                    } else {
                        lastDif = temp;
                        if (nDif > 0) {
                            yStr.append(JDXCompressor.makeDUP(nDif + 1));
                            nDif = 0;
                        }
                        yStr.append(temp);
                    }
                    if (Logger.debugging) {
                        Logger.info("" + i + '\t' + xyCoords[i].getXVal() + '\t' + xyCoords[i].getYVal() + '\t' + y2 + '\t' + nDif + '\t' + yStr);
                    }
                    y1 = y2;
                    i += step;
                }
                if (nDif > 0) {
                    yStr.append(JDXCompressor.makeDUP(nDif + 1));
                }
                yStr.append(JDXCompressor.makeSQZ(xyCoords[i], yFactor));
                if (Logger.debugging) {
                    Logger.info("" + i + '\t' + xyCoords[i].getXVal() + '\t' + xyCoords[i].getYVal() + '\t' + nDif + '\t' + yStr);
                }
            }
            buffer.append(yStr.toString()).append(Exporter.newLine);
        }
        buffer.append(JDXCompressor.fixIntNoExponent(xyCoords[endIndex].getXVal() / xFactor)).append(JDXCompressor.makeSQZ(xyCoords[endIndex], yFactor));
        buffer.append("  $$checkpoint").append(Exporter.newLine);
        return buffer.toString();
    }

    static String compressFIX(Coordinate[] xyCoords, int startIndex, int endIndex, int step, double xFactor, double yFactor) {
        endIndex += step;
        SB buffer = new SB();
        int i = startIndex;
        while (i != endIndex) {
            JDXCompressor.leftJustify(buffer, "              ", JDXCompressor.fixIntNoExponent(xyCoords[i].getXVal() / xFactor));
            for (int j = 0; j < 6 && i != endIndex; i += step, ++j) {
                JDXCompressor.rightJustify(buffer, "          ", "" + Math.round(xyCoords[i].getYVal() / yFactor));
                buffer.append(" ");
            }
            buffer.append(Exporter.newLine);
        }
        return buffer.toString();
    }

    public static void leftJustify(SB s, String s1, String s2) {
        s.append(s2);
        int n = s1.length() - s2.length();
        if (n > 0) {
            s.append(s1.substring(0, n));
        }
    }

    public static void rightJustify(SB s, String s1, String s2) {
        int n = s1.length() - s2.length();
        if (n > 0) {
            s.append(s1.substring(0, n));
        }
        s.append(s2);
    }

    static String compressSQZ(Coordinate[] xyCoords, int startIndex, int endIndex, int step, double xFactor, double yFactor) {
        SB yStr = new SB();
        endIndex += step;
        SB buffer = new SB();
        int i = startIndex;
        while (i == startIndex || i != endIndex) {
            buffer.append(JDXCompressor.fixIntNoExponent(xyCoords[i].getXVal() / xFactor));
            yStr.setLength(0);
            yStr.append(JDXCompressor.makeSQZ(xyCoords[i], yFactor));
            i += step;
            while (yStr.length() < 60 && i != endIndex) {
                yStr.append(JDXCompressor.makeSQZ(xyCoords[i], yFactor));
                i += step;
            }
            buffer.append(yStr.toString()).append(Exporter.newLine);
        }
        return buffer.toString();
    }

    static String compressPAC(Coordinate[] xyCoords, int startIndex, int endIndex, int step, double xFactor, double yFactor) {
        SB buffer = new SB();
        endIndex += step;
        int i = startIndex;
        while (i != endIndex) {
            buffer.append(JDXCompressor.fixIntNoExponent(xyCoords[i].getXVal() / xFactor)).append(JDXCompressor.fixPacY(xyCoords[i].getYVal() / yFactor));
            i += step;
            for (int j = 0; j < 4 && i != endIndex; i += step, ++j) {
                buffer.append(JDXCompressor.fixPacY(xyCoords[i].getYVal() / yFactor));
            }
            buffer.append(Exporter.newLine);
        }
        return buffer.toString();
    }

    private static String fixPacY(double y) {
        return (y < 0.0 ? "" : " ") + JDXCompressor.fixIntNoExponent(y);
    }

    private static String makeSQZ(Coordinate pt, double yFactor) {
        return JDXCompressor.makeSQZ(Math.round(pt.getYVal() / yFactor));
    }

    private static String makeSQZ(long y) {
        return JDXCompressor.compress(y, "@ABCDEFGHI", "abcdefghi");
    }

    private static String makeDIF(long dy) {
        return JDXCompressor.compress(dy, "%JKLMNOPQR", "jklmnopqr");
    }

    private static String makeDUP(long y) {
        return JDXCompressor.compress(y, "0STUVWXYZs", "");
    }

    private static String compress(long y, String strPos, String strNeg) {
        boolean negative = false;
        String yStr = String.valueOf(y);
        char ch = yStr.charAt(0);
        if (ch == '-') {
            negative = true;
            yStr = yStr.substring(1);
            ch = yStr.charAt(0);
        }
        char[] yStrArray = yStr.toCharArray();
        yStrArray[0] = negative ? strNeg.charAt(ch - 49) : strPos.charAt(ch - 48);
        return new String(yStrArray);
    }

    static String getXYList(Coordinate[] xyCoords, int startIndex, int endIndex, int step) {
        endIndex += step;
        SB buffer = new SB();
        for (int i = startIndex; i != endIndex; i += step) {
            Coordinate point = xyCoords[i];
            buffer.append(JDXCompressor.fixIntNoExponent(point.getXVal())).append(", ").append(JDXCompressor.fixIntNoExponent(point.getYVal())).append(Exporter.newLine);
        }
        return buffer.toString();
    }

    private static String fixIntNoExponent(double x) {
        return x == Math.floor(x) ? String.valueOf((int)x) : DF.formatDecimalTrimmed(x, 10);
    }
}

