/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImagingOpException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import org.openstreetmap.josm.data.ProjectionBounds;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.data.preferences.IntegerProperty;
import org.openstreetmap.josm.data.projection.ProjectionRegistry;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.MenuScroller;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.TMSLayer;
import org.openstreetmap.josm.gui.layer.WMSLayer;
import org.openstreetmap.josm.gui.layer.WMTSLayer;
import org.openstreetmap.josm.gui.layer.imagery.ImageryFilterSettings;
import org.openstreetmap.josm.gui.widgets.UrlLabel;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProcessor;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;

public abstract class ImageryLayer
extends Layer {
    public static final IntegerProperty PROP_SHARPEN_LEVEL = new IntegerProperty("imagery.sharpen_level", 0);
    private final List<ImageProcessor> imageProcessors = new ArrayList<ImageProcessor>();
    protected final ImageryInfo info;
    protected Icon icon;
    private final ImageryFilterSettings filterSettings = new ImageryFilterSettings();

    protected ImageryLayer(ImageryInfo info) {
        super(info.getName());
        this.info = info;
        if (info.getIcon() != null) {
            this.icon = new ImageProvider(info.getIcon()).setOptional(true).setMaxSize(ImageProvider.ImageSizes.LAYER).get();
        }
        if (this.icon == null) {
            this.icon = ImageProvider.get("imagery_menu", ImageProvider.ImageSizes.LAYER);
        }
        for (ImageProcessor processor : this.filterSettings.getProcessors()) {
            this.addImageProcessor(processor);
        }
        this.filterSettings.setSharpenLevel(1.0f + (float)PROP_SHARPEN_LEVEL.get().intValue() / 2.0f);
    }

    public double getPPD() {
        if (!MainApplication.isDisplayingMapView()) {
            return ProjectionRegistry.getProjection().getDefaultZoomInPPD();
        }
        MapView mapView = MainApplication.getMap().mapView;
        ProjectionBounds bounds = mapView.getProjectionBounds();
        return (double)mapView.getWidth() / (bounds.maxEast - bounds.minEast);
    }

    public ImageryInfo getInfo() {
        return this.info;
    }

    @Override
    public Icon getIcon() {
        return this.icon;
    }

    @Override
    public boolean isMergable(Layer other) {
        return false;
    }

    @Override
    public void mergeFrom(Layer from) {
    }

    @Override
    public Object getInfoComponent() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel(this.getToolTipText()), GBC.eol());
        if (this.info != null) {
            ArrayList<List<String>> content = new ArrayList<List<String>>();
            content.add(Arrays.asList(I18n.tr("Name", new Object[0]), this.info.getName()));
            content.add(Arrays.asList(I18n.tr("Type", new Object[0]), this.info.getImageryType().getTypeString().toUpperCase(Locale.ENGLISH)));
            content.add(Arrays.asList(I18n.tr("URL", new Object[0]), this.info.getUrl()));
            content.add(Arrays.asList(I18n.tr("Id", new Object[0]), this.info.getId() == null ? "-" : this.info.getId()));
            if (this.info.getMinZoom() != 0) {
                content.add(Arrays.asList(I18n.tr("Min. zoom", new Object[0]), Integer.toString(this.info.getMinZoom())));
            }
            if (this.info.getMaxZoom() != 0) {
                content.add(Arrays.asList(I18n.tr("Max. zoom", new Object[0]), Integer.toString(this.info.getMaxZoom())));
            }
            if (this.info.getDescription() != null) {
                content.add(Arrays.asList(I18n.tr("Description", new Object[0]), this.info.getDescription()));
            }
            for (List list : content) {
                panel.add((Component)new JLabel((String)list.get(0) + ':'), GBC.std());
                panel.add(GBC.glue(5, 0), GBC.std());
                panel.add((Component)this.createTextField((String)list.get(1)), GBC.eol().fill(2));
            }
        }
        return panel;
    }

    protected JComponent createTextField(String text) {
        if (text != null && text.matches("https?://.*")) {
            return new UrlLabel(text);
        }
        JTextField ret = new JTextField(text);
        ret.setEditable(false);
        ret.setBorder(BorderFactory.createEmptyBorder());
        return ret;
    }

    public static ImageryLayer create(ImageryInfo info) {
        switch (info.getImageryType()) {
            case WMS: 
            case WMS_ENDPOINT: {
                return new WMSLayer(info);
            }
            case WMTS: {
                return new WMTSLayer(info);
            }
            case TMS: 
            case BING: 
            case SCANEX: {
                return new TMSLayer(info);
            }
        }
        throw new AssertionError((Object)I18n.tr("Unsupported imagery type: {0}", info.getImageryType()));
    }

    public JMenuItem getOffsetMenuItem() {
        JMenu subMenu = new JMenu(I18n.trc("layer", "Offset"));
        subMenu.setIcon(ImageProvider.get("mapmode", "adjustimg"));
        return (JMenuItem)this.getOffsetMenuItem(subMenu);
    }

    public JComponent getOffsetMenuItem(JComponent subMenu) {
        JMenuItem adjustMenuItem = new JMenuItem(this.getAdjustAction());
        List<OffsetMenuEntry> usableBookmarks = this.getOffsetMenuEntries();
        if (usableBookmarks.isEmpty()) {
            return adjustMenuItem;
        }
        subMenu.add(adjustMenuItem);
        subMenu.add(new JSeparator());
        int menuItemHeight = 0;
        for (OffsetMenuEntry b : usableBookmarks) {
            JCheckBoxMenuItem item = new JCheckBoxMenuItem(new ApplyOffsetAction(b));
            item.setSelected(b.isActive());
            subMenu.add(item);
            menuItemHeight = item.getPreferredSize().height;
        }
        if (menuItemHeight > 0) {
            if (subMenu instanceof JMenu) {
                MenuScroller.setScrollerFor((JMenu)subMenu);
            } else if (subMenu instanceof JPopupMenu) {
                MenuScroller.setScrollerFor((JPopupMenu)subMenu);
            }
        }
        return subMenu;
    }

    protected abstract Action getAdjustAction();

    protected abstract List<OffsetMenuEntry> getOffsetMenuEntries();

    public ImageryFilterSettings getFilterSettings() {
        return this.filterSettings;
    }

    public boolean addImageProcessor(ImageProcessor processor) {
        return processor != null && this.imageProcessors.add(processor);
    }

    public boolean removeImageProcessor(ImageProcessor processor) {
        return this.imageProcessors.remove(processor);
    }

    public static ImageProcessor createImageProcessor(BufferedImageOp op, boolean inPlace) {
        return image -> op.filter(image, inPlace ? image : null);
    }

    public List<ImageProcessor> getImageProcessors() {
        return this.imageProcessors;
    }

    public BufferedImage applyImageProcessors(BufferedImage img) {
        for (ImageProcessor processor : this.imageProcessors) {
            try {
                img = processor.process(img);
            }
            catch (ImagingOpException e) {
                Logging.error(e);
            }
        }
        return img;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " [info=" + this.info + ']';
    }

    @Override
    public String getChangesetSourceTag() {
        return this.getInfo().getSourceName();
    }

    public static interface OffsetMenuEntry {
        public String getLabel();

        public boolean isActive();

        public void actionPerformed();
    }

    public class OffsetAction
    extends AbstractAction
    implements Layer.LayerAction {
        @Override
        public void actionPerformed(ActionEvent e) {
        }

        @Override
        public Component createMenuComponent() {
            return ImageryLayer.this.getOffsetMenuItem();
        }

        @Override
        public boolean supportLayers(List<Layer> layers) {
            return false;
        }
    }

    private static class ApplyOffsetAction
    extends AbstractAction {
        private final transient OffsetMenuEntry menuEntry;

        ApplyOffsetAction(OffsetMenuEntry menuEntry) {
            super(menuEntry.getLabel());
            this.menuEntry = menuEntry;
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            this.menuEntry.actionPerformed();
            MainApplication.getMenu().imageryMenu.refreshOffsetMenu();
        }
    }
}

