/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.engine;

import com.eclipsesource.v8.V8;
import com.eclipsesource.v8.V8Array;
import com.eclipsesource.v8.V8Object;
import com.eclipsesource.v8.utils.V8ObjectUtils;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.engine.ScriptEngine;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J;\u0010\t\u001a\u0002H\n\"\u0004\b\u0000\u0010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00032\u0016\u0010\u000e\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\f0\u000f\"\u0004\u0018\u00010\fH\u0016\u00a2\u0006\u0002\u0010\u0010J\u001b\u0010\u0011\u001a\u0002H\n\"\u0004\b\u0000\u0010\n2\u0006\u0010\u0012\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\u0013J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00030\bH\u0002J\u0010\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0003H\u0016J\b\u0010\u0019\u001a\u00020\u0015H\u0016J\u001b\u0010\u001a\u001a\u00020\u0015\"\u0004\b\u0000\u0010\n2\u0006\u0010\u001b\u001a\u0002H\nH\u0016\u00a2\u0006\u0002\u0010\u001cJ\b\u0010\u001d\u001a\u00020\u0015H\u0016J\b\u0010\u001e\u001a\u00020\u0015H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/js/engine/ScriptEngineV8;", "Lorg/jetbrains/kotlin/js/engine/ScriptEngine;", "LIBRARY_PATH_BASE", "", "(Ljava/lang/String;)V", "myRuntime", "Lcom/eclipsesource/v8/V8;", "savedState", "", "callMethod", "T", "obj", "", "name", "args", "", "(Ljava/lang/Object;Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/Object;", "eval", "script", "(Ljava/lang/String;)Ljava/lang/Object;", "evalVoid", "", "getGlobalPropertyNames", "loadFile", "path", "release", "releaseObject", "t", "(Ljava/lang/Object;)V", "restoreState", "saveState", "js.engines"})
public final class ScriptEngineV8
implements ScriptEngine {
    private List<String> savedState;
    private final V8 myRuntime;

    @Override
    public <T> void releaseObject(T t) {
        block1: {
            T t2 = t;
            if (!(t2 instanceof V8Object)) {
                t2 = null;
            }
            V8Object v8Object = (V8Object)t2;
            if (v8Object == null) break block1;
            v8Object.release();
        }
    }

    @Override
    public void restoreState() {
        StringBuilder scriptBuilder = new StringBuilder();
        List<String> globalState = this.getGlobalPropertyNames();
        List<String> list = this.savedState;
        Intrinsics.checkNotNull(list);
        List<String> originalState = list;
        for (String key : globalState) {
            if (originalState.contains(key)) continue;
            scriptBuilder.append("this['" + key + "'] = void 0;\n");
        }
        String string = scriptBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"scriptBuilder.toString()");
        this.evalVoid(string);
    }

    private final List<String> getGlobalPropertyNames() {
        V8Array v8Array = (V8Array)this.eval("Object.getOwnPropertyNames(this)");
        List list = V8ObjectUtils.toList((V8Array)v8Array);
        if (list == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.List<kotlin.String>");
        }
        List javaArray = list;
        v8Array.release();
        return javaArray;
    }

    @Override
    public void saveState() {
        if (this.savedState == null) {
            this.savedState = this.getGlobalPropertyNames();
        }
    }

    @Override
    public <T> T eval(@NotNull String script) {
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        return (T)this.myRuntime.executeScript(script);
    }

    @Override
    public void evalVoid(@NotNull String script) {
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        this.myRuntime.executeVoidScript(script);
    }

    @Override
    public <T> T callMethod(@NotNull Object obj, @NotNull String name, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        if (!(obj instanceof V8Object)) {
            throw (Throwable)new Exception("InteropV8 can deal only with V8Object");
        }
        V8Array runtimeArray = new V8Array(this.myRuntime);
        Object result = ((V8Object)obj).executeFunction(name, runtimeArray);
        runtimeArray.release();
        return (T)result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadFile(@NotNull String path) {
        String string;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Object object = new File(path);
        Charset charset = Charsets.UTF_8;
        int n = 8192;
        boolean bl = false;
        Object object2 = object;
        boolean bl2 = false;
        Object object3 = object2;
        boolean bl3 = false;
        object3 = new FileInputStream((File)object3);
        bl3 = false;
        object2 = new InputStreamReader((InputStream)object3, charset);
        bl2 = false;
        object = object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n);
        V8 v8 = this.myRuntime;
        boolean bl4 = false;
        n = 0;
        Throwable throwable = null;
        try {
            BufferedReader it = (BufferedReader)object;
            boolean bl5 = false;
            string = TextStreamsKt.readText((Reader)it);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        String string2 = string;
        v8.executeVoidScript(string2, path, 0);
    }

    @Override
    public void release() {
        this.myRuntime.release();
    }

    public ScriptEngineV8(@NotNull String LIBRARY_PATH_BASE) {
        Intrinsics.checkNotNullParameter((Object)LIBRARY_PATH_BASE, (String)"LIBRARY_PATH_BASE");
        V8 v8 = V8.createV8Runtime((String)"global", (String)LIBRARY_PATH_BASE);
        Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"V8.createV8Runtime(\"global\", LIBRARY_PATH_BASE)");
        this.myRuntime = v8;
    }
}

