/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import java.net.URL;
import java.net.URLClassLoader;
import org.scilab.forge.jlatexmath.AlphabetRegistration;
import org.scilab.forge.jlatexmath.AlphabetRegistrationException;
import org.scilab.forge.jlatexmath.DefaultTeXFont;

public class URLAlphabetRegistration
implements AlphabetRegistration {
    private URL url;
    private String language;
    private AlphabetRegistration pack = null;
    private Character.UnicodeBlock[] blocks;

    private URLAlphabetRegistration(URL url, String language, Character.UnicodeBlock[] blocks) {
        this.url = url;
        this.language = language;
        this.blocks = blocks;
    }

    public static void register(URL url, String language, Character.UnicodeBlock[] blocks) {
        DefaultTeXFont.registerAlphabet(new URLAlphabetRegistration(url, language, blocks));
    }

    public Character.UnicodeBlock[] getUnicodeBlock() {
        return this.blocks;
    }

    public Object getPackage() throws AlphabetRegistrationException {
        URL[] urls = new URL[]{this.url};
        this.language = this.language.toLowerCase();
        String name = "org.scilab.forge.jlatexmath." + this.language + "." + Character.toString(Character.toUpperCase(this.language.charAt(0))) + this.language.substring(1, this.language.length()) + "Registration";
        try {
            URLClassLoader loader = new URLClassLoader(urls);
            this.pack = (AlphabetRegistration)Class.forName(name, true, loader).newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new AlphabetRegistrationException("Class at " + this.url + " cannot be got.");
        }
        catch (Exception e) {
            throw new AlphabetRegistrationException("Problem in loading the class at " + this.url + " :\n" + e.getMessage());
        }
        return this.pack;
    }

    public String getTeXFontFileName() {
        return this.pack.getTeXFontFileName();
    }
}

