/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.vocab;

import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.HasIRI;
import org.semanticweb.owlapi.model.HasPrefixedName;
import org.semanticweb.owlapi.model.HasShortForm;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.vocab.Namespaces;

public enum XSDVocabulary implements HasShortForm,
HasIRI,
HasPrefixedName
{
    ANY_TYPE("anyType"),
    ANY_SIMPLE_TYPE("anySimpleType"),
    STRING("string"),
    INTEGER("integer"),
    LONG("long"),
    INT("int"),
    SHORT("short"),
    BYTE("byte"),
    DECIMAL("decimal"),
    FLOAT("float"),
    BOOLEAN("boolean"),
    DOUBLE("double"),
    NON_POSITIVE_INTEGER("nonPositiveInteger"),
    NEGATIVE_INTEGER("negativeInteger"),
    NON_NEGATIVE_INTEGER("nonNegativeInteger"),
    UNSIGNED_LONG("unsignedLong"),
    UNSIGNED_INT("unsignedInt"),
    POSITIVE_INTEGER("positiveInteger"),
    BASE_64_BINARY("base64Binary"),
    NORMALIZED_STRING("normalizedString"),
    HEX_BINARY("hexBinary"),
    ANY_URI("anyURI"),
    Q_NAME("QName"),
    NOTATION("NOTATION"),
    TOKEN("token"),
    LANGUAGE("language"),
    NAME("Name"),
    NCNAME("NCName"),
    NMTOKEN("NMTOKEN"),
    ID("ID"),
    IDREF("IDREF"),
    IDREFS("IDREFS"),
    ENTITY("ENTITY"),
    ENTITIES("ENTITIES"),
    DURATION("duration"),
    DATE_TIME("dateTime"),
    DATE_TIME_STAMP("dateTimeStamp"),
    TIME("time"),
    DATE("date"),
    G_YEAR_MONTH("gYearMonth"),
    G_YEAR("gYear"),
    G_MONTH_DAY("gMonthYear"),
    G_DAY("gDay"),
    G_MONTH("gMonth"),
    UNSIGNED_SHORT("unsignedShort"),
    UNSIGNED_BYTE("unsignedByte");

    @Nonnull
    private final String shortName;
    @Nonnull
    private final IRI iri;
    @Nonnull
    private final String prefixedName;

    private XSDVocabulary(String name) {
        this.shortName = name;
        this.prefixedName = Namespaces.XSD.getPrefixName() + ':' + name;
        this.iri = IRI.create(Namespaces.XSD.toString(), name);
    }

    @Override
    public String getShortForm() {
        return this.shortName;
    }

    @Override
    public IRI getIRI() {
        return this.iri;
    }

    public String toString() {
        return this.iri.toString();
    }

    public static XSDVocabulary parseShortName(@Nonnull String s) {
        OWLAPIPreconditions.checkNotNull(s, "the input string cannot be null");
        if (s.startsWith("xsd:")) {
            String name = s.substring(4);
            for (XSDVocabulary v : XSDVocabulary.values()) {
                if (!v.shortName.equals(name)) continue;
                return v;
            }
        }
        throw new IllegalArgumentException("the input value does not match any of the known xsd types: " + s);
    }

    @Override
    public String getPrefixedName() {
        return this.prefixedName;
    }
}

