# -*- coding: utf-8 -*-
info = {
    "name": "af",
    "date_order": "YMD",
    "january": [
        "januarie",
        "jan"
    ],
    "february": [
        "februarie",
        "feb"
    ],
    "march": [
        "maart",
        "mrt"
    ],
    "april": [
        "april",
        "apr"
    ],
    "may": [
        "mei"
    ],
    "june": [
        "junie",
        "jun"
    ],
    "july": [
        "julie",
        "jul"
    ],
    "august": [
        "augustus",
        "aug"
    ],
    "september": [
        "september",
        "sep"
    ],
    "october": [
        "oktober",
        "okt"
    ],
    "november": [
        "november",
        "nov"
    ],
    "december": [
        "desember",
        "des"
    ],
    "monday": [
        "maandag",
        "ma"
    ],
    "tuesday": [
        "dinsdag",
        "di"
    ],
    "wednesday": [
        "woensdag",
        "wo"
    ],
    "thursday": [
        "donderdag",
        "do"
    ],
    "friday": [
        "vrydag",
        "vr"
    ],
    "saturday": [
        "saterdag",
        "sa"
    ],
    "sunday": [
        "sondag",
        "so"
    ],
    "am": [
        "vm"
    ],
    "pm": [
        "nm"
    ],
    "year": [
        "jaar",
        "j"
    ],
    "month": [
        "maand",
        "md"
    ],
    "week": [
        "week",
        "wk"
    ],
    "day": [
        "dag",
        "d"
    ],
    "hour": [
        "uur",
        "u"
    ],
    "minute": [
        "minuut",
        "min",
        "m"
    ],
    "second": [
        "sekonde",
        "sek",
        "s"
    ],
    "relative-type": {
        "1 year ago": [
            "verlede jaar"
        ],
        "0 year ago": [
            "hierdie jaar"
        ],
        "in 1 year": [
            "volgende jaar"
        ],
        "1 month ago": [
            "verlede maand"
        ],
        "0 month ago": [
            "vandeesmaand"
        ],
        "in 1 month": [
            "volgende maand"
        ],
        "1 week ago": [
            "verlede week"
        ],
        "0 week ago": [
            "vandeesweek"
        ],
        "in 1 week": [
            "volgende week"
        ],
        "1 day ago": [
            "gister"
        ],
        "0 day ago": [
            "vandag"
        ],
        "in 1 day": [
            "môre"
        ],
        "0 hour ago": [
            "hierdie uur"
        ],
        "0 minute ago": [
            "hierdie minuut"
        ],
        "0 second ago": [
            "nou"
        ]
    },
    "relative-type-regex": {
        "in \\1 year": [
            "oor (\\d+) jaar"
        ],
        "\\1 year ago": [
            "(\\d+) jaar gelede"
        ],
        "in \\1 month": [
            "oor (\\d+) minuut",
            "oor (\\d+) md"
        ],
        "\\1 month ago": [
            "(\\d+) maand gelede",
            "(\\d+) maande gelede",
            "(\\d+) md gelede"
        ],
        "in \\1 week": [
            "oor (\\d+) week",
            "oor (\\d+) weke",
            "oor (\\d+) w"
        ],
        "\\1 week ago": [
            "(\\d+) week gelede",
            "(\\d+) weke gelede",
            "(\\d+) w gelede"
        ],
        "in \\1 day": [
            "oor (\\d+) minuut",
            "oor (\\d+) dag",
            "oor (\\d+) dae"
        ],
        "\\1 day ago": [
            "(\\d+) dag gelede",
            "(\\d+) dae gelede"
        ],
        "in \\1 hour": [
            "oor (\\d+) uur"
        ],
        "\\1 hour ago": [
            "(\\d+) uur gelede"
        ],
        "in \\1 minute": [
            "oor (\\d+) minuut",
            "oor (\\d+) min"
        ],
        "\\1 minute ago": [
            "(\\d+) minuut gelede",
            "(\\d+) minute gelede",
            "(\\d+) min gelede"
        ],
        "in \\1 second": [
            "oor (\\d+) sekonde",
            "oor (\\d+) sekondes",
            "oor (\\d+) sek"
        ],
        "\\1 second ago": [
            "(\\d+) sekonde gelede",
            "(\\d+) sekondes gelede",
            "(\\d+) sek gelede"
        ]
    },
    "locale_specific": {
        "af-NA": {
            "name": "af-NA"
        }
    },
    "skip": [
        " ",
        ".",
        ",",
        ";",
        "-",
        "/",
        "'",
        "|",
        "@",
        "[",
        "]",
        "，"
    ]
}
