# frozen_string_literal: true

Rails.application.configure do
  # Settings specified here will take precedence over those in config/application.rb

  # The test environment is used exclusively to run your application's
  # test suite.  You never need to work with it otherwise.  Remember that
  # your test database is "scratch space" for the test suite and is wiped
  # and recreated between test runs.  Don't rely on the data there!
  config.cache_classes = true

  # Do not eager load code on boot. This avoids loading your whole application
  # just for the purpose of running a single test. If you are using a tool that
  # preloads Rails for running tests, you may have to set it to true.
  config.eager_load = false

  # Show full error reports and disable caching
  config.consider_all_requests_local = true
  config.action_controller.perform_caching = false

  config.action_mailer.perform_deliveries = true

  # Tell Action Mailer not to deliver emails to the real world.
  # The :test delivery method accumulates sent emails in the
  # ActionMailer::Base.deliveries array.
  config.action_mailer.delivery_method = :test

  # Disable Async delivery
  config.active_job.queue_adapter = :inline

  # Disable request forgery protection in test environment.
  config.action_controller.allow_forgery_protection = false

  # Disable sessions verifications in test environment.
  config.redmine_verify_sessions = false

  # Print deprecation notices to stderr and the Rails logger.
  config.active_support.deprecation = [:stderr, :log]

  config.secret_key_base = 'a secret token for running the tests'

  config.active_support.test_order = :random
end
