/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.rendered;

import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.DataBufferInt;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import org.apache.batik.ext.awt.image.GraphicsUtil;
import org.apache.batik.ext.awt.image.PadMode;
import org.apache.batik.ext.awt.image.rendered.AbstractRed;
import org.apache.batik.ext.awt.image.rendered.AbstractTiledRed;
import org.apache.batik.ext.awt.image.rendered.CachableRed;

public class PadRed
extends AbstractRed {
    static final boolean DEBUG = false;
    PadMode padMode;
    RenderingHints hints;

    public PadRed(CachableRed cachableRed, Rectangle rectangle, PadMode padMode, RenderingHints renderingHints) {
        super(cachableRed, rectangle, cachableRed.getColorModel(), PadRed.fixSampleModel(cachableRed, rectangle), rectangle.x, rectangle.y, null);
        this.padMode = padMode;
        this.hints = renderingHints;
    }

    @Override
    public WritableRaster copyData(WritableRaster writableRaster) {
        CachableRed cachableRed = (CachableRed)this.getSources().get(0);
        Rectangle rectangle = cachableRed.getBounds();
        Rectangle rectangle2 = writableRaster.getBounds();
        if (rectangle2.intersects(rectangle)) {
            Rectangle rectangle3 = rectangle2.intersection(rectangle);
            WritableRaster writableRaster2 = writableRaster.createWritableChild(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height, rectangle3.x, rectangle3.y, null);
            cachableRed.copyData(writableRaster2);
        }
        if (this.padMode == PadMode.ZERO_PAD) {
            this.handleZero(writableRaster);
        } else if (this.padMode == PadMode.REPLICATE) {
            this.handleReplicate(writableRaster);
        } else if (this.padMode == PadMode.WRAP) {
            this.handleWrap(writableRaster);
        }
        return writableRaster;
    }

    protected void handleZero(WritableRaster writableRaster) {
        int n;
        int n2;
        CachableRed cachableRed = (CachableRed)this.getSources().get(0);
        Rectangle rectangle = cachableRed.getBounds();
        Rectangle rectangle2 = writableRaster.getBounds();
        ZeroRecter zeroRecter = ZeroRecter.getZeroRecter(writableRaster);
        Rectangle rectangle3 = new Rectangle(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
        Rectangle rectangle4 = new Rectangle(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
        if (rectangle3.x < rectangle.x) {
            n2 = rectangle.x - rectangle3.x;
            if (n2 > rectangle3.width) {
                n2 = rectangle3.width;
            }
            rectangle4.width = n2;
            zeroRecter.zeroRect(rectangle4);
            rectangle3.x += n2;
            rectangle3.width -= n2;
        }
        if (rectangle3.y < rectangle.y) {
            n2 = rectangle.y - rectangle3.y;
            if (n2 > rectangle3.height) {
                n2 = rectangle3.height;
            }
            rectangle4.x = rectangle3.x;
            rectangle4.y = rectangle3.y;
            rectangle4.width = rectangle3.width;
            rectangle4.height = n2;
            zeroRecter.zeroRect(rectangle4);
            rectangle3.y += n2;
            rectangle3.height -= n2;
        }
        if (rectangle3.y + rectangle3.height > rectangle.y + rectangle.height) {
            n2 = rectangle3.y + rectangle3.height - (rectangle.y + rectangle.height);
            if (n2 > rectangle3.height) {
                n2 = rectangle3.height;
            }
            n = rectangle3.y + rectangle3.height - n2;
            rectangle4.x = rectangle3.x;
            rectangle4.y = n;
            rectangle4.width = rectangle3.width;
            rectangle4.height = n2;
            zeroRecter.zeroRect(rectangle4);
            rectangle3.height -= n2;
        }
        if (rectangle3.x + rectangle3.width > rectangle.x + rectangle.width) {
            n2 = rectangle3.x + rectangle3.width - (rectangle.x + rectangle.width);
            if (n2 > rectangle3.width) {
                n2 = rectangle3.width;
            }
            rectangle4.x = n = rectangle3.x + rectangle3.width - n2;
            rectangle4.y = rectangle3.y;
            rectangle4.width = n2;
            rectangle4.height = rectangle3.height;
            zeroRecter.zeroRect(rectangle4);
            rectangle3.width -= n2;
        }
    }

    protected void handleReplicate(WritableRaster writableRaster) {
        CachableRed cachableRed = (CachableRed)this.getSources().get(0);
        Rectangle rectangle = cachableRed.getBounds();
        Rectangle rectangle2 = writableRaster.getBounds();
        int n = rectangle2.x;
        int n2 = rectangle2.y;
        int n3 = rectangle2.width;
        int n4 = rectangle2.height;
        int n5 = rectangle.x > n ? rectangle.x : n;
        int n6 = rectangle.x + rectangle.width - 1 < n + n3 - 1 ? rectangle.x + rectangle.width - 1 : n + n3 - 1;
        int n7 = rectangle.y > n2 ? rectangle.y : n2;
        int n8 = rectangle.y + rectangle.height - 1 < n2 + n4 - 1 ? rectangle.y + rectangle.height - 1 : n2 + n4 - 1;
        int n9 = n5;
        int n10 = n6 - n5 + 1;
        int n11 = n7;
        int n12 = n8 - n7 + 1;
        if (n10 < 0) {
            n9 = 0;
            n10 = 0;
        }
        if (n12 < 0) {
            n11 = 0;
            n12 = 0;
        }
        Rectangle rectangle3 = new Rectangle(n9, n11, n10, n12);
        if (n2 < rectangle.y) {
            n5 = rectangle3.width;
            n6 = rectangle3.x;
            n7 = rectangle3.x;
            n8 = n2;
            if (n + n3 - 1 <= rectangle.x) {
                n5 = 1;
                n6 = rectangle.x;
                n7 = n + n3 - 1;
            } else if (n >= rectangle.x + rectangle.width) {
                n5 = 1;
                n6 = rectangle.x + rectangle.width - 1;
                n7 = n;
            }
            WritableRaster writableRaster2 = writableRaster.createWritableChild(n7, n8, n5, 1, n6, rectangle.y, null);
            cachableRed.copyData(writableRaster2);
            ++n8;
            n10 = rectangle.y;
            if (n2 + n4 < n10) {
                n10 = n2 + n4;
            }
            if (n8 < n10) {
                int[] nArray = writableRaster.getPixels(n7, n8 - 1, n5, 1, (int[])null);
                while (n8 < rectangle.y) {
                    writableRaster.setPixels(n7, n8, n5, 1, nArray);
                    ++n8;
                }
            }
        }
        if (n2 + n4 > rectangle.y + rectangle.height) {
            n5 = rectangle3.width;
            n6 = rectangle3.x;
            n7 = rectangle.y + rectangle.height - 1;
            n8 = rectangle3.x;
            int n13 = rectangle.y + rectangle.height;
            if (n13 < n2) {
                n13 = n2;
            }
            if (n + n3 <= rectangle.x) {
                n5 = 1;
                n6 = rectangle.x;
                n8 = n + n3 - 1;
            } else if (n >= rectangle.x + rectangle.width) {
                n5 = 1;
                n6 = rectangle.x + rectangle.width - 1;
                n8 = n;
            }
            WritableRaster writableRaster3 = writableRaster.createWritableChild(n8, n13, n5, 1, n6, n7, null);
            cachableRed.copyData(writableRaster3);
            int n14 = n2 + n4;
            if (++n13 < n14) {
                int[] nArray = writableRaster.getPixels(n8, n13 - 1, n5, 1, (int[])null);
                while (n13 < n14) {
                    writableRaster.setPixels(n8, n13, n5, 1, nArray);
                    ++n13;
                }
            }
        }
        if (n < rectangle.x) {
            n5 = rectangle.x;
            if (n + n3 <= rectangle.x) {
                n5 = n + n3 - 1;
            }
            int[] nArray = writableRaster.getPixels(n5, n2, 1, n4, (int[])null);
            for (n6 = n; n6 < n5; ++n6) {
                writableRaster.setPixels(n6, n2, 1, n4, nArray);
            }
        }
        if (n + n3 > rectangle.x + rectangle.width) {
            n5 = rectangle.x + rectangle.width - 1;
            if (n >= rectangle.x + rectangle.width) {
                n5 = n;
            }
            int n15 = n + n3 - 1;
            int[] nArray = writableRaster.getPixels(n5, n2, 1, n4, (int[])null);
            for (n6 = n5 + 1; n6 < n15; ++n6) {
                writableRaster.setPixels(n6, n2, 1, n4, nArray);
            }
        }
    }

    protected void handleWrap(WritableRaster writableRaster) {
        this.handleZero(writableRaster);
    }

    protected static SampleModel fixSampleModel(CachableRed cachableRed, Rectangle rectangle) {
        int n;
        int n2 = AbstractTiledRed.getDefaultTileSize();
        SampleModel sampleModel = cachableRed.getSampleModel();
        int n3 = sampleModel.getWidth();
        if (n3 < n2) {
            n3 = n2;
        }
        if (n3 > rectangle.width) {
            n3 = rectangle.width;
        }
        if ((n = sampleModel.getHeight()) < n2) {
            n = n2;
        }
        if (n > rectangle.height) {
            n = rectangle.height;
        }
        return sampleModel.createCompatibleSampleModel(n3, n);
    }

    protected static class ZeroRecter_INT_PACK
    extends ZeroRecter {
        final int base;
        final int scanStride;
        final int[] pixels;
        final int[] zeros;
        final int x0;
        final int y0;

        public ZeroRecter_INT_PACK(WritableRaster writableRaster) {
            super(writableRaster);
            SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)writableRaster.getSampleModel();
            this.scanStride = singlePixelPackedSampleModel.getScanlineStride();
            DataBufferInt dataBufferInt = (DataBufferInt)writableRaster.getDataBuffer();
            this.x0 = writableRaster.getMinY();
            this.y0 = writableRaster.getMinX();
            this.base = dataBufferInt.getOffset() + singlePixelPackedSampleModel.getOffset(this.x0 - writableRaster.getSampleModelTranslateX(), this.y0 - writableRaster.getSampleModelTranslateY());
            this.pixels = dataBufferInt.getBankData()[0];
            this.zeros = (int[])(writableRaster.getWidth() > 10 ? new int[writableRaster.getWidth()] : null);
        }

        @Override
        public void zeroRect(Rectangle rectangle) {
            int n = this.base + (rectangle.x - this.x0) + (rectangle.y - this.y0) * this.scanStride;
            if (rectangle.width > 10) {
                for (int i = 0; i < rectangle.height; ++i) {
                    int n2 = n + i * this.scanStride;
                    System.arraycopy(this.zeros, 0, this.pixels, n2, rectangle.width);
                }
            } else {
                int n3 = n;
                int n4 = n3 + rectangle.width;
                int n5 = this.scanStride - rectangle.width;
                for (int i = 0; i < rectangle.height; ++i) {
                    while (n3 < n4) {
                        this.pixels[n3++] = 0;
                    }
                    n3 += n5;
                    n4 += this.scanStride;
                }
            }
        }
    }

    protected static class ZeroRecter {
        WritableRaster wr;
        int bands;
        static int[] zeros = null;

        public ZeroRecter(WritableRaster writableRaster) {
            this.wr = writableRaster;
            this.bands = writableRaster.getSampleModel().getNumBands();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void zeroRect(Rectangle rectangle) {
            ZeroRecter zeroRecter = this;
            synchronized (zeroRecter) {
                if (zeros == null || zeros.length < rectangle.width * this.bands) {
                    zeros = new int[rectangle.width * this.bands];
                }
            }
            for (int i = 0; i < rectangle.height; ++i) {
                this.wr.setPixels(rectangle.x, rectangle.y + i, rectangle.width, 1, zeros);
            }
        }

        public static ZeroRecter getZeroRecter(WritableRaster writableRaster) {
            if (GraphicsUtil.is_INT_PACK_Data(writableRaster.getSampleModel(), false)) {
                return new ZeroRecter_INT_PACK(writableRaster);
            }
            return new ZeroRecter(writableRaster);
        }

        public static void zeroRect(WritableRaster writableRaster) {
            ZeroRecter zeroRecter = ZeroRecter.getZeroRecter(writableRaster);
            zeroRecter.zeroRect(writableRaster.getBounds());
        }
    }
}

