/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.packages.ssh;

import cc.arduino.packages.ssh.SSH;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.Session;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.utils.IOUtils;

public class SCP
extends SSH {
    private Channel channel;
    private OutputStream out;
    private InputStream in;

    public SCP(Session session) {
        super(session);
    }

    public void open() throws IOException {
        try {
            this.channel = this.session.openChannel("exec");
            ((ChannelExec)this.channel).setCommand("scp -t -r -d /");
            this.out = this.channel.getOutputStream();
            this.in = this.channel.getInputStream();
            this.channel.connect();
            this.ensureAcknowledged();
        }
        catch (Exception e) {
            this.close();
        }
    }

    public void close() {
        IOUtils.closeQuietly((Closeable)this.out);
        IOUtils.closeQuietly((Closeable)this.in);
        if (this.channel != null) {
            this.channel.disconnect();
        }
    }

    private void ensureAcknowledged() throws IOException {
        this.out.flush();
        int b = this.in.read();
        if (b == 0) {
            return;
        }
        if (b == -1) {
            return;
        }
        if (b == 1 || b == 2) {
            int c;
            StringBuilder sb = new StringBuilder();
            sb.append("SCP error: ");
            do {
                c = this.in.read();
                sb.append((char)c);
            } while (c != 10);
            throw new IOException(sb.toString());
        }
        throw new IOException("Uknown SCP error: " + b);
    }

    public void sendFile(File localFile) throws IOException {
        this.sendFile(localFile, localFile.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendFile(File localFile, String remoteFile) throws IOException {
        this.out.write(("C0644 " + localFile.length() + " " + remoteFile + "\n").getBytes());
        this.ensureAcknowledged();
        FileInputStream fis = null;
        try {
            int len;
            fis = new FileInputStream(localFile);
            byte[] buf = new byte[4096];
            while ((len = fis.read(buf, 0, buf.length)) > 0) {
                this.out.write(buf, 0, len);
            }
            buf[0] = 0;
            this.out.write(buf, 0, 1);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fis);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)fis);
        this.ensureAcknowledged();
    }

    public void startFolder(String folder) throws IOException {
        this.out.write(("D0755 0 " + folder + "\n").getBytes());
        this.ensureAcknowledged();
    }

    public void endFolder() throws IOException {
        this.out.write("E\n".getBytes());
        this.ensureAcknowledged();
    }
}

