/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.utils.network;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CacheControl {
    private static final Pattern PATTERN = Pattern.compile("\\s*([\\w\\-]+)\\s*(=)?\\s*(\\-?\\d+|\\\"([^\"\\\\]*(\\\\.[^\"\\\\]*)*)+\\\")?\\s*");
    private int maxAge = -1;
    private boolean isMustRevalidate = false;
    private boolean isNoCache = false;
    private boolean isNoStore = false;

    public static CacheControl valueOf(String value) {
        CacheControl cc = new CacheControl();
        if (value != null) {
            Matcher matcher = PATTERN.matcher(value);
            while (matcher.find()) {
                switch (matcher.group(1).toLowerCase()) {
                    case "max-age": {
                        cc.setMaxAge(Integer.parseInt(matcher.group(3)));
                        break;
                    }
                    case "must-revalidate": {
                        cc.setMustRevalidate(true);
                        break;
                    }
                    case "no-cache": {
                        cc.setNoCache(true);
                        break;
                    }
                    case "no-store": {
                        cc.setNoStore(true);
                        break;
                    }
                }
            }
        }
        return cc;
    }

    public void setMaxAge(int maxAge) {
        this.maxAge = maxAge;
    }

    public int getMaxAge() {
        return this.maxAge;
    }

    public boolean isMustRevalidate() {
        return this.isMustRevalidate;
    }

    public void setMustRevalidate(boolean mustRevalidate) {
        this.isMustRevalidate = mustRevalidate;
    }

    public boolean isNoCache() {
        return this.isNoCache;
    }

    public void setNoCache(boolean noCache) {
        this.isNoCache = noCache;
    }

    public boolean isNoStore() {
        return this.isNoStore;
    }

    public void setNoStore(boolean noStore) {
        this.isNoStore = noStore;
    }

    public String toString() {
        return "CacheControl{maxAge=" + this.maxAge + ", isMustRevalidate=" + this.isMustRevalidate + ", isNoCache=" + this.isNoCache + ", isNoStore=" + this.isNoStore + '}';
    }
}

