/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.codec.tiff;

import java.io.IOException;
import java.io.InputStream;
import org.apache.batik.ext.awt.image.codec.tiff.TIFFDecodeParam;
import org.apache.batik.ext.awt.image.codec.tiff.TIFFImage;
import org.apache.batik.ext.awt.image.codec.util.SeekableStream;
import org.apache.batik.ext.awt.image.renderable.DeferRable;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.ext.awt.image.renderable.RedRable;
import org.apache.batik.ext.awt.image.rendered.Any2sRGBRed;
import org.apache.batik.ext.awt.image.rendered.CachableRed;
import org.apache.batik.ext.awt.image.spi.ImageTagRegistry;
import org.apache.batik.ext.awt.image.spi.MagicNumberRegistryEntry;
import org.apache.batik.util.ParsedURL;

public class TIFFRegistryEntry
extends MagicNumberRegistryEntry {
    static final byte[] sig1 = new byte[]{73, 73, 42, 0};
    static final byte[] sig2 = new byte[]{77, 77, 0, 42};
    static MagicNumberRegistryEntry.MagicNumber[] magicNumbers = new MagicNumberRegistryEntry.MagicNumber[]{new MagicNumberRegistryEntry.MagicNumber(0, sig1), new MagicNumberRegistryEntry.MagicNumber(0, sig2)};
    static final String[] exts = new String[]{"tiff", "tif"};
    static final String[] mimeTypes = new String[]{"image/tiff", "image/tif"};

    public TIFFRegistryEntry() {
        super("TIFF", exts, mimeTypes, magicNumbers);
    }

    public Filter handleStream(InputStream inputStream, ParsedURL parsedURL, boolean bl) {
        Object[] objectArray;
        String string;
        final DeferRable deferRable = new DeferRable();
        final InputStream inputStream2 = inputStream;
        if (parsedURL != null) {
            string = "url.format.unreadable";
            objectArray = new Object[]{"TIFF", parsedURL};
        } else {
            string = "stream.format.unreadable";
            objectArray = new Object[]{"TIFF"};
        }
        Thread thread = new Thread(){

            @Override
            public void run() {
                Filter filter;
                try {
                    TIFFDecodeParam tIFFDecodeParam = new TIFFDecodeParam();
                    SeekableStream seekableStream = SeekableStream.wrapInputStream(inputStream2, true);
                    TIFFImage tIFFImage = new TIFFImage(seekableStream, tIFFDecodeParam, 0);
                    tIFFImage = new Any2sRGBRed((CachableRed)tIFFImage);
                    filter = new RedRable((CachableRed)tIFFImage);
                }
                catch (IOException iOException) {
                    filter = ImageTagRegistry.getBrokenLinkImage((Object)((Object)TIFFRegistryEntry.this), (String)string, (Object[])objectArray);
                }
                catch (ThreadDeath threadDeath) {
                    Filter filter2 = ImageTagRegistry.getBrokenLinkImage((Object)((Object)TIFFRegistryEntry.this), (String)string, (Object[])objectArray);
                    deferRable.setSource(filter2);
                    throw threadDeath;
                }
                catch (Throwable throwable) {
                    filter = ImageTagRegistry.getBrokenLinkImage((Object)((Object)TIFFRegistryEntry.this), (String)string, (Object[])objectArray);
                }
                deferRable.setSource(filter);
            }
        };
        thread.start();
        return deferRable;
    }
}

