/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.validation.api.builtin;

import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Locale;
import org.netbeans.validation.api.Problems;
import org.netbeans.validation.api.Validator;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class IsANumberValidator
implements Validator<String> {
    private Locale locale;

    IsANumberValidator() {
        this(null);
    }

    IsANumberValidator(Locale l) {
        this.locale = l;
    }

    @Override
    public boolean validate(Problems problems, String compName, String model) {
        ParsePosition p = new ParsePosition(0);
        try {
            NumberFormat.getNumberInstance(this.locale == null ? Locale.getDefault() : this.locale).parse(model, p);
            if (model.length() != p.getIndex() || p.getErrorIndex() != -1) {
                problems.add(NbBundle.getMessage(IsANumberValidator.class, (String)"NOT_A_NUMBER", (Object)model, (Object)compName));
                return false;
            }
        }
        catch (NumberFormatException nfe) {
            problems.add(NbBundle.getMessage(IsANumberValidator.class, (String)"NOT_A_NUMBER", (Object)model, (Object)compName));
            return false;
        }
        return true;
    }
}

