/*
 * Decompiled with CFR 0.152.
 */
package jspecview.common;

import javajs.util.PT;

public class ScriptTokenizer {
    private String str;
    private int pt = -1;
    private int len;
    private boolean isCmd;
    private boolean doCheck = true;

    public ScriptTokenizer(String string, boolean bl) {
        this.str = string;
        this.len = string.length();
        this.isCmd = bl;
    }

    static String nextStringToken(ScriptTokenizer scriptTokenizer, boolean bl) {
        String string = scriptTokenizer.nextToken();
        return bl && string.charAt(0) == '\"' && string.endsWith("\"") && string.length() > 1 ? PT.trimQuotes(string) : string;
    }

    /*
     * Enabled aggressive block sorting
     */
    public String nextToken() {
        if (this.doCheck) {
            this.hasMoreTokens();
        }
        int n = this.pt;
        boolean bl = this.str.charAt(this.pt) == '\"';
        block5: while (++this.pt < this.len) {
            switch (this.str.charAt(this.pt)) {
                case '\"': {
                    if (bl) {
                        if (this.isCmd) {
                            bl = false;
                            break;
                        }
                        ++this.pt;
                        break block5;
                    }
                    if (!this.isCmd) break;
                    bl = true;
                    break;
                }
                case ' ': {
                    if (this.isCmd || bl) break;
                    break block5;
                }
                case '\n': 
                case ';': {
                    if (this.isCmd && !bl) break block5;
                }
            }
        }
        this.doCheck = true;
        return this.str.substring(n, this.pt);
    }

    public boolean hasMoreTokens() {
        block3: while (++this.pt < this.len) {
            switch (this.str.charAt(this.pt)) {
                case '\n': 
                case ' ': 
                case ';': {
                    break;
                }
                default: {
                    break block3;
                }
            }
        }
        this.doCheck = false;
        return this.pt < this.len;
    }

    public String getRemainingScript() {
        return this.str.substring(this.pt);
    }
}

