/*
 * Decompiled with CFR 0.152.
 */
package jspecview.common;

import javajs.api.GenericColor;
import javajs.util.CU;
import javajs.util.Lst;
import jspecview.common.ColoredAnnotation;
import jspecview.common.Coordinate;
import jspecview.common.Spectrum;
import org.jmol.api.GenericGraphics;

public class Annotation
extends Coordinate {
    public String text = "";
    protected boolean isPixels;
    boolean is2D;
    int offsetX;
    int offsetY;
    Spectrum spec;

    protected Annotation setA(double x, double y, Spectrum spec, String text, boolean isPixels, boolean is2D, int offsetX, int offsetY) {
        this.set(x, y);
        this.spec = spec;
        this.text = text;
        this.isPixels = isPixels;
        this.is2D = is2D;
        this.offsetX = offsetX;
        this.offsetY = offsetY;
        return this;
    }

    Annotation setSpec(Spectrum spec) {
        this.spec = spec;
        return this;
    }

    void addSpecShift(double dx) {
        this.setXVal(this.getXVal() + dx);
    }

    boolean isPixels() {
        return this.isPixels;
    }

    @Override
    public String toString() {
        return "[" + this.getXVal() + ", " + this.getYVal() + "," + this.text + "]";
    }

    public static Annotation getColoredAnnotation(GenericGraphics g2d, Spectrum spec, Lst<String> args, Annotation lastAnnotation) {
        int xPt = 0;
        int yPt = 1;
        int colorPt = 2;
        int textPt = 3;
        int nArgs = args.size();
        try {
            String text;
            GenericColor color;
            switch (nArgs) {
                default: {
                    return null;
                }
                case 1: {
                    String arg = (String)args.get(0);
                    yPt = -1;
                    xPt = -1;
                    if (arg.charAt(0) == '\"') {
                        textPt = 0;
                        colorPt = -1;
                        break;
                    }
                    colorPt = 0;
                    textPt = -1;
                    break;
                }
                case 2: {
                    yPt = -1;
                    xPt = -1;
                    String arg = (String)args.get(0);
                    if (arg.charAt(0) == '\"') {
                        textPt = 0;
                        colorPt = 1;
                        break;
                    }
                    colorPt = 0;
                    textPt = 1;
                    break;
                }
                case 3: 
                case 4: {
                    String arg = (String)args.get(2);
                    if (arg.charAt(0) == '\"') {
                        textPt = 2;
                        colorPt = nArgs == 4 ? 3 : -1;
                    } else {
                        colorPt = 2;
                        textPt = nArgs == 4 ? 3 : -1;
                    }
                    arg = (String)args.get(2);
                    if (arg.charAt(0) == '\"') {
                        textPt = 2;
                        colorPt = -1;
                        break;
                    }
                    colorPt = 2;
                    textPt = -1;
                }
            }
            if (lastAnnotation == null && (xPt < 0 || yPt < 0 || textPt < 0 || colorPt < 0)) {
                return null;
            }
            double x = xPt < 0 ? lastAnnotation.getXVal() : Double.valueOf((String)args.get(xPt)).doubleValue();
            double y = yPt < 0 ? lastAnnotation.getYVal() : Double.valueOf((String)args.get(yPt)).doubleValue();
            GenericColor genericColor = color = colorPt < 0 ? ((ColoredAnnotation)lastAnnotation).getColor() : g2d.getColor1(CU.getArgbFromString((String)args.get(colorPt)));
            if (textPt < 0) {
                text = lastAnnotation.text;
            } else {
                text = (String)args.get(textPt);
                if (text.charAt(0) == '\"') {
                    text = text.substring(1, text.length() - 1);
                }
            }
            return new ColoredAnnotation().setCA(x, y, spec, text, color, false, false, 0, 0);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static enum AType {
        Integration,
        PeakList,
        Measurements,
        OverlayLegend,
        Views,
        NONE;

    }
}

