/*
 * Decompiled with CFR 0.152.
 */
package jspecview.source;

import javajs.util.Lst;
import jspecview.common.Spectrum;
import jspecview.source.JDXHeader;

public class JDXSource
extends JDXHeader {
    public static final int TYPE_VIEW = -2;
    public static final int TYPE_UNKNOWN = -1;
    public static final int TYPE_SIMPLE = 0;
    public static final int TYPE_BLOCK = 1;
    public static final int TYPE_NTUPLE = 2;
    public int type = 0;
    public boolean isCompoundSource = false;
    private Lst<Spectrum> jdxSpectra;
    private String errors = "";
    private String filePath;
    public int peakCount;
    public boolean isView;
    private String inlineData;

    public void dispose() {
        this.headerTable = null;
        this.jdxSpectra = null;
    }

    public JDXSource(int type, String filePath) {
        this.type = type;
        this.setFilePath(filePath);
        this.headerTable = new Lst();
        this.jdxSpectra = new Lst();
        this.isCompoundSource = type != 0;
    }

    public Spectrum getJDXSpectrum(int index) {
        return this.jdxSpectra.size() <= index ? null : (Spectrum)this.jdxSpectra.get(index);
    }

    public void addJDXSpectrum(String filePath, Spectrum spectrum, boolean forceSub) {
        int n;
        if (filePath == null) {
            filePath = this.filePath;
        }
        spectrum.setFilePath(filePath);
        if (this.inlineData != null) {
            spectrum.setInlineData(this.inlineData);
        }
        if ((n = this.jdxSpectra.size()) == 0 || !((Spectrum)this.jdxSpectra.get(n - 1)).addSubSpectrum(spectrum, forceSub)) {
            this.jdxSpectra.addLast(spectrum);
        }
    }

    public int getNumberOfSpectra() {
        return this.jdxSpectra.size();
    }

    public Lst<Spectrum> getSpectra() {
        return this.jdxSpectra;
    }

    public Spectrum[] getSpectraAsArray() {
        return (Spectrum[])(this.jdxSpectra == null ? null : this.jdxSpectra.toArray());
    }

    public String getErrorLog() {
        return this.errors;
    }

    public void setErrorLog(String errors) {
        this.errors = errors;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public static JDXSource createView(Lst<Spectrum> specs) {
        JDXSource source = new JDXSource(-2, "view");
        source.isView = true;
        for (int i = 0; i < specs.size(); ++i) {
            source.addJDXSpectrum(((Spectrum)specs.get(i)).getFilePath(), (Spectrum)specs.get(i), false);
        }
        return source;
    }

    public String[][] getHeaderRowDataAsArray(boolean addDataClass, String[][] rowData) {
        if (rowData == null) {
            rowData = new String[0][0];
        }
        String[][] data = this.getHeaderRowDataAsArray(addDataClass, rowData.length);
        int i = rowData.length;
        while (--i >= 0) {
            data[data.length - rowData.length + i] = rowData[i];
        }
        return data;
    }

    public void setID(String id) {
        ((Spectrum)this.jdxSpectra.get((int)0)).sourceID = id;
    }

    public boolean matchesFilePath(String filePath) {
        return this.filePath.equals(filePath) || this.filePath.replace('\\', '/').equals(filePath);
    }

    public void setInlineData(String data) {
        this.inlineData = data;
        if (this.jdxSpectra != null) {
            int i = this.jdxSpectra.size();
            while (--i >= 0) {
                ((Spectrum)this.jdxSpectra.get(i)).setInlineData(data);
            }
        }
    }
}

