/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.io.BufferedReader;
import javajs.util.CU;
import javajs.util.P3;
import javajs.util.PT;
import org.jmol.jvxl.readers.PmeshReader;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.util.Logger;

class KinemageReader
extends PmeshReader {
    private static final int POINTS_ALL = 0;
    private static final int POINTS_MCMC = 1;
    private static final int POINTS_SCSC = 2;
    private static final int POINTS_MCSC = 3;
    private static final int POINTS_HETS = 4;
    private int nDots = 0;
    private float vMin = -3.4028235E38f;
    private float vMax = Float.MAX_VALUE;
    private int pointType;
    private String findString;
    private String lastAtom = "";

    KinemageReader() {
    }

    @Override
    void init2(SurfaceGenerator sg, BufferedReader br) {
        this.init2PR(sg, br);
        this.type = "kinemage";
        this.setHeader();
    }

    @Override
    protected boolean readVolumeParameters(boolean isMapData) {
        if (this.params.parameters != null && this.params.parameters.length >= 2) {
            this.vMin = this.params.parameters[1];
            this.vMax = this.params.parameters.length >= 3 ? this.params.parameters[2] : this.vMin;
            this.pointType = this.params.parameters.length >= 4 ? (int)this.params.parameters[3] : 0;
            this.findString = this.params.calculationType;
        }
        return true;
    }

    @Override
    protected boolean readVertices() throws Exception {
        this.rd();
        while (this.line != null) {
            if (this.line.length() != 0 && this.line.charAt(0) == '@') {
                Logger.info(this.line);
                if (this.line.indexOf("contact}") >= 0 || this.line.indexOf("overlap}") >= 0 || this.line.indexOf("H-bonds}") >= 0) {
                    int n0;
                    if (this.line.indexOf("@dotlist") == 0) {
                        n0 = this.nDots;
                        this.readDots();
                        if (this.nDots <= n0) continue;
                        Logger.info("dots: " + (this.nDots - n0) + "/" + this.nDots);
                        continue;
                    }
                    if (this.line.indexOf("@vectorlist") == 0) {
                        n0 = this.nPolygons;
                        this.readVectors();
                        if (this.nPolygons <= n0) continue;
                        Logger.info("lines: " + (this.nPolygons - n0) + "/" + this.nPolygons);
                        continue;
                    }
                }
            }
            this.rd();
        }
        return true;
    }

    private void readDots() throws Exception {
        int[] color = new int[1];
        while (this.rd() != null && this.line.indexOf(64) < 0) {
            int i = this.getPoint(this.line, 2, color, true);
            if (i < 0) continue;
            ++this.nDots;
            this.nTriangles = this.addTriangleCheck(i, i, i, 7, 0, false, color[0]);
        }
    }

    private void readVectors() throws Exception {
        int[] color = new int[1];
        while (this.rd() != null && this.line.indexOf(64) < 0) {
            int ia = this.getPoint(this.line, 3, color, true);
            int ib = this.getPoint(this.line.substring(this.line.lastIndexOf(123)), 2, color, false);
            if (ia < 0 || ib < 0) continue;
            ++this.nPolygons;
            this.nTriangles = this.addTriangleCheck(ia, ib, ib, 7, 0, false, color[0]);
        }
    }

    private int getPoint(String line, int i, int[] retColor, boolean checkType) {
        String[] tokens;
        float value;
        if (this.findString != null) {
            String atom = line.substring(0, line.indexOf("}") + 1);
            if (atom.length() < 4) {
                atom = this.lastAtom;
            } else {
                this.lastAtom = atom;
            }
            if (atom.indexOf(this.findString) < 0) {
                return -1;
            }
        }
        if (Float.isNaN(value = this.assignValueFromGapColorForKin((tokens = PT.getTokens(line.substring(line.indexOf("}") + 1)))[0]))) {
            return -1;
        }
        if (checkType && this.pointType != 0) {
            switch (tokens[i - 1].charAt(1)) {
                case 'M': {
                    if (this.pointType == 1) break;
                    return -1;
                }
                case 'S': {
                    if (this.pointType == 2) break;
                    return -1;
                }
                case 'P': {
                    if (this.pointType == 3) break;
                    return -1;
                }
                case 'O': {
                    if (this.pointType == 4) break;
                    return -1;
                }
                default: {
                    return -1;
                }
            }
        }
        retColor[0] = this.getColor(tokens[0]);
        tokens = PT.getTokens(tokens[i].replace(',', ' '));
        P3 pt = P3.new3(PT.parseFloat(tokens[0]), PT.parseFloat(tokens[1]), PT.parseFloat(tokens[2]));
        if (this.isAnisotropic) {
            this.setVertexAnisotropy(pt);
        }
        return this.addVertexCopy(pt, value, this.nVertices++, false);
    }

    private int getColor(String color) {
        if (color.equals("sky")) {
            color = "skyblue";
        } else if (color.equals("sea")) {
            color = "seagreen";
        }
        return CU.getArgbFromString(color);
    }

    private float assignValueFromGapColorForKin(String color) {
        float value = color.equals("greentint") ? 4.0f : (color.equals("blue") ? 0.35f : (color.equals("sky") ? 0.25f : (color.equals("sea") ? 0.15f : (color.equals("green") ? 0.0f : (color.equals("yellowtint") ? -0.1f : (color.equals("yellow") ? -0.2f : (color.equals("orange") ? -0.3f : (color.equals("red") ? -0.4f : -0.5f))))))));
        return value >= this.vMin && value <= this.vMax ? value : Float.NaN;
    }

    @Override
    protected boolean readPolygons() {
        return true;
    }
}

