/*
 * Decompiled with CFR 0.152.
 */
package jspecview.common;

import javajs.util.PT;
import jspecview.common.Spectrum;

public class PeakInfo {
    public static final PeakInfo nullPeakInfo = new PeakInfo();
    private double xMin;
    private double xMax;
    private double yMin;
    private double yMax;
    private int px0;
    private int px1;
    private String stringInfo;
    private String type;
    private String type2;
    private String index;
    private String file;
    private String filePathForwardSlash;
    private String title;
    private String model;
    private String atoms;
    private String id;
    public Spectrum spectrum;
    private String _match;
    private String atomKey;

    public PeakInfo() {
    }

    public PeakInfo(String s) {
        this.stringInfo = s;
        this.type = PT.getQuotedAttribute(s, "type");
        if (this.type == null) {
            this.type = "";
        }
        this.type = this.type.toUpperCase();
        int pt = this.type.indexOf(47);
        this.type2 = pt < 0 ? "" : PeakInfo.fixType(this.type.substring(this.type.indexOf(47) + 1));
        this.type = pt >= 0 ? PeakInfo.fixType(this.type.substring(0, pt)) + "/" + this.type2 : PeakInfo.fixType(this.type);
        this.id = PT.getQuotedAttribute(s, "id");
        this.index = PT.getQuotedAttribute(s, "index");
        this.file = PT.getQuotedAttribute(s, "file");
        System.out.println("pi file=" + this.file);
        this.filePathForwardSlash = this.file == null ? null : this.file.replace('\\', '/');
        this.model = PT.getQuotedAttribute(s, "model");
        boolean isBaseModel = s.contains("baseModel=\"\"");
        if (!isBaseModel) {
            this.atoms = PT.getQuotedAttribute(s, "atoms");
        }
        this.atomKey = "," + this.atoms + ",";
        this.title = PT.getQuotedAttribute(s, "title");
        this._match = PT.getQuotedAttribute(s, "_match");
        this.xMax = PT.parseFloat(PT.getQuotedAttribute(s, "xMax"));
        this.xMin = PT.parseFloat(PT.getQuotedAttribute(s, "xMin"));
        this.yMax = PT.parseFloat(PT.getQuotedAttribute(s, "yMax"));
        this.yMin = PT.parseFloat(PT.getQuotedAttribute(s, "yMin"));
    }

    public boolean isClearAll() {
        return this.spectrum == null;
    }

    public String getType() {
        return this.type;
    }

    public String getAtoms() {
        return this.atoms;
    }

    public double getXMax() {
        return this.xMax;
    }

    public double getXMin() {
        return this.xMin;
    }

    public double getYMin() {
        return this.yMin;
    }

    public double getYMax() {
        return this.yMax;
    }

    public double getX() {
        return (this.xMax + this.xMin) / 2.0;
    }

    public String getMatch() {
        return this._match;
    }

    private static String fixType(String type) {
        return type.equals("HNMR") ? "1HNMR" : (type.equals("CNMR") ? "13CNMR" : type);
    }

    public String toString() {
        return this.stringInfo;
    }

    public String getIndex() {
        return this.index;
    }

    public String getTitle() {
        return this.title;
    }

    public boolean checkFileIndex(String filePath, String sIndex, String sAtomKey) {
        return sAtomKey != null ? this.atomKey.indexOf(sAtomKey) >= 0 : sIndex.equals(this.index) && (filePath.equals(this.file) || filePath.equals(this.filePathForwardSlash));
    }

    public boolean checkFileTypeModel(String filePath, String type, String model) {
        return filePath.equals(this.file) && this.checkModel(model) && this.type.endsWith(type);
    }

    public boolean checkTypeModel(String type, String model) {
        return this.checkType(type) && this.checkModel(model);
    }

    private boolean checkModel(String model) {
        return model != null && model.equals(this.model);
    }

    private boolean checkType(String type) {
        return type.endsWith(this.type);
    }

    public boolean checkTypeMatch(PeakInfo pi) {
        return this.checkType(pi.type) && (this.checkId(pi._match) || this.checkModel(pi._match) || this.title.toUpperCase().indexOf(pi._match) >= 0);
    }

    private boolean checkId(String match) {
        if (match == null) {
            return false;
        }
        return this.id != null && match.toUpperCase().startsWith("ID=") && match.substring(3).equals(this.id) || (match = match.toUpperCase()).startsWith("INDEX=") && match.equals("INDEX=" + this.index) || match.startsWith("#=") && match.equals("#=" + this.index);
    }

    public String getModel() {
        return this.model;
    }

    public String getFilePath() {
        return this.file;
    }

    public boolean autoSelectOnLoad() {
        return this.type.startsWith("GC");
    }

    public void setPixelRange(int x0, int x1) {
        this.px0 = x0;
        this.px1 = x1;
    }

    public double checkRange(int xPixel, double xVal) {
        if (xPixel != Integer.MAX_VALUE ? this.px0 <= xPixel && this.px1 >= xPixel : xVal >= this.xMin && xVal <= this.xMax) {
            return Math.abs(xVal - this.getX());
        }
        return 1.0E100;
    }

    public int getXPixel() {
        return (this.px0 + this.px1) / 2;
    }
}

