/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import org.jmol.viewer.MotionPoint;
import org.jmol.viewer.Viewer;
import org.jmol.viewer.binding.Binding;

class Gesture {
    private int action;
    MotionPoint[] nodes;
    private int ptNext;
    private long time0;
    private Viewer vwr;

    public Gesture(int nPoints, Viewer vwr) {
        this.vwr = vwr;
        this.nodes = new MotionPoint[nPoints];
        for (int i = 0; i < nPoints; ++i) {
            this.nodes[i] = new MotionPoint();
        }
    }

    void setAction(int action, long time) {
        this.action = action;
        this.ptNext = 0;
        this.time0 = time;
        for (int i = 0; i < this.nodes.length; ++i) {
            this.nodes[i].index = -1;
        }
    }

    int add(int action, int x, int y, long time) {
        this.action = action;
        this.getNode(this.ptNext).set(this.ptNext, x, y, time - this.time0);
        ++this.ptNext;
        return this.ptNext;
    }

    public long getTimeDifference(int nPoints) {
        if ((nPoints = this.getPointCount2(nPoints, 0)) < 2) {
            return 0L;
        }
        MotionPoint mp1 = this.getNode(this.ptNext - 1);
        MotionPoint mp0 = this.getNode(this.ptNext - nPoints);
        return mp1.time - mp0.time;
    }

    public float getSpeedPixelsPerMillisecond(int nPoints, int nPointsPrevious) {
        if ((nPoints = this.getPointCount2(nPoints, nPointsPrevious)) < 2) {
            return 0.0f;
        }
        MotionPoint mp1 = this.getNode(this.ptNext - 1 - nPointsPrevious);
        MotionPoint mp0 = this.getNode(this.ptNext - nPoints - nPointsPrevious);
        float dx = (float)(mp1.x - mp0.x) / (float)this.vwr.getScreenWidth() * 360.0f;
        float dy = (float)(mp1.y - mp0.y) / (float)this.vwr.getScreenHeight() * 360.0f;
        return (float)Math.sqrt(dx * dx + dy * dy) / (float)(mp1.time - mp0.time);
    }

    int getDX(int nPoints, int nPointsPrevious) {
        if ((nPoints = this.getPointCount2(nPoints, nPointsPrevious)) < 2) {
            return 0;
        }
        MotionPoint mp1 = this.getNode(this.ptNext - 1 - nPointsPrevious);
        MotionPoint mp0 = this.getNode(this.ptNext - nPoints - nPointsPrevious);
        return mp1.x - mp0.x;
    }

    int getDY(int nPoints, int nPointsPrevious) {
        if ((nPoints = this.getPointCount2(nPoints, nPointsPrevious)) < 2) {
            return 0;
        }
        MotionPoint mp1 = this.getNode(this.ptNext - 1 - nPointsPrevious);
        MotionPoint mp0 = this.getNode(this.ptNext - nPoints - nPointsPrevious);
        return mp1.y - mp0.y;
    }

    int getPointCount() {
        return this.ptNext;
    }

    private int getPointCount2(int nPoints, int nPointsPrevious) {
        if (nPoints > this.nodes.length - nPointsPrevious) {
            nPoints = this.nodes.length - nPointsPrevious;
        }
        int n = nPoints + 1;
        while (--n >= 0 && this.getNode((int)(this.ptNext - n - nPointsPrevious)).index < 0) {
        }
        return n;
    }

    MotionPoint getNode(int i) {
        return this.nodes[(i + this.nodes.length + this.nodes.length) % this.nodes.length];
    }

    public String toString() {
        if (this.nodes.length == 0) {
            return "" + this;
        }
        return Binding.getMouseActionName(this.action, false) + " nPoints = " + this.ptNext + " " + this.nodes[0];
    }
}

