/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.api;

import net.sourceforge.plantuml.api.MagicArray;

public final class CountRate {
    private final MagicArray lastMinute = new MagicArray(60);
    private final MagicArray lastHour = new MagicArray(60);
    private final MagicArray lastDay = new MagicArray(140);

    public void increment() {
        long now = System.currentTimeMillis();
        this.lastMinute.incKey(now / 1000L);
        this.lastHour.incKey(now / 60000L);
        this.lastDay.incKey(now / 600000L);
    }

    public void increment(int value) {
        long now = System.currentTimeMillis();
        this.lastMinute.incKey(now / 1000L, value);
        this.lastHour.incKey(now / 60000L, value);
        this.lastDay.incKey(now / 600000L, value);
    }

    public long perMinute() {
        return this.lastMinute.getSum();
    }

    public long perHour() {
        return this.lastHour.getSum();
    }

    public long perDay() {
        return this.lastDay.getSum();
    }

    public long perMinuteMax() {
        return this.lastMinute.getMaxSum();
    }

    public long perHourMax() {
        return this.lastHour.getMaxSum();
    }

    public long perDayMax() {
        return this.lastDay.getMaxSum();
    }
}

