/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.core2;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.plantuml.project.core2.Hole;

public class HolesList
implements Iterable<Hole> {
    private final List<Hole> list = new ArrayList<Hole>();

    public void addHole(Hole tooth) {
        this.list.add(tooth);
        Collections.sort(this.list);
    }

    public int size() {
        return this.list.size();
    }

    public String toString() {
        return this.list.toString();
    }

    public long getStart() {
        return this.list.get(0).getStart();
    }

    public long getEnd() {
        return this.list.get(this.list.size() - 1).getEnd();
    }

    @Override
    public Iterator<Hole> iterator() {
        return Collections.unmodifiableList(this.list).iterator();
    }

    public HolesList negate() {
        HolesList result = new HolesList();
        long i = 0L;
        for (Hole hole : this.list) {
            result.addHole(new Hole(i, hole.getStart()));
            i = hole.getEnd();
        }
        result.addHole(new Hole(i, 2147483647000L));
        return result;
    }
}

