/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.core2;

import net.sourceforge.plantuml.project.core2.IteratorSlice;
import net.sourceforge.plantuml.project.core2.Slice;
import net.sourceforge.plantuml.project.core2.TeethRange;
import net.sourceforge.plantuml.project.core2.Tooth;
import net.sourceforge.plantuml.project.core2.WorkLoad;

public class Solver1 {
    private final WorkLoad workLoad;

    public Solver1(WorkLoad workLoad) {
        this.workLoad = workLoad;
    }

    public TeethRange solveEnd(long start, long fullLoad) {
        IteratorSlice slices = this.workLoad.slices(start);
        TeethRange result = new TeethRange();
        while (true) {
            Slice current = slices.next();
            assert (current.getEnd() >= start);
            start = Math.max(start, current.getStart());
            long sliceLoad = 1L * (current.getEnd() - start) * (long)current.getWorkLoad();
            if (sliceLoad >= fullLoad) {
                long theoricalEnd = start + fullLoad / (long)current.getWorkLoad();
                result.add(new Tooth(start, theoricalEnd, fullLoad));
                return result;
            }
            assert (sliceLoad < fullLoad);
            result.add(new Tooth(start, current.getEnd(), sliceLoad));
            fullLoad -= sliceLoad;
        }
    }
}

