/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.draw;

import java.util.Map;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.project.LoadPlanable;
import net.sourceforge.plantuml.project.draw.TimeHeader;
import net.sourceforge.plantuml.project.time.Day;
import net.sourceforge.plantuml.project.time.MonthYear;
import net.sourceforge.plantuml.project.timescale.TimeScaleDaily;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColorNone;
import net.sourceforge.plantuml.ugraphic.color.HColorSet;
import net.sourceforge.plantuml.ugraphic.color.HColorUtils;

public class TimeHeaderDaily
extends TimeHeader {
    private final HColor veryLightGray = HColorSet.instance().getColorIfValid("#E0E8E8");
    private final HColor lightGray = HColorSet.instance().getColorIfValid("#909898");
    private final LoadPlanable defaultPlan;
    private final Map<Day, HColor> colorDays;
    private final Map<Day, String> nameDays;

    private double getTimeHeaderHeight() {
        return 41.0;
    }

    public TimeHeaderDaily(Day calendar, Day min, Day max, LoadPlanable defaultPlan, Map<Day, HColor> colorDays, Map<Day, String> nameDays, Day printStart, Day printEnd) {
        super(min, max, new TimeScaleDaily(calendar, printStart));
        this.defaultPlan = defaultPlan;
        this.colorDays = colorDays;
        this.nameDays = nameDays;
    }

    @Override
    public void drawTimeHeader(UGraphic ug, double totalHeight) {
        this.drawCalendar(ug, totalHeight);
        this.drawHline(ug, 0.0);
        this.drawHline(ug, this.getFullHeaderHeight());
    }

    private void drawCalendar(UGraphic ug, double totalHeight) {
        this.drawTexts(ug, totalHeight);
        this.drawMonths(ug);
        this.drawVBars(ug, totalHeight);
        this.drawVbar(ug, this.getTimeScale().getStartingPosition(this.max.increment()), 16.0, totalHeight);
        this.printNamedDays(ug);
    }

    private void drawTexts(UGraphic ug, double totalHeight) {
        double height = totalHeight - this.getFullHeaderHeight();
        Day wink = this.min;
        while (wink.compareTo(this.max) <= 0) {
            HColor back;
            double x1 = this.getTimeScale().getStartingPosition(wink);
            double x2 = this.getTimeScale().getEndingPosition(wink);
            HColor textColor = HColorUtils.BLACK;
            if (this.defaultPlan.getLoadAt(wink) <= 0) {
                textColor = this.lightGray;
            }
            if ((back = this.colorDays.get(wink)) == null && this.defaultPlan.getLoadAt(wink) == 0) {
                back = this.veryLightGray;
            }
            if (back != null) {
                this.drawRectangle(ug.apply(back.bg()), height, x1, x2);
            }
            this.printCentered(ug.apply(UTranslate.dy(16.0)), this.getTextBlock(wink.getDayOfWeek().shortName(), 10, false, textColor), x1, x2);
            this.printCentered(ug.apply(UTranslate.dy(28.0)), this.getTextBlock("" + wink.getDayOfMonth(), 10, false, textColor), x1, x2);
            wink = wink.increment();
        }
    }

    private void drawMonths(UGraphic ug) {
        MonthYear last = null;
        double lastChangeMonth = -1.0;
        Day wink = this.min;
        while (wink.compareTo(this.max) <= 0) {
            double x1 = this.getTimeScale().getStartingPosition(wink);
            if (!wink.monthYear().equals(last)) {
                if (last != null) {
                    this.printMonth(ug, last, lastChangeMonth, x1);
                }
                lastChangeMonth = x1;
                last = wink.monthYear();
            }
            wink = wink.increment();
        }
        double x1 = this.getTimeScale().getStartingPosition(this.max.increment());
        if (x1 > lastChangeMonth) {
            this.printMonth(ug, last, lastChangeMonth, x1);
        }
    }

    private void drawRectangle(UGraphic ug, double height, double x1, double x2) {
        if (height == 0.0) {
            return;
        }
        ug = ug.apply(new HColorNone());
        ug = ug.apply(new UTranslate(x1 + 1.0, this.getFullHeaderHeight()));
        ug.draw(new URectangle(x2 - x1 - 1.0, height));
    }

    private void drawVBars(UGraphic ug, double totalHeight) {
        MonthYear last = null;
        Day wink = this.min;
        while (wink.compareTo(this.max) <= 0) {
            double startingY = this.getFullHeaderHeight();
            if (!wink.monthYear().equals(last)) {
                startingY = 0.0;
                last = wink.monthYear();
            }
            this.drawVbar(ug, this.getTimeScale().getStartingPosition(wink), startingY, totalHeight);
            wink = wink.increment();
        }
    }

    private void printMonth(UGraphic ug, MonthYear monthYear, double start, double end) {
        TextBlock tiny = this.getTextBlock(monthYear.shortName(), 12, true, HColorUtils.BLACK);
        TextBlock small = this.getTextBlock(monthYear.longName(), 12, true, HColorUtils.BLACK);
        TextBlock big = this.getTextBlock(monthYear.longNameYYYY(), 12, true, HColorUtils.BLACK);
        this.printCentered(ug, start, end, tiny, small, big);
    }

    private void drawVbar(UGraphic ug, double x, double y1, double y2) {
        ULine vbar = ULine.vline(y2 - y1);
        ug.apply(HColorUtils.LIGHT_GRAY).apply(new UTranslate(x, y1)).draw(vbar);
    }

    private void printNamedDays(UGraphic ug) {
        if (this.nameDays.size() > 0) {
            String last = null;
            Day wink = this.min;
            while (wink.compareTo(this.max.increment()) <= 0) {
                String name = this.nameDays.get(wink);
                if (name != null && !name.equals(last)) {
                    double x1 = this.getTimeScale().getStartingPosition(wink);
                    double x2 = this.getTimeScale().getEndingPosition(wink);
                    TextBlock label = this.getTextBlock(name, 12, false, HColorUtils.BLACK);
                    double h = label.calculateDimension(ug.getStringBounder()).getHeight();
                    double y1 = this.getTimeHeaderHeight();
                    double y2 = this.getFullHeaderHeight();
                    label.drawU(ug.apply(new UTranslate(x1, 39.0)));
                }
                last = name;
                wink = wink.increment();
            }
        }
    }

    @Override
    public double getFullHeaderHeight() {
        return this.getTimeHeaderHeight() + this.getHeaderNameDayHeight();
    }

    private double getHeaderNameDayHeight() {
        if (this.nameDays.size() > 0) {
            return 16.0;
        }
        return 0.0;
    }
}

