/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.facet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.IntFunction;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.PriorityQueue;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.facet.AggValueSource;
import org.apache.solr.search.facet.FacetContext;
import org.apache.solr.search.facet.FacetDebugInfo;
import org.apache.solr.search.facet.FacetField;
import org.apache.solr.search.facet.FacetProcessor;
import org.apache.solr.search.facet.FacetRequest;
import org.apache.solr.search.facet.HLLAgg;
import org.apache.solr.search.facet.SlotAcc;

abstract class FacetFieldProcessor
extends FacetProcessor<FacetField> {
    SchemaField sf;
    SlotAcc indexOrderAcc;
    int effectiveMincount;
    final boolean singlePassSlotAccCollection;
    final FacetRequest.FacetSort sort;
    final FacetRequest.FacetSort resort;
    final Map<String, AggValueSource> deferredAggs = new HashMap<String, AggValueSource>();
    SlotAcc collectAcc;
    SlotAcc sortAcc;
    SlotAcc[] otherAccs;
    SpecialSlotAcc allBucketsAcc;
    private static final SlotAcc.SlotContext ALL_BUCKETS_SLOT_CONTEXT = new SlotAcc.SlotContext(null){

        @Override
        public Query getSlotQuery() {
            throw new IllegalStateException("getSlotQuery() is mutually exclusive with isAllBuckets==true");
        }

        @Override
        public boolean isAllBuckets() {
            return true;
        }
    };
    private static final IntFunction<SlotAcc.SlotContext> ALL_BUCKETS_SLOT_FUNCTION = new IntFunction<SlotAcc.SlotContext>(){

        @Override
        public SlotAcc.SlotContext apply(int value) {
            return ALL_BUCKETS_SLOT_CONTEXT;
        }
    };

    FacetFieldProcessor(FacetContext fcontext, FacetField freq, SchemaField sf) {
        super(fcontext, freq);
        this.sf = sf;
        this.effectiveMincount = (int)(fcontext.isShard() ? Math.min(1L, freq.mincount) : freq.mincount);
        boolean bl = this.singlePassSlotAccCollection = freq.limit == -1L && freq.subFacets.size() == 0;
        if (null == freq.prelim_sort) {
            this.sort = freq.sort;
            this.resort = null;
        } else {
            assert (null != freq.prelim_sort);
            if (fcontext.isShard()) {
                this.sort = freq.prelim_sort;
                this.resort = null;
            } else if (this.singlePassSlotAccCollection) {
                this.sort = freq.sort;
                this.resort = null;
            } else {
                this.sort = freq.prelim_sort;
                this.resort = freq.sort;
            }
        }
        assert (null != this.sort);
    }

    @Override
    protected void createAccs(int docCount, int slotCount) throws IOException {
        if (this.accMap == null) {
            this.accMap = new LinkedHashMap();
        }
        if (this.countAcc == null) {
            this.countAcc = new SlotAcc.CountSlotArrAcc(this.fcontext, slotCount);
            this.countAcc.key = "count";
        }
        if (this.accs != null) {
            for (SlotAcc acc : this.accs) {
                acc.reset();
                acc.resize(new FlatteningResizer(slotCount));
            }
            return;
        }
        this.accs = new SlotAcc[((FacetField)this.freq).getFacetStats().size()];
        int accIdx = 0;
        for (Map.Entry<String, AggValueSource> entry : ((FacetField)this.freq).getFacetStats().entrySet()) {
            SlotAcc acc = null;
            if (slotCount == 1 && (acc = (SlotAcc)this.accMap.get(entry.getKey())) != null) {
                acc.reset();
            }
            if (acc == null) {
                acc = entry.getValue().createSlotAcc(this.fcontext, docCount, slotCount);
                acc.key = entry.getKey();
                this.accMap.put(acc.key, acc);
            }
            this.accs[accIdx++] = acc;
        }
    }

    private SlotAcc getTrivialSortingSlotAcc(FacetRequest.FacetSort fsort) {
        if ("count".equals(fsort.sortVariable)) {
            assert (null != this.countAcc);
            return this.countAcc;
        }
        if ("index".equals(fsort.sortVariable)) {
            if (this.indexOrderAcc == null) {
                this.indexOrderAcc = new SlotAcc.SortSlotAcc(this.fcontext);
            }
            return this.indexOrderAcc;
        }
        return null;
    }

    void createCollectAcc(int numDocs, int numSlots) throws IOException {
        this.accMap = new LinkedHashMap();
        this.deferredAggs.putAll(((FacetField)this.freq).getFacetStats());
        if (this.countAcc == null) {
            this.countAcc = new SlotAcc.CountSlotArrAcc(this.fcontext, numSlots);
        }
        this.sortAcc = this.getTrivialSortingSlotAcc(this.sort);
        if (this.singlePassSlotAccCollection) {
            this.accs = new SlotAcc[((FacetField)this.freq).getFacetStats().size()];
            int otherAccIdx = 0;
            for (Map.Entry<String, AggValueSource> entry : ((FacetField)this.freq).getFacetStats().entrySet()) {
                AggValueSource agg = entry.getValue();
                SlotAcc acc = agg.createSlotAcc(this.fcontext, numDocs, numSlots);
                acc.key = entry.getKey();
                this.accMap.put(acc.key, acc);
                this.accs[otherAccIdx++] = acc;
            }
            this.collectAcc = this.accs.length == 1 ? this.accs[0] : new MultiAcc(this.fcontext, this.accs);
            if (this.sortAcc == null) {
                this.sortAcc = (SlotAcc)this.accMap.get(this.sort.sortVariable);
                assert (this.sortAcc != null);
            }
            this.deferredAggs.clear();
        }
        if (this.sortAcc == null) {
            AggValueSource sortAgg = ((FacetField)this.freq).getFacetStats().get(this.sort.sortVariable);
            if (sortAgg != null) {
                this.collectAcc = sortAgg.createSlotAcc(this.fcontext, numDocs, numSlots);
                this.collectAcc.key = this.sort.sortVariable;
            }
            this.sortAcc = this.collectAcc;
            this.deferredAggs.remove(this.sort.sortVariable);
        }
        boolean needOtherAccs = ((FacetField)this.freq).allBuckets;
        if (this.sortAcc == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid sort '" + this.sort + "' for field '" + this.sf.getName() + "'");
        }
        if (!needOtherAccs) {
            return;
        }
        this.createOtherAccs(numDocs, 1);
    }

    private void createOtherAccs(int numDocs, int numSlots) throws IOException {
        if (this.otherAccs != null) {
            for (SlotAcc acc : this.otherAccs) {
                acc.reset();
            }
            return;
        }
        int numDeferred = this.deferredAggs.size();
        if (numDeferred <= 0) {
            return;
        }
        this.otherAccs = new SlotAcc[numDeferred];
        int otherAccIdx = 0;
        for (Map.Entry<String, AggValueSource> entry : this.deferredAggs.entrySet()) {
            AggValueSource agg = entry.getValue();
            SlotAcc acc = agg.createSlotAcc(this.fcontext, numDocs, numSlots);
            acc.key = entry.getKey();
            this.accMap.put(acc.key, acc);
            this.otherAccs[otherAccIdx++] = acc;
        }
        if (numDeferred == ((FacetField)this.freq).getFacetStats().size()) {
            this.accs = this.otherAccs;
        }
    }

    int collectFirstPhase(DocSet docs, int slot, IntFunction<SlotAcc.SlotContext> slotContext) throws IOException {
        int num = -1;
        if (this.collectAcc != null) {
            num = this.collectAcc.collect(docs, slot, slotContext);
        }
        if (this.allBucketsAcc != null) {
            num = this.allBucketsAcc.collect(docs, slot, slotContext);
        }
        return num >= 0 ? num : docs.size();
    }

    void collectFirstPhase(int segDoc, int slot, IntFunction<SlotAcc.SlotContext> slotContext) throws IOException {
        if (this.collectAcc != null) {
            this.collectAcc.collect(segDoc, slot, slotContext);
        }
        if (this.allBucketsAcc != null) {
            this.allBucketsAcc.collect(segDoc, slot, slotContext);
        }
    }

    SimpleOrderedMap<Object> findTopSlots(int numSlots, int slotCardinality, IntFunction<Comparable> bucketValFromSlotNumFunc, Function<Comparable, String> fieldQueryValFunc) throws IOException {
        boolean needFilter;
        FacetDebugInfo fdebug;
        assert (this.sortAcc != null);
        int numBuckets = 0;
        int off = this.fcontext.isShard() ? 0 : (int)((FacetField)this.freq).offset;
        long effectiveLimit = Integer.MAX_VALUE;
        if (((FacetField)this.freq).limit >= 0L) {
            effectiveLimit = ((FacetField)this.freq).limit;
            if (this.fcontext.isShard()) {
                if (((FacetField)this.freq).overrequest == -1) {
                    if (((FacetField)this.freq).offset < 10L) {
                        effectiveLimit = (long)((double)effectiveLimit * 1.1 + 4.0);
                    }
                } else {
                    effectiveLimit += (long)((FacetField)this.freq).overrequest;
                }
            } else if (null != this.resort && 0 < ((FacetField)this.freq).overrequest) {
                effectiveLimit += (long)((FacetField)this.freq).overrequest;
            }
        }
        int sortMul = this.sort.sortDirection.getMultiplier();
        int maxTopVals = (int)(effectiveLimit >= 0L ? Math.min(((FacetField)this.freq).offset + effectiveLimit, 0x7FFFFFFEL) : 0x7FFFFFFEL);
        maxTopVals = Math.min(maxTopVals, slotCardinality);
        SlotAcc sortAcc = this.sortAcc;
        SlotAcc indexOrderAcc = this.indexOrderAcc;
        final BiPredicate<Slot, Slot> orderPredicate = indexOrderAcc != null && indexOrderAcc != sortAcc ? (a, b) -> {
            int cmp = sortAcc.compare(a.slot, b.slot) * sortMul;
            return cmp == 0 ? indexOrderAcc.compare(a.slot, b.slot) > 0 : cmp < 0;
        } : (a, b) -> {
            int cmp = sortAcc.compare(a.slot, b.slot) * sortMul;
            return cmp == 0 ? b.slot < a.slot : cmp < 0;
        };
        PriorityQueue<Slot> queue = new PriorityQueue<Slot>(maxTopVals){

            protected boolean lessThan(Slot a, Slot b) {
                return orderPredicate.test(a, b);
            }
        };
        Slot bottom = null;
        Slot scratchSlot = new Slot();
        boolean shardHasMoreBuckets = false;
        for (int slotNum = 0; slotNum < numSlots; ++slotNum) {
            int count;
            if (this.effectiveMincount > 0 && (count = this.countAcc.getCount(slotNum)) < this.effectiveMincount) {
                if (count <= 0) continue;
                ++numBuckets;
                continue;
            }
            ++numBuckets;
            if (bottom != null) {
                shardHasMoreBuckets = true;
                scratchSlot.slot = slotNum;
                if (!orderPredicate.test(bottom, scratchSlot)) continue;
                bottom.slot = slotNum;
                bottom = (Slot)queue.updateTop();
                continue;
            }
            if (effectiveLimit <= 0L) continue;
            Slot s = new Slot();
            s.slot = slotNum;
            queue.add((Object)s);
            if (queue.size() < maxTopVals) continue;
            bottom = (Slot)queue.top();
        }
        assert (queue.size() <= numBuckets);
        SimpleOrderedMap res = new SimpleOrderedMap();
        if (((FacetField)this.freq).numBuckets) {
            if (!this.fcontext.isShard()) {
                res.add("numBuckets", (Object)numBuckets);
            } else {
                this.calculateNumBuckets((SimpleOrderedMap<Object>)res);
            }
        }
        if ((fdebug = this.fcontext.getDebugInfo()) != null) {
            fdebug.putInfoItem("numBuckets", numBuckets);
        }
        if (((FacetField)this.freq).allBuckets) {
            SimpleOrderedMap allBuckets = new SimpleOrderedMap();
            allBuckets.add("count", (Object)this.allBucketsAcc.getSpecialCount());
            this.allBucketsAcc.setValues((SimpleOrderedMap<Object>)allBuckets, -1);
            res.add("allBuckets", (Object)allBuckets);
        }
        SimpleOrderedMap missingBucket = new SimpleOrderedMap();
        if (((FacetField)this.freq).missing) {
            res.add("missing", (Object)missingBucket);
        }
        boolean bl = needFilter = !this.deferredAggs.isEmpty() || ((FacetField)this.freq).getSubFacets().size() > 0;
        if (needFilter) {
            this.createOtherAccs(-1, 1);
        }
        int collectCount = Math.max(0, queue.size() - (null == this.resort ? off : 0));
        assert (collectCount <= maxTopVals);
        Slot[] sortedSlots = new Slot[collectCount];
        for (int i = collectCount - 1; i >= 0; --i) {
            Slot slot = sortedSlots[i] = (Slot)queue.pop();
            slot.bucketVal = bucketValFromSlotNumFunc.apply(slot.slot);
            if (!needFilter && null == this.resort) continue;
            slot.bucketFilter = this.makeBucketQuery(fieldQueryValFunc.apply(slot.bucketVal));
        }
        SlotAcc resortAccForFill = this.resortSlots(sortedSlots);
        if (null != this.resort) {
            int endOffset = (int)Math.min((long)sortedSlots.length, (long)off + (((FacetField)this.freq).limit < 0L ? Integer.MAX_VALUE : ((FacetField)this.freq).limit));
            if (0 < off || endOffset < sortedSlots.length) {
                sortedSlots = Arrays.copyOfRange(sortedSlots, off, endOffset);
            }
        }
        ArrayList<SimpleOrderedMap> bucketList = new ArrayList<SimpleOrderedMap>(sortedSlots.length);
        for (Slot slot : sortedSlots) {
            SimpleOrderedMap bucket = new SimpleOrderedMap();
            bucket.add("val", (Object)slot.bucketVal);
            this.fillBucketFromSlot((SimpleOrderedMap<Object>)bucket, slot, resortAccForFill);
            bucketList.add(bucket);
        }
        res.add("buckets", bucketList);
        if (this.fcontext.isShard() && shardHasMoreBuckets) {
            res.add("more", (Object)true);
        }
        if (((FacetField)this.freq).missing) {
            this.fillBucket((SimpleOrderedMap<Object>)missingBucket, FacetFieldProcessor.getFieldMissingQuery(this.fcontext.searcher, ((FacetField)this.freq).field), null, false, null);
        }
        return res;
    }

    protected Query makeBucketQuery(String bucketValue) {
        return this.sf.getType().getFieldQuery(null, this.sf, bucketValue);
    }

    private void calculateNumBuckets(SimpleOrderedMap<Object> target) throws IOException {
        DocSet domain = this.fcontext.base;
        if (((FacetField)this.freq).prefix != null) {
            Query prefixFilter = this.sf.getType().getPrefixQuery(null, this.sf, ((FacetField)this.freq).prefix);
            domain = this.fcontext.searcher.getDocSet(prefixFilter, domain);
        }
        HLLAgg agg = new HLLAgg(((FacetField)this.freq).field);
        SlotAcc acc = agg.createSlotAcc(this.fcontext, domain.size(), 1);
        acc.collect(domain, 0, null);
        acc.key = "numBuckets";
        acc.setValues(target, 0);
    }

    private void fillBucketFromSlot(SimpleOrderedMap<Object> target, Slot slot, SlotAcc resortAcc) throws IOException {
        int count = this.countAcc.getCount(slot.slot);
        target.add("count", (Object)count);
        if (count <= 0 && !((FacetField)this.freq).processEmpty) {
            return;
        }
        if (this.collectAcc != null && slot.slot >= 0) {
            this.collectAcc.setValues(target, slot.slot);
        }
        if (this.otherAccs == null && ((FacetField)this.freq).subFacets.isEmpty()) {
            return;
        }
        assert (null != slot.bucketFilter);
        Query filter = slot.bucketFilter;
        DocSet subDomain = this.fcontext.searcher.getDocSet(filter, this.fcontext.base);
        if (this.otherAccs != null) {
            for (SlotAcc acc : this.otherAccs) {
                if (acc == resortAcc) {
                    acc.setValues(target, slot.resortSlotNum);
                    continue;
                }
                acc.reset();
                acc.collect(subDomain, 0, (int s) -> new SlotAcc.SlotContext(filter));
                acc.setValues(target, 0);
            }
        }
        this.processSubs(target, filter, subDomain, false, null);
    }

    private SlotAcc resortSlots(Slot[] slots) throws IOException {
        if (null == this.resort) {
            return null;
        }
        assert (!this.fcontext.isShard());
        final int resortMul = -1 * this.resort.sortDirection.getMultiplier();
        SlotAcc resortAcc = this.getTrivialSortingSlotAcc(this.resort);
        if (null != resortAcc) {
            if (resortAcc.equals(this.countAcc)) {
                Comparator<Slot> comparator = null != this.indexOrderAcc ? new Comparator<Slot>(){

                    @Override
                    public int compare(Slot x, Slot y) {
                        int cmp = resortMul * FacetFieldProcessor.this.countAcc.compare(x.slot, y.slot);
                        return cmp != 0 ? cmp : FacetFieldProcessor.this.indexOrderAcc.compare(x.slot, y.slot);
                    }
                } : new Comparator<Slot>(){

                    @Override
                    public int compare(Slot x, Slot y) {
                        int cmp = resortMul * FacetFieldProcessor.this.countAcc.compare(x.slot, y.slot);
                        return cmp != 0 ? cmp : Integer.compare(x.slot, y.slot);
                    }
                };
                Arrays.sort(slots, comparator);
                return null;
            }
            if (resortAcc.equals(this.indexOrderAcc)) {
                Arrays.sort(slots, new Comparator<Slot>(){

                    @Override
                    public int compare(Slot x, Slot y) {
                        return resortMul * FacetFieldProcessor.this.indexOrderAcc.compare(x.slot, y.slot);
                    }
                });
                return null;
            }
            assert (false) : "trivial resort isn't count or index: " + this.resort;
        }
        assert (null == resortAcc);
        for (SlotAcc acc : this.otherAccs) {
            if (!acc.key.equals(this.resort.sortVariable)) continue;
            resortAcc = acc;
            break;
        }
        assert (null != resortAcc);
        final SlotAcc acc = resortAcc;
        acc.reset();
        acc.resize(new FlatteningResizer(slots.length));
        for (int slotNum = 0; slotNum < slots.length; ++slotNum) {
            Slot slot = slots[slotNum];
            slot.resortSlotNum = slotNum;
            assert (null != slot.bucketFilter) : "null filter for slot=" + slot.bucketVal;
            DocSet subDomain = this.fcontext.searcher.getDocSet(slot.bucketFilter, this.fcontext.base);
            acc.collect(subDomain, slotNum, (int s) -> new SlotAcc.SlotContext(slot.bucketFilter));
        }
        Comparator<Slot> comparator = null != this.indexOrderAcc ? new Comparator<Slot>(){

            @Override
            public int compare(Slot x, Slot y) {
                int cmp = resortMul * acc.compare(x.resortSlotNum, y.resortSlotNum);
                return cmp != 0 ? cmp : FacetFieldProcessor.this.indexOrderAcc.compare(x.slot, y.slot);
            }
        } : new Comparator<Slot>(){

            @Override
            public int compare(Slot x, Slot y) {
                int cmp = resortMul * acc.compare(x.resortSlotNum, y.resortSlotNum);
                return cmp != 0 ? cmp : Integer.compare(x.slot, y.slot);
            }
        };
        Arrays.sort(slots, comparator);
        return acc;
    }

    @Override
    protected void processStats(SimpleOrderedMap<Object> bucket, Query bucketQ, DocSet docs, int docCount) throws IOException {
        if (docCount == 0 && !((FacetField)this.freq).processEmpty || ((FacetField)this.freq).getFacetStats().size() == 0) {
            bucket.add("count", (Object)docCount);
            return;
        }
        this.createAccs(docCount, 1);
        assert (null != bucketQ);
        int collected = this.collect(docs, 0, (int slotNum) -> new SlotAcc.SlotContext(bucketQ));
        assert (collected == docCount);
        this.addStats(bucket, collected, 0);
    }

    private void addStats(SimpleOrderedMap<Object> target, int count, int slotNum) throws IOException {
        target.add("count", (Object)count);
        if (count > 0 || ((FacetField)this.freq).processEmpty) {
            for (SlotAcc acc : this.accs) {
                acc.setValues(target, slotNum);
            }
        }
    }

    @Override
    void setNextReader(LeafReaderContext ctx) throws IOException {
        super.setNextReader(ctx);
    }

    void setNextReaderFirstPhase(LeafReaderContext ctx) throws IOException {
        if (this.collectAcc != null) {
            this.collectAcc.setNextReader(ctx);
        }
        if (this.otherAccs != null) {
            for (SlotAcc acc : this.otherAccs) {
                acc.setNextReader(ctx);
            }
        }
    }

    static <T> List<T> asList(Object list) {
        return list != null ? (List)list : Collections.EMPTY_LIST;
    }

    protected SimpleOrderedMap<Object> refineFacets() throws IOException {
        Map bucketFacetInfo;
        Map facetInfo;
        Object bucketVal;
        boolean skipThisFacet = (this.fcontext.flags & 4) != 0;
        List leaves = FacetFieldProcessor.asList(this.fcontext.facetInfo.get("_l"));
        List<List> skip = FacetFieldProcessor.asList(this.fcontext.facetInfo.get("_s"));
        List<List> partial = FacetFieldProcessor.asList(this.fcontext.facetInfo.get("_p"));
        SimpleOrderedMap res = new SimpleOrderedMap();
        ArrayList<SimpleOrderedMap<Object>> bucketList = new ArrayList<SimpleOrderedMap<Object>>(leaves.size() + skip.size() + partial.size());
        res.add("buckets", bucketList);
        this.createAccs(-1, 1);
        for (Object bucketVal2 : leaves) {
            bucketList.add(this.refineBucket(bucketVal2, false, null));
        }
        for (List bucketAndFacetInfo : skip) {
            assert (bucketAndFacetInfo.size() == 2);
            bucketVal = bucketAndFacetInfo.get(0);
            facetInfo = (Map)bucketAndFacetInfo.get(1);
            bucketList.add(this.refineBucket(bucketVal, true, facetInfo));
        }
        for (List bucketAndFacetInfo : partial) {
            assert (bucketAndFacetInfo.size() == 2);
            bucketVal = bucketAndFacetInfo.get(0);
            facetInfo = (Map)bucketAndFacetInfo.get(1);
            bucketList.add(this.refineBucket(bucketVal, false, facetInfo));
        }
        if (((FacetField)this.freq).missing && ((bucketFacetInfo = (Map)this.fcontext.facetInfo.get("missing")) != null || !skipThisFacet)) {
            SimpleOrderedMap missingBucket = new SimpleOrderedMap();
            this.fillBucket((SimpleOrderedMap<Object>)missingBucket, FacetFieldProcessor.getFieldMissingQuery(this.fcontext.searcher, ((FacetField)this.freq).field), null, skipThisFacet, bucketFacetInfo);
            res.add("missing", (Object)missingBucket);
        }
        if (((FacetField)this.freq).numBuckets && !skipThisFacet) {
            this.calculateNumBuckets((SimpleOrderedMap<Object>)res);
        }
        return res;
    }

    private SimpleOrderedMap<Object> refineBucket(Object bucketVal, boolean skip, Map<String, Object> facetInfo) throws IOException {
        SimpleOrderedMap bucket = new SimpleOrderedMap();
        FieldType ft = this.sf.getType();
        bucketVal = ft.toNativeType(bucketVal);
        bucket.add("val", bucketVal);
        String bucketStr = bucketVal instanceof Date ? ((Date)bucketVal).toInstant().toString() : bucketVal.toString();
        Query domainQ = ft.getFieldQuery(null, this.sf, bucketStr);
        this.fillBucket((SimpleOrderedMap<Object>)bucket, domainQ, null, skip, facetInfo);
        return bucket;
    }

    private static final class FlatteningResizer
    extends SlotAcc.Resizer {
        private final int slotCount;

        public FlatteningResizer(int slotCount) {
            this.slotCount = slotCount;
        }

        @Override
        public int getNewSize() {
            return this.slotCount;
        }

        @Override
        public int getNewSlot(int oldSlot) {
            return 0;
        }
    }

    static class MultiAcc
    extends SlotAcc {
        final SlotAcc[] subAccs;

        MultiAcc(FacetContext fcontext, SlotAcc[] subAccs) {
            super(fcontext);
            this.subAccs = subAccs;
        }

        @Override
        public void setNextReader(LeafReaderContext ctx) throws IOException {
            for (SlotAcc acc : this.subAccs) {
                acc.setNextReader(ctx);
            }
        }

        @Override
        public void collect(int doc, int slot, IntFunction<SlotAcc.SlotContext> slotContext) throws IOException {
            for (SlotAcc acc : this.subAccs) {
                acc.collect(doc, slot, slotContext);
            }
        }

        @Override
        public int compare(int slotA, int slotB) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object getValue(int slotNum) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void reset() throws IOException {
            for (SlotAcc acc : this.subAccs) {
                acc.reset();
            }
        }

        @Override
        public void resize(SlotAcc.Resizer resizer) {
            for (SlotAcc acc : this.subAccs) {
                acc.resize(resizer);
            }
        }

        @Override
        public void setValues(SimpleOrderedMap<Object> bucket, int slotNum) throws IOException {
            for (SlotAcc acc : this.subAccs) {
                acc.setValues(bucket, slotNum);
            }
        }
    }

    static class SpecialSlotAcc
    extends SlotAcc {
        SlotAcc collectAcc;
        SlotAcc[] otherAccs;
        int collectAccSlot;
        int otherAccsSlot;
        long count;

        SpecialSlotAcc(FacetContext fcontext, SlotAcc collectAcc, int collectAccSlot, SlotAcc[] otherAccs, int otherAccsSlot) {
            super(fcontext);
            this.collectAcc = collectAcc;
            this.collectAccSlot = collectAccSlot;
            this.otherAccs = otherAccs;
            this.otherAccsSlot = otherAccsSlot;
        }

        public int getCollectAccSlot() {
            return this.collectAccSlot;
        }

        public int getOtherAccSlot() {
            return this.otherAccsSlot;
        }

        long getSpecialCount() {
            return this.count;
        }

        @Override
        public void collect(int doc, int slot, IntFunction<SlotAcc.SlotContext> slotContext) throws IOException {
            assert (slot != this.collectAccSlot || slot < 0);
            ++this.count;
            if (this.collectAcc != null) {
                this.collectAcc.collect(doc, this.collectAccSlot, (IntFunction<SlotAcc.SlotContext>)ALL_BUCKETS_SLOT_FUNCTION);
            }
            if (this.otherAccs != null) {
                for (SlotAcc otherAcc : this.otherAccs) {
                    otherAcc.collect(doc, this.otherAccsSlot, (IntFunction<SlotAcc.SlotContext>)ALL_BUCKETS_SLOT_FUNCTION);
                }
            }
        }

        @Override
        public void setNextReader(LeafReaderContext readerContext) throws IOException {
            if (this.collectAcc != null) {
                this.collectAcc.setNextReader(readerContext);
            }
            if (this.otherAccs != null) {
                for (SlotAcc otherAcc : this.otherAccs) {
                    otherAcc.setNextReader(readerContext);
                }
            }
        }

        @Override
        public int compare(int slotA, int slotB) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object getValue(int slotNum) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setValues(SimpleOrderedMap<Object> bucket, int slotNum) throws IOException {
            if (this.collectAcc != null) {
                this.collectAcc.setValues(bucket, this.collectAccSlot);
            }
            if (this.otherAccs != null) {
                for (SlotAcc otherAcc : this.otherAccs) {
                    otherAcc.setValues(bucket, this.otherAccsSlot);
                }
            }
        }

        @Override
        public void reset() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void resize(SlotAcc.Resizer resizer) {
            if (this.collectAccSlot >= 0) {
                this.collectAccSlot = resizer.getNewSlot(this.collectAccSlot);
            }
        }
    }

    private static class Slot {
        int slot;
        Comparable bucketVal;
        Query bucketFilter;
        int resortSlotNum;

        private Slot() {
        }
    }
}

