/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function;

import javax.swing.JOptionPane;
import tim.prune.App;
import tim.prune.GenericFunction;
import tim.prune.I18nManager;
import tim.prune.data.AudioClip;
import tim.prune.undo.UndoDeleteAudio;

public class RemoveAudioFunction
extends GenericFunction {
    public RemoveAudioFunction(App app) {
        super(app);
    }

    @Override
    public String getNameKey() {
        return "function.removeaudio";
    }

    @Override
    public void begin() {
        AudioClip audioClip = this._app.getTrackInfo().getCurrentAudio();
        if (audioClip != null) {
            boolean bl = false;
            UndoDeleteAudio undoDeleteAudio = null;
            if (audioClip.getDataPoint() == null) {
                undoDeleteAudio = new UndoDeleteAudio(audioClip, this._app.getTrackInfo().getSelection().getCurrentAudioIndex(), null, -1);
                bl = this._app.getTrackInfo().deleteCurrentAudio(false);
            } else {
                boolean bl2;
                int n = this._app.getTrackInfo().getTrack().getPointIndex(audioClip.getDataPoint());
                undoDeleteAudio = new UndoDeleteAudio(audioClip, this._app.getTrackInfo().getSelection().getCurrentAudioIndex(), audioClip.getDataPoint(), n);
                undoDeleteAudio.setAtBoundaryOfSelectedRange(n == this._app.getTrackInfo().getSelection().getStart() || n == this._app.getTrackInfo().getSelection().getEnd());
                int n2 = JOptionPane.showConfirmDialog(this._app.getFrame(), I18nManager.getText("dialog.deleteaudio.deletepoint"), I18nManager.getText(this.getNameKey()), 1);
                boolean bl3 = bl2 = n2 == 0;
                if (n2 == 0 || n2 == 1) {
                    bl = this._app.getTrackInfo().deleteCurrentAudio(bl2);
                }
            }
            if (bl) {
                this._app.completeFunction(undoDeleteAudio, String.valueOf(audioClip.getName()) + " " + I18nManager.getText("confirm.media.removed"));
            }
        }
    }
}

