/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.ast;

import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.inject.ast.ConstructorElement;
import io.micronaut.inject.ast.ElementModifier;
import io.micronaut.inject.ast.EnumElement;
import io.micronaut.inject.ast.FieldElement;
import io.micronaut.inject.ast.PropertyElement;
import io.micronaut.inject.ast.TypedElement;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;

public interface ClassElement
extends TypedElement {
    public boolean isAssignable(String var1);

    default public boolean isEnum() {
        return this instanceof EnumElement;
    }

    @Nonnull
    default public Optional<ConstructorElement> getPrimaryConstructor() {
        return Optional.empty();
    }

    default public boolean hasDefaultConstructor() {
        return false;
    }

    default public Optional<ClassElement> getSuperType() {
        return Optional.empty();
    }

    @Override
    @Nonnull
    default public ClassElement getType() {
        return this;
    }

    @Override
    default public String getSimpleName() {
        return NameUtils.getSimpleName((String)this.getName());
    }

    default public String getPackageName() {
        return NameUtils.getPackageName((String)this.getName());
    }

    default public List<PropertyElement> getBeanProperties() {
        return Collections.emptyList();
    }

    default public List<FieldElement> getFields() {
        return this.getFields(modifiers -> true);
    }

    default public List<FieldElement> getFields(@Nonnull Predicate<Set<ElementModifier>> modifierFilter) {
        return Collections.emptyList();
    }

    @Override
    default public boolean isAbstract() {
        return false;
    }

    default public boolean isInterface() {
        return false;
    }

    @Override
    default public boolean isArray() {
        return false;
    }

    default public boolean isIterable() {
        return this.isArray() || this.isAssignable(Iterable.class);
    }

    @Nonnull
    default public Map<String, ClassElement> getTypeArguments(@Nonnull String type) {
        return Collections.emptyMap();
    }

    @Nonnull
    default public Map<String, ClassElement> getTypeArguments(@Nonnull Class<?> type) {
        ArgumentUtils.requireNonNull((String)"type", type);
        return this.getTypeArguments(type.getName());
    }

    @Nonnull
    default public Map<String, ClassElement> getTypeArguments() {
        return Collections.emptyMap();
    }

    default public Optional<ClassElement> getFirstTypeArgument() {
        return this.getTypeArguments().values().stream().findFirst();
    }

    default public boolean isAssignable(Class<?> type) {
        return this.isAssignable(type.getName());
    }
}

