# -*- coding: utf-8 -*-
info = {
    "name": "ar",
    "date_order": "DMY",
    "january": [
        "يناير"
    ],
    "february": [
        "فبراير"
    ],
    "march": [
        "مارس"
    ],
    "april": [
        "أبريل"
    ],
    "may": [
        "مايو"
    ],
    "june": [
        "يونيو"
    ],
    "july": [
        "يوليو"
    ],
    "august": [
        "أغسطس"
    ],
    "september": [
        "سبتمبر"
    ],
    "october": [
        "أكتوبر"
    ],
    "november": [
        "نوفمبر"
    ],
    "december": [
        "ديسمبر"
    ],
    "monday": [
        "الاثنين",
        "الإثنين"
    ],
    "tuesday": [
        "الثلاثاء"
    ],
    "wednesday": [
        "الأربعاء"
    ],
    "thursday": [
        "الخميس"
    ],
    "friday": [
        "الجمعة"
    ],
    "saturday": [
        "السبت"
    ],
    "sunday": [
        "الأحد"
    ],
    "am": [
        "صباحًا",
        "ص",
        "صباحاً"
    ],
    "pm": [
        "مساءً",
        "م"
    ],
    "year": [
        "السنة",
        "عام",
        "سنة"
    ],
    "month": [
        "الشهر",
        "شهر"
    ],
    "week": [
        "الأسبوع",
        "أسبوع"
    ],
    "day": [
        "يوم",
        "أيام"
    ],
    "hour": [
        "الساعات",
        "ساعة",
        "ساعات"
    ],
    "minute": [
        "الدقائق",
        "دقيقة",
        "دقائق"
    ],
    "second": [
        "الثواني",
        "ثانية"
    ],
    "relative-type": {
        "1 year ago": [
            "السنة الماضية"
        ],
        "0 year ago": [
            "السنة الحالية"
        ],
        "in 1 year": [
            "السنة القادمة"
        ],
        "1 month ago": [
            "الشهر الماضي"
        ],
        "0 month ago": [
            "هذا الشهر"
        ],
        "in 1 month": [
            "الشهر القادم"
        ],
        "1 week ago": [
            "الأسبوع الماضي"
        ],
        "0 week ago": [
            "هذا الأسبوع"
        ],
        "in 1 week": [
            "الأسبوع القادم"
        ],
        "1 day ago": [
            "أمس",
            "اليوم السابق",
            "الأمس"
        ],
        "0 day ago": [
            "اليوم"
        ],
        "in 1 day": [
            "غدًا"
        ],
        "0 hour ago": [
            "الساعة الحالية"
        ],
        "0 minute ago": [
            "هذه الدقيقة"
        ],
        "0 second ago": [
            "الآن"
        ],
        "2 day": [
            "يومين"
        ],
        "2 hour": [
            "ساعتين"
        ],
        "1 hour ago": [
            "ساعة واحدة"
        ]
    },
    "relative-type-regex": {
        "in \\1 year": [
            "خلال (\\d+) سنة"
        ],
        "\\1 year ago": [
            "قبل (\\d+) سنة"
        ],
        "in \\1 month": [
            "خلال (\\d+) شهر"
        ],
        "\\1 month ago": [
            "قبل (\\d+) شهر"
        ],
        "in \\1 week": [
            "خلال (\\d+) أسبوع"
        ],
        "\\1 week ago": [
            "قبل (\\d+) أسبوع"
        ],
        "in \\1 day": [
            "خلال (\\d+) يوم"
        ],
        "\\1 day ago": [
            "قبل (\\d+) يوم"
        ],
        "in \\1 hour": [
            "خلال (\\d+) ساعة"
        ],
        "\\1 hour ago": [
            "قبل (\\d+) ساعة"
        ],
        "in \\1 minute": [
            "خلال (\\d+) دقيقة"
        ],
        "\\1 minute ago": [
            "قبل (\\d+) دقيقة"
        ],
        "in \\1 second": [
            "خلال (\\d+) ثانية"
        ],
        "\\1 second ago": [
            "قبل (\\d+) ثانية"
        ]
    },
    "locale_specific": {
        "ar-QA": {
            "name": "ar-QA"
        },
        "ar-SO": {
            "name": "ar-SO"
        },
        "ar-SY": {
            "name": "ar-SY",
            "january": [
                "كانون الثاني"
            ],
            "february": [
                "شباط"
            ],
            "march": [
                "آذار"
            ],
            "april": [
                "نيسان"
            ],
            "may": [
                "أيار"
            ],
            "june": [
                "حزيران"
            ],
            "july": [
                "تموز"
            ],
            "august": [
                "آب"
            ],
            "september": [
                "أيلول"
            ],
            "october": [
                "تشرين الأول"
            ],
            "november": [
                "تشرين الثاني"
            ],
            "december": [
                "كانون الأول"
            ]
        },
        "ar-IQ": {
            "name": "ar-IQ",
            "january": [
                "كانون الثاني"
            ],
            "february": [
                "شباط"
            ],
            "march": [
                "آذار"
            ],
            "april": [
                "نيسان"
            ],
            "may": [
                "أيار"
            ],
            "june": [
                "حزيران"
            ],
            "july": [
                "تموز"
            ],
            "august": [
                "آب"
            ],
            "september": [
                "أيلول"
            ],
            "october": [
                "تشرین الأول",
                "تشرين الأول"
            ],
            "november": [
                "تشرين الثاني"
            ],
            "december": [
                "كانون الأول"
            ]
        },
        "ar-DZ": {
            "name": "ar-DZ",
            "january": [
                "جانفي"
            ],
            "february": [
                "فيفري"
            ],
            "april": [
                "أفريل"
            ],
            "may": [
                "ماي"
            ],
            "june": [
                "جوان"
            ],
            "july": [
                "جويلية"
            ],
            "august": [
                "أوت"
            ]
        },
        "ar-TN": {
            "name": "ar-TN",
            "january": [
                "جانفي"
            ],
            "february": [
                "فيفري"
            ],
            "april": [
                "أفريل"
            ],
            "may": [
                "ماي"
            ],
            "june": [
                "جوان"
            ],
            "july": [
                "جويلية"
            ],
            "august": [
                "أوت"
            ]
        },
        "ar-EG": {
            "name": "ar-EG"
        },
        "ar-OM": {
            "name": "ar-OM"
        },
        "ar-LB": {
            "name": "ar-LB",
            "january": [
                "كانون الثاني"
            ],
            "february": [
                "شباط"
            ],
            "march": [
                "آذار"
            ],
            "april": [
                "نيسان"
            ],
            "may": [
                "أيار"
            ],
            "june": [
                "حزيران"
            ],
            "july": [
                "تموز"
            ],
            "august": [
                "آب"
            ],
            "september": [
                "أيلول"
            ],
            "october": [
                "تشرين الأول"
            ],
            "november": [
                "تشرين الثاني"
            ],
            "december": [
                "كانون الأول"
            ]
        },
        "ar-DJ": {
            "name": "ar-DJ"
        },
        "ar-MA": {
            "name": "ar-MA",
            "may": [
                "ماي"
            ],
            "july": [
                "يوليوز"
            ],
            "august": [
                "غشت"
            ],
            "september": [
                "شتنبر"
            ],
            "november": [
                "نونبر"
            ],
            "december": [
                "دجنبر"
            ]
        },
        "ar-MR": {
            "name": "ar-MR",
            "april": [
                "إبريل"
            ],
            "august": [
                "أغشت"
            ],
            "september": [
                "شتمبر"
            ],
            "december": [
                "دجمبر"
            ]
        },
        "ar-JO": {
            "name": "ar-JO",
            "january": [
                "كانون الثاني"
            ],
            "february": [
                "شباط"
            ],
            "march": [
                "آذار"
            ],
            "april": [
                "نيسان"
            ],
            "may": [
                "أيار"
            ],
            "june": [
                "حزيران"
            ],
            "july": [
                "تموز"
            ],
            "august": [
                "آب"
            ],
            "september": [
                "أيلول"
            ],
            "october": [
                "تشرين الأول"
            ],
            "november": [
                "تشرين الثاني"
            ],
            "december": [
                "كانون الأول"
            ]
        },
        "ar-TD": {
            "name": "ar-TD"
        },
        "ar-PS": {
            "name": "ar-PS",
            "january": [
                "كانون الثاني"
            ],
            "february": [
                "شباط"
            ],
            "march": [
                "آذار"
            ],
            "april": [
                "نيسان"
            ],
            "may": [
                "أيار"
            ],
            "june": [
                "حزيران"
            ],
            "july": [
                "تموز"
            ],
            "august": [
                "آب"
            ],
            "september": [
                "أيلول"
            ],
            "october": [
                "تشرين الأول"
            ],
            "november": [
                "تشرين الثاني"
            ],
            "december": [
                "كانون الأول"
            ]
        },
        "ar-AE": {
            "name": "ar-AE",
            "relative-type": {
                "0 year ago": [
                    "هذه السنة"
                ],
                "in 1 year": [
                    "السنة التالية"
                ]
            }
        },
        "ar-ER": {
            "name": "ar-ER"
        },
        "ar-SD": {
            "name": "ar-SD"
        },
        "ar-SS": {
            "name": "ar-SS"
        },
        "ar-KM": {
            "name": "ar-KM"
        },
        "ar-LY": {
            "name": "ar-LY"
        },
        "ar-YE": {
            "name": "ar-YE"
        },
        "ar-IL": {
            "name": "ar-IL"
        },
        "ar-EH": {
            "name": "ar-EH"
        },
        "ar-KW": {
            "name": "ar-KW"
        },
        "ar-SA": {
            "name": "ar-SA"
        },
        "ar-BH": {
            "name": "ar-BH"
        }
    },
    "sentence_splitter_group": 6,
    "skip": [
        "الساعة",
        "مساءً",
        "في",
        "هـ",
        " ",
        ".",
        ",",
        ";",
        "-",
        "/",
        "'",
        "|",
        "@",
        "[",
        "]",
        "，"
    ],
    "ago": [
        "منذ"
    ],
    "in": [
        "خلال"
    ]
}
