/*
 * Decompiled with CFR 0.152.
 */
package com.drew.imaging.quicktime;

import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.mov.QuickTimeDirectory;
import com.drew.metadata.mov.atoms.Atom;
import java.io.IOException;

public abstract class QuickTimeHandler<T extends QuickTimeDirectory> {
    @NotNull
    protected Metadata metadata;
    @NotNull
    protected T directory;

    public QuickTimeHandler(@NotNull Metadata metadata) {
        this.metadata = metadata;
        this.directory = this.getDirectory();
        metadata.addDirectory(this.directory);
    }

    @NotNull
    protected abstract T getDirectory();

    protected abstract boolean shouldAcceptAtom(@NotNull Atom var1);

    protected abstract boolean shouldAcceptContainer(@NotNull Atom var1);

    protected abstract QuickTimeHandler processAtom(@NotNull Atom var1, @Nullable byte[] var2) throws IOException;

    protected QuickTimeHandler processContainer(@NotNull Atom atom) throws IOException {
        return this.processAtom(atom, null);
    }

    public void addError(@NotNull String message) {
        ((Directory)this.directory).addError(message);
    }
}

