/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Properties;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.filters.util.ChainReaderHelper;
import org.apache.tools.ant.taskdefs.Property;
import org.apache.tools.ant.types.FilterChain;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.FileResource;
import org.apache.tools.ant.types.resources.JavaResource;
import org.apache.tools.ant.util.FileUtils;

public class LoadProperties
extends Task {
    private Resource src = null;
    private final Vector<FilterChain> filterChains = new Vector();
    private String encoding = null;
    private String prefix = null;
    private boolean prefixValues = true;

    public final void setSrcFile(File srcFile) {
        this.addConfigured(new FileResource(srcFile));
    }

    public void setResource(String resource) {
        this.getRequiredJavaResource().setName(resource);
    }

    public final void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setClasspath(Path classpath) {
        this.getRequiredJavaResource().setClasspath(classpath);
    }

    public Path createClasspath() {
        return this.getRequiredJavaResource().createClasspath();
    }

    public void setClasspathRef(Reference r) {
        this.getRequiredJavaResource().setClasspathRef(r);
    }

    public Path getClasspath() {
        return this.getRequiredJavaResource().getClasspath();
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setPrefixValues(boolean b) {
        this.prefixValues = b;
    }

    public final void execute() throws BuildException {
        if (this.src == null) {
            throw new BuildException("A source resource is required.");
        }
        if (!this.src.isExists()) {
            if (this.src instanceof JavaResource) {
                this.log("Unable to find resource " + this.src, 1);
                return;
            }
            throw new BuildException("Source resource does not exist: " + this.src);
        }
        BufferedInputStream bis = null;
        Reader instream = null;
        ByteArrayInputStream tis = null;
        try {
            bis = new BufferedInputStream(this.src.getInputStream());
            instream = this.encoding == null ? new InputStreamReader(bis) : new InputStreamReader((InputStream)bis, this.encoding);
            ChainReaderHelper crh = new ChainReaderHelper();
            crh.setPrimaryReader(instream);
            crh.setFilterChains(this.filterChains);
            crh.setProject(this.getProject());
            instream = crh.getAssembledReader();
            String text = crh.readFully(instream);
            if (text != null && text.length() != 0) {
                if (!text.endsWith("\n")) {
                    text = text + "\n";
                }
                tis = new ByteArrayInputStream(text.getBytes("ISO-8859-1"));
                Properties props = new Properties();
                props.load(tis);
                Property propertyTask = new Property();
                propertyTask.bindToOwner(this);
                propertyTask.setPrefix(this.prefix);
                propertyTask.setPrefixValues(this.prefixValues);
                propertyTask.addProperties(props);
            }
        }
        catch (IOException ioe) {
            try {
                throw new BuildException("Unable to load file: " + ioe, ioe, this.getLocation());
            }
            catch (Throwable throwable) {
                FileUtils.close(bis);
                FileUtils.close(tis);
                throw throwable;
            }
        }
        FileUtils.close(bis);
        FileUtils.close(tis);
    }

    public final void addFilterChain(FilterChain filter) {
        this.filterChains.addElement(filter);
    }

    public synchronized void addConfigured(ResourceCollection a) {
        if (this.src != null) {
            throw new BuildException("only a single source is supported");
        }
        if (a.size() != 1) {
            throw new BuildException("only single-element resource collections are supported");
        }
        this.src = a.iterator().next();
    }

    private synchronized JavaResource getRequiredJavaResource() {
        if (this.src == null) {
            this.src = new JavaResource();
            this.src.setProject(this.getProject());
        } else if (!(this.src instanceof JavaResource)) {
            throw new BuildException("expected a java resource as source");
        }
        return (JavaResource)this.src;
    }
}

