/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.remotecontrol;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionListener;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.preferences.DefaultTabPreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSettingFactory;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.VerticallyScrollablePanel;
import org.openstreetmap.josm.io.remotecontrol.PermissionPrefWithDefault;
import org.openstreetmap.josm.io.remotecontrol.RemoteControl;
import org.openstreetmap.josm.io.remotecontrol.handler.RequestHandler;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public final class RemoteControlPreference
extends DefaultTabPreferenceSetting {
    private final Map<PermissionPrefWithDefault, JCheckBox> prefs = new LinkedHashMap<PermissionPrefWithDefault, JCheckBox>();
    private JCheckBox enableRemoteControl;
    private final JCheckBox loadInNewLayer = new JCheckBox(I18n.tr("Download as new layer", new Object[0]));
    private final JCheckBox alwaysAskUserConfirm = new JCheckBox(I18n.tr("Confirm all Remote Control actions manually", new Object[0]));

    private RemoteControlPreference() {
        super("remotecontrol", I18n.tr("Remote Control", new Object[0]), I18n.tr("Settings for the remote control feature.", new Object[0]));
        for (PermissionPrefWithDefault p : PermissionPrefWithDefault.getPermissionPrefs()) {
            JCheckBox cb = new JCheckBox(p.preferenceText);
            cb.setSelected(p.isAllowed());
            this.prefs.put(p, cb);
        }
    }

    @Override
    public void addGui(PreferenceTabbedPane gui) {
        VerticallyScrollablePanel remote = new VerticallyScrollablePanel(new GridBagLayout());
        JLabel descLabel = new JLabel("<html>" + I18n.tr("Allows JOSM to be controlled from other applications, e.g. from a web browser.", new Object[0]) + "</html>");
        descLabel.setFont(descLabel.getFont().deriveFont(0));
        remote.add((Component)descLabel, GBC.eol().insets(5, 5, 0, 10).fill(2));
        JLabel portLabel = new JLabel("<html>" + I18n.tr("JOSM will always listen at <b>port {0}</b> (http) on localhost.<br>This port is not configurable because it is referenced by external applications talking to JOSM.", Config.getPref().get("remote.control.port", "8111")) + "</html>");
        portLabel.setFont(portLabel.getFont().deriveFont(0));
        remote.add((Component)portLabel, GBC.eol().insets(5, 5, 0, 10).fill(2));
        this.enableRemoteControl = new JCheckBox(I18n.tr("Enable remote control", new Object[0]), (boolean)RemoteControl.PROP_REMOTECONTROL_ENABLED.get());
        remote.add((Component)this.enableRemoteControl, GBC.eol());
        JPanel wrapper = new JPanel(new GridBagLayout());
        wrapper.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.gray)));
        remote.add((Component)wrapper, GBC.eol().fill(2).insets(5, 5, 5, 5));
        wrapper.add((Component)new JSeparator(), GBC.eop().fill(2).insets(15, 5, 15, 5));
        wrapper.add((Component)new JLabel(I18n.tr("Permitted actions:", new Object[0])), GBC.eol().insets(5, 0, 0, 0));
        for (JCheckBox p : this.prefs.values()) {
            wrapper.add((Component)p, GBC.eol().insets(15, 5, 0, 0).fill(2));
        }
        wrapper.add((Component)new JSeparator(), GBC.eop().fill(2).insets(15, 5, 15, 5));
        wrapper.add((Component)this.loadInNewLayer, GBC.eol().fill(2));
        wrapper.add((Component)this.alwaysAskUserConfirm, GBC.eol().fill(2));
        remote.add(Box.createVerticalGlue(), GBC.eol().fill(3));
        this.loadInNewLayer.setSelected(RequestHandler.LOAD_IN_NEW_LAYER.get());
        this.alwaysAskUserConfirm.setSelected(RequestHandler.GLOBAL_CONFIRMATION.get());
        ActionListener remoteControlEnabled = e -> GuiHelper.setEnabledRec(wrapper, this.enableRemoteControl.isSelected());
        this.enableRemoteControl.addActionListener(remoteControlEnabled);
        remoteControlEnabled.actionPerformed(null);
        this.createPreferenceTabWithScrollPane(gui, remote);
    }

    @Override
    public boolean ok() {
        boolean enabled = this.enableRemoteControl.isSelected();
        boolean changed = RemoteControl.PROP_REMOTECONTROL_ENABLED.put(enabled);
        if (enabled) {
            for (Map.Entry<PermissionPrefWithDefault, JCheckBox> p : this.prefs.entrySet()) {
                Config.getPref().putBoolean(p.getKey().pref, p.getValue().isSelected());
            }
            RequestHandler.LOAD_IN_NEW_LAYER.put(this.loadInNewLayer.isSelected());
            RequestHandler.GLOBAL_CONFIRMATION.put(this.alwaysAskUserConfirm.isSelected());
        }
        if (changed) {
            if (enabled) {
                RemoteControl.start();
            } else {
                RemoteControl.stop();
            }
        }
        return false;
    }

    @Override
    public String getHelpContext() {
        return HelpUtil.ht("/Preferences/RemoteControl");
    }

    public static class Factory
    implements PreferenceSettingFactory {
        @Override
        public PreferenceSetting createPreferenceSetting() {
            return new RemoteControlPreference();
        }
    }
}

