/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSocket;
import org.bouncycastle.jsse.BCApplicationProtocolSelector;
import org.bouncycastle.jsse.BCSNIMatcher;
import org.bouncycastle.jsse.BCSNIServerName;
import org.bouncycastle.jsse.java.security.BCAlgorithmConstraints;
import org.bouncycastle.jsse.provider.ProvSSLContextSpi;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
final class ProvSSLParameters {
    private final ProvSSLContextSpi context;
    private String[] cipherSuites;
    private String[] protocols;
    private boolean needClientAuth = false;
    private boolean wantClientAuth = false;
    private BCAlgorithmConstraints algorithmConstraints;
    private String endpointIdentificationAlgorithm;
    private boolean useCipherSuitesOrder = true;
    private List<BCSNIMatcher> sniMatchers;
    private List<BCSNIServerName> sniServerNames;
    private String[] applicationProtocols = new String[0];
    private BCApplicationProtocolSelector<SSLEngine> engineAPSelector;
    private BCApplicationProtocolSelector<SSLSocket> socketAPSelector;

    private static <T> List<T> copyList(Collection<T> collection) {
        if (collection == null) {
            return null;
        }
        if (collection.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(new ArrayList<T>(collection));
    }

    ProvSSLParameters(ProvSSLContextSpi provSSLContextSpi, String[] stringArray, String[] stringArray2) {
        this.context = provSSLContextSpi;
        this.cipherSuites = stringArray;
        this.protocols = stringArray2;
    }

    ProvSSLParameters copy() {
        ProvSSLParameters provSSLParameters = new ProvSSLParameters(this.context, this.cipherSuites, this.protocols);
        provSSLParameters.needClientAuth = this.needClientAuth;
        provSSLParameters.wantClientAuth = this.wantClientAuth;
        provSSLParameters.algorithmConstraints = this.algorithmConstraints;
        provSSLParameters.endpointIdentificationAlgorithm = this.endpointIdentificationAlgorithm;
        provSSLParameters.useCipherSuitesOrder = this.useCipherSuitesOrder;
        provSSLParameters.sniMatchers = this.sniMatchers;
        provSSLParameters.sniServerNames = this.sniServerNames;
        provSSLParameters.applicationProtocols = this.applicationProtocols;
        provSSLParameters.engineAPSelector = this.engineAPSelector;
        provSSLParameters.socketAPSelector = this.socketAPSelector;
        return provSSLParameters;
    }

    public String[] getCipherSuites() {
        return (String[])this.cipherSuites.clone();
    }

    public void setCipherSuites(String[] stringArray) {
        this.cipherSuites = this.context.getSupportedCipherSuites(stringArray);
    }

    public String[] getProtocols() {
        return (String[])this.protocols.clone();
    }

    String[] getProtocolsArray() {
        return this.protocols;
    }

    public void setProtocols(String[] stringArray) {
        if (!this.context.isSupportedProtocols(stringArray)) {
            throw new IllegalArgumentException("'protocols' cannot be null, or contain unsupported protocols");
        }
        this.protocols = (String[])stringArray.clone();
    }

    void setProtocolsArray(String[] stringArray) {
        this.protocols = stringArray;
    }

    public boolean getNeedClientAuth() {
        return this.needClientAuth;
    }

    public void setNeedClientAuth(boolean bl) {
        this.needClientAuth = bl;
        this.wantClientAuth = false;
    }

    public boolean getWantClientAuth() {
        return this.wantClientAuth;
    }

    public void setWantClientAuth(boolean bl) {
        this.needClientAuth = false;
        this.wantClientAuth = bl;
    }

    public BCAlgorithmConstraints getAlgorithmConstraints() {
        return this.algorithmConstraints;
    }

    public void setAlgorithmConstraints(BCAlgorithmConstraints bCAlgorithmConstraints) {
        this.algorithmConstraints = bCAlgorithmConstraints;
    }

    public String getEndpointIdentificationAlgorithm() {
        return this.endpointIdentificationAlgorithm;
    }

    public void setEndpointIdentificationAlgorithm(String string) {
        this.endpointIdentificationAlgorithm = string;
    }

    public boolean getUseCipherSuitesOrder() {
        return this.useCipherSuitesOrder;
    }

    public void setUseCipherSuitesOrder(boolean bl) {
        this.useCipherSuitesOrder = bl;
    }

    public List<BCSNIServerName> getServerNames() {
        return ProvSSLParameters.copyList(this.sniServerNames);
    }

    public void setServerNames(List<BCSNIServerName> list) {
        this.sniServerNames = ProvSSLParameters.copyList(list);
    }

    public Collection<BCSNIMatcher> getSNIMatchers() {
        return ProvSSLParameters.copyList(this.sniMatchers);
    }

    public void setSNIMatchers(Collection<BCSNIMatcher> collection) {
        this.sniMatchers = ProvSSLParameters.copyList(collection);
    }

    public String[] getApplicationProtocols() {
        return (String[])this.applicationProtocols.clone();
    }

    public void setApplicationProtocols(String[] stringArray) {
        this.applicationProtocols = (String[])stringArray.clone();
    }

    public BCApplicationProtocolSelector<SSLEngine> getEngineAPSelector() {
        return this.engineAPSelector;
    }

    public void setEngineAPSelector(BCApplicationProtocolSelector<SSLEngine> bCApplicationProtocolSelector) {
        this.engineAPSelector = bCApplicationProtocolSelector;
    }

    public BCApplicationProtocolSelector<SSLSocket> getSocketAPSelector() {
        return this.socketAPSelector;
    }

    public void setSocketAPSelector(BCApplicationProtocolSelector<SSLSocket> bCApplicationProtocolSelector) {
        this.socketAPSelector = bCApplicationProtocolSelector;
    }
}

