/*
 * Decompiled with CFR 0.152.
 */
package org.joni;

import org.jcodings.Encoding;
import org.jcodings.IntHolder;
import org.joni.Matcher;
import org.joni.Regex;

final class Search {
    static final Forward SLOW_FORWARD = new Forward(){

        @Override
        final String getName() {
            return "EXACT_FORWARD";
        }

        @Override
        final int search(Matcher matcher, byte[] text, int textP, int textEnd, int textRange) {
            Regex regex = matcher.regex;
            Encoding enc = regex.enc;
            byte[] target = regex.exact;
            int targetP = regex.exactP;
            int targetEnd = regex.exactEnd;
            int end2 = textEnd;
            if ((end2 -= targetEnd - targetP - 1) > textRange) {
                end2 = textRange;
            }
            for (int s2 = textP; s2 < end2; s2 += enc.length(text, s2, textEnd)) {
                int t;
                if (text[s2] != target[targetP]) continue;
                int p2 = s2 + 1;
                for (t = targetP + 1; t < targetEnd && target[t] == text[p2++]; ++t) {
                }
                if (t != targetEnd) continue;
                return s2;
            }
            return -1;
        }
    };
    static final Backward SLOW_BACKWARD = new Backward(){

        @Override
        final int search(Matcher matcher, byte[] text, int textP, int adjustText, int textEnd, int textStart, int s_, int range_) {
            Regex regex = matcher.regex;
            Encoding enc = regex.enc;
            byte[] target = regex.exact;
            int targetP = regex.exactP;
            int targetEnd = regex.exactEnd;
            int s2 = textEnd;
            int n = s2 = (s2 -= targetEnd - targetP) > textStart ? textStart : enc.leftAdjustCharHead(text, adjustText, s2, textEnd);
            while (s2 >= textP) {
                if (text[s2] == target[targetP]) {
                    int t;
                    int p2 = s2 + 1;
                    for (t = targetP + 1; t < targetEnd && target[t] == text[p2++]; ++t) {
                    }
                    if (t == targetEnd) {
                        return s2;
                    }
                }
                s2 = enc.prevCharHead(text, adjustText, s2, textEnd);
            }
            return -1;
        }
    };
    static final Forward SLOW_SB_FORWARD = new Forward(){

        @Override
        final String getName() {
            return "EXACT_SB_FORWARD";
        }

        @Override
        final int search(Matcher matcher, byte[] text, int textP, int textEnd, int textRange) {
            Regex regex = matcher.regex;
            byte[] target = regex.exact;
            int targetP = regex.exactP;
            int targetEnd = regex.exactEnd;
            int end2 = textEnd;
            if ((end2 -= targetEnd - targetP - 1) > textRange) {
                end2 = textRange;
            }
            for (int s2 = textP; s2 < end2; ++s2) {
                int t;
                if (text[s2] != target[targetP]) continue;
                int p2 = s2 + 1;
                for (t = targetP + 1; t < targetEnd && target[t] == text[p2++]; ++t) {
                }
                if (t != targetEnd) continue;
                return s2;
            }
            return -1;
        }
    };
    static final Backward SLOW_SB_BACKWARD = new Backward(){

        @Override
        final int search(Matcher matcher, byte[] text, int textP, int adjustText, int textEnd, int textStart, int s_, int range_) {
            Regex regex = matcher.regex;
            byte[] target = regex.exact;
            int targetP = regex.exactP;
            int targetEnd = regex.exactEnd;
            int s2 = textEnd;
            if ((s2 -= targetEnd - targetP) > textStart) {
                s2 = textStart;
            }
            while (s2 >= textP) {
                if (text[s2] == target[targetP]) {
                    int t;
                    int p2 = s2 + 1;
                    for (t = targetP + 1; t < targetEnd && target[t] == text[p2++]; ++t) {
                    }
                    if (t == targetEnd) {
                        return s2;
                    }
                }
                --s2;
            }
            return -1;
        }
    };
    static final Forward SLOW_IC_FORWARD = new Forward(){

        @Override
        final String getName() {
            return "EXACT_IC_FORWARD";
        }

        @Override
        final int search(Matcher matcher, byte[] text, int textP, int textEnd, int textRange) {
            Regex regex = matcher.regex;
            Encoding enc = regex.enc;
            byte[] target = regex.exact;
            int targetP = regex.exactP;
            int targetEnd = regex.exactEnd;
            int end2 = textEnd;
            if ((end2 -= targetEnd - targetP - 1) > textRange) {
                end2 = textRange;
            }
            byte[] buf = matcher.icbuf();
            for (int s2 = textP; s2 < end2; s2 += enc.length(text, s2, textEnd)) {
                if (!Search.lowerCaseMatch(target, targetP, targetEnd, text, s2, textEnd, enc, buf, regex.caseFoldFlag)) continue;
                return s2;
            }
            return -1;
        }
    };
    static final Backward SLOW_IC_BACKWARD = new Backward(){

        @Override
        final int search(Matcher matcher, byte[] text, int textP, int adjustText, int textEnd, int textStart, int s_, int range_) {
            Regex regex = matcher.regex;
            Encoding enc = regex.enc;
            byte[] target = regex.exact;
            int targetP = regex.exactP;
            int targetEnd = regex.exactEnd;
            int s2 = textEnd;
            s2 = (s2 -= targetEnd - targetP) > textStart ? textStart : enc.leftAdjustCharHead(text, adjustText, s2, textEnd);
            byte[] buf = matcher.icbuf();
            while (s2 >= textP) {
                if (Search.lowerCaseMatch(target, targetP, targetEnd, text, s2, textEnd, enc, buf, regex.caseFoldFlag)) {
                    return s2;
                }
                s2 = enc.prevCharHead(text, adjustText, s2, textEnd);
            }
            return -1;
        }
    };
    static final Forward SLOW_IC_SB_FORWARD = new Forward(){

        @Override
        final String getName() {
            return "EXACT_IC_SB_FORWARD";
        }

        @Override
        final int search(Matcher matcher, byte[] text, int textP, int textEnd, int textRange) {
            Regex regex = matcher.regex;
            byte[] toLowerTable = regex.enc.toLowerCaseTable();
            byte[] target = regex.exact;
            int targetP = regex.exactP;
            int targetEnd = regex.exactEnd;
            int end2 = textEnd;
            if ((end2 -= targetEnd - targetP - 1) > textRange) {
                end2 = textRange;
            }
            for (int s2 = textP; s2 < end2; ++s2) {
                int t;
                if (target[targetP] != toLowerTable[text[s2] & 0xFF]) continue;
                int p2 = s2 + 1;
                for (t = targetP + 1; t < targetEnd && target[t] == toLowerTable[text[p2++] & 0xFF]; ++t) {
                }
                if (t != targetEnd) continue;
                return s2;
            }
            return -1;
        }
    };
    static final Backward SLOW_IC_SB_BACKWARD = new Backward(){

        @Override
        final int search(Matcher matcher, byte[] text, int textP, int adjustText, int textEnd, int textStart, int s_, int range_) {
            Regex regex = matcher.regex;
            byte[] toLowerTable = regex.enc.toLowerCaseTable();
            byte[] target = regex.exact;
            int targetP = regex.exactP;
            int targetEnd = regex.exactEnd;
            int s2 = textEnd;
            if ((s2 -= targetEnd - targetP) > textStart) {
                s2 = textStart;
            }
            while (s2 >= textP) {
                if (target[targetP] == toLowerTable[text[s2] & 0xFF]) {
                    int t;
                    int p2 = s2 + 1;
                    for (t = targetP + 1; t < targetEnd && target[t] == toLowerTable[text[p2++] & 0xFF]; ++t) {
                    }
                    if (t == targetEnd) {
                        return s2;
                    }
                }
                --s2;
            }
            return -1;
        }
    };
    static final Forward BM_FORWARD = new Forward(){

        @Override
        final String getName() {
            return "EXACT_BM_FORWARD";
        }

        @Override
        final int search(Matcher matcher, byte[] text, int textP, int textEnd, int textRange) {
            Regex regex = matcher.regex;
            byte[] target = regex.exact;
            int targetP = regex.exactP;
            int targetEnd = regex.exactEnd;
            int tail = targetEnd - 1;
            int tlen1 = tail - targetP;
            int end2 = textRange + tlen1;
            int s2 = textP + tlen1;
            if (end2 > textEnd) {
                end2 = textEnd;
            }
            while (s2 < end2) {
                int p2 = s2;
                int t = tail;
                while (text[p2] == target[t]) {
                    if (t == targetP) {
                        return p2;
                    }
                    --p2;
                    --t;
                }
                if (s2 + 1 >= end2) break;
                s2 += regex.map[text[s2 + 1] & 0xFF];
            }
            return -1;
        }
    };
    static final Backward BM_BACKWARD = new Backward(){
        private static final int BM_BACKWARD_SEARCH_LENGTH_THRESHOLD = 100;

        @Override
        final int search(Matcher matcher, byte[] text, int textP, int adjustText, int textEnd, int textStart, int s_, int range_) {
            return SLOW_BACKWARD.search(matcher, text, textP, adjustText, textEnd, textStart, s_, range_);
        }

        private void setBmBackwardSkip(Regex regex, byte[] bytes2, int p2, int end2) {
            int i2;
            int[] skip2;
            if (regex.intMapBackward == null) {
                regex.intMapBackward = skip2 = new int[256];
            } else {
                skip2 = regex.intMapBackward;
            }
            int len = end2 - p2;
            for (i2 = 0; i2 < 256; ++i2) {
                skip2[i2] = len;
            }
            for (i2 = len - 1; i2 > 0; --i2) {
                skip2[bytes2[i2] & 0xFF] = i2;
            }
        }
    };
    static final Forward BM_IC_FORWARD = new Forward(){

        @Override
        final String getName() {
            return "EXACT_BM_IC_FORWARD";
        }

        @Override
        final int search(Matcher matcher, byte[] text, int textP, int textEnd, int textRange) {
            Regex regex = matcher.regex;
            Encoding enc = regex.enc;
            byte[] buf = matcher.icbuf();
            byte[] target = regex.exact;
            int targetP = regex.exactP;
            int targetEnd = regex.exactEnd;
            int tail = targetEnd - 1;
            int tlen1 = tail - targetP;
            int end2 = textRange + tlen1;
            int s2 = textP + tlen1;
            if (end2 > textEnd) {
                end2 = textEnd;
            }
            while (s2 < end2) {
                int p2 = s2 - tlen1;
                if (Search.lowerCaseMatch(target, targetP, targetEnd, text, p2, s2 + 1, enc, buf, regex.caseFoldFlag)) {
                    return p2;
                }
                if (s2 + 1 >= end2) break;
                s2 += regex.map[text[s2 + 1] & 0xFF];
            }
            return -1;
        }
    };
    static final Forward BM_NOT_REV_FORWARD = new Forward(){

        @Override
        final String getName() {
            return "EXACT_BM_NOT_REV_FORWARD";
        }

        @Override
        final int search(Matcher matcher, byte[] text, int textP, int textEnd, int textRange) {
            Regex regex = matcher.regex;
            Encoding enc = regex.enc;
            byte[] target = regex.exact;
            int end2 = textRange;
            int targetEnd = regex.exactEnd;
            int tail = targetEnd - 1;
            int targetP = regex.exactP;
            int tlen1 = tail - targetP;
            if (end2 + tlen1 > textEnd) {
                end2 = textEnd - tlen1;
            }
            int s2 = textP;
            while (s2 < end2) {
                int se;
                int p2 = se = s2 + tlen1;
                int t = tail;
                while (text[p2] == target[t]) {
                    if (t == targetP) {
                        return s2;
                    }
                    --p2;
                    --t;
                }
                if (s2 + 1 >= end2) break;
                byte skip2 = regex.map[text[se + 1] & 0xFF];
                t = s2;
                while ((s2 += enc.length(text, s2, textEnd)) - t < skip2 && s2 < end2) {
                }
            }
            return -1;
        }
    };
    static final Forward BM_NOT_REV_IC_FORWARD = new Forward(){

        @Override
        final String getName() {
            return "EXACT_BM_NOT_REV_IC_FORWARD";
        }

        @Override
        final int search(Matcher matcher, byte[] text, int textP, int textEnd, int textRange) {
            Regex regex = matcher.regex;
            Encoding enc = regex.enc;
            byte[] buf = matcher.icbuf();
            byte[] target = regex.exact;
            int end2 = textRange;
            int targetEnd = regex.exactEnd;
            int tail = targetEnd - 1;
            int targetP = regex.exactP;
            int tlen1 = tail - targetP;
            if (end2 + tlen1 > textEnd) {
                end2 = textEnd - tlen1;
            }
            int s2 = textP;
            while (s2 < end2) {
                int se = s2 + tlen1;
                if (Search.lowerCaseMatch(target, targetP, targetEnd, text, s2, se + 1, enc, buf, regex.caseFoldFlag)) {
                    return s2;
                }
                if (s2 + 1 >= end2) break;
                byte skip2 = regex.map[text[se + 1] & 0xFF];
                int t = s2;
                while ((s2 += enc.length(text, s2, textEnd)) - t < skip2 && s2 < end2) {
                }
            }
            return -1;
        }
    };
    static final Forward MAP_FORWARD = new Forward(){

        @Override
        final String getName() {
            return "MAP_FORWARD";
        }

        @Override
        final int search(Matcher matcher, byte[] text, int textP, int textEnd, int textRange) {
            Regex regex = matcher.regex;
            Encoding enc = regex.enc;
            byte[] map2 = regex.map;
            for (int s2 = textP; s2 < textRange; s2 += enc.length(text, s2, textEnd)) {
                if (map2[text[s2] & 0xFF] == 0) continue;
                return s2;
            }
            return -1;
        }
    };
    static final Backward MAP_BACKWARD = new Backward(){

        @Override
        final int search(Matcher matcher, byte[] text, int textP, int adjustText, int textEnd, int textStart, int s_, int range_) {
            Regex regex = matcher.regex;
            Encoding enc = regex.enc;
            byte[] map2 = regex.map;
            int s2 = textStart;
            if (s2 >= textEnd) {
                s2 = textEnd - 1;
            }
            while (s2 >= textP) {
                if (map2[text[s2] & 0xFF] != 0) {
                    return s2;
                }
                s2 = enc.prevCharHead(text, adjustText, s2, textEnd);
            }
            return -1;
        }
    };
    static final Forward MAP_SB_FORWARD = new Forward(){

        @Override
        final String getName() {
            return "MAP_SB_FORWARD";
        }

        @Override
        final int search(Matcher matcher, byte[] text, int textP, int textEnd, int textRange) {
            Regex regex = matcher.regex;
            byte[] map2 = regex.map;
            for (int s2 = textP; s2 < textRange; ++s2) {
                if (map2[text[s2] & 0xFF] == 0) continue;
                return s2;
            }
            return -1;
        }
    };
    static final Backward MAP_SB_BACKWARD = new Backward(){

        @Override
        final int search(Matcher matcher, byte[] text, int textP, int adjustText, int textEnd, int textStart, int s_, int range_) {
            Regex regex = matcher.regex;
            byte[] map2 = regex.map;
            int s2 = textStart;
            if (s2 >= textEnd) {
                s2 = textEnd - 1;
            }
            while (s2 >= textP) {
                if (map2[text[s2] & 0xFF] != 0) {
                    return s2;
                }
                --s2;
            }
            return -1;
        }
    };

    Search() {
    }

    private static boolean lowerCaseMatch(byte[] t, int tP, int tEnd, byte[] bytes2, int p2, int end2, Encoding enc, byte[] buf, int caseFoldFlag) {
        IntHolder holder = new IntHolder();
        holder.value = p2;
        while (tP < tEnd) {
            int lowlen = enc.mbcCaseFold(caseFoldFlag, bytes2, holder, end2, buf);
            if (lowlen == 1) {
                if (t[tP++] == buf[0]) continue;
                return false;
            }
            int q = 0;
            while (lowlen > 0) {
                if (t[tP++] != buf[q++]) {
                    return false;
                }
                --lowlen;
            }
        }
        return true;
    }

    static abstract class Backward {
        Backward() {
        }

        abstract int search(Matcher var1, byte[] var2, int var3, int var4, int var5, int var6, int var7, int var8);
    }

    static abstract class Forward {
        Forward() {
        }

        abstract String getName();

        abstract int search(Matcher var1, byte[] var2, int var3, int var4, int var5);
    }
}

